/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.session;

import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Identifiers;

public class SessionState {
    private final long created;
    private final String csrfToken;
    private final long expires;
    private final CompoundPrincipal principal;
    private static final long SESSION_DURATION = 3600000L;

    public SessionState(CompoundPrincipal principal) {
        this.principal = principal;
        this.csrfToken = Identifiers.randomIdentifier();
        this.created = System.currentTimeMillis();
        this.expires = System.currentTimeMillis() + 3600000L;
    }

    public String csrfToken() {
        return this.csrfToken;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionState other = (SessionState)obj;
        if (this.created != other.created) {
            return false;
        }
        if (this.csrfToken == null ? other.csrfToken != null : !this.csrfToken.equals(other.csrfToken)) {
            return false;
        }
        if (this.expires != other.expires) {
            return false;
        }
        return !(this.principal == null ? other.principal != null : !this.principal.equals((Object)other.principal));
    }

    public long expires() {
        return this.expires;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (this.csrfToken == null ? 0 : this.csrfToken.hashCode());
        result = 31 * result + (int)(this.expires ^ this.expires >>> 32);
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }

    public CompoundPrincipal principal() {
        return this.principal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionState [principal=");
        builder.append(this.principal);
        builder.append(", csrfToken=");
        builder.append(this.csrfToken);
        builder.append(", created=");
        builder.append(this.created);
        builder.append(", expires=");
        builder.append(this.expires);
        builder.append("]");
        return builder.toString();
    }
}

