/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.transcode;

import java.io.IOException;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.transcode.Transcoder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service
public class Transcoders {
    public Entity transform(Entity entity) {
        if (entity == null) {
            return null;
        }
        EntityHeaders headers = entity.headers();
        EntityHeader preferred = headers.header("X-APEX-PREFERRED-CONTENT-TYPE");
        ContentType from = this.from(headers);
        Object[] to = null;
        if (preferred == null) {
            if (ContentTypes.APEX_HTML.matches(from)) {
                to = new ContentType[]{ContentTypes.HTML};
            }
        } else {
            to = ContentType.contentTypes(preferred.values());
        }
        if (from == null || NullOrEmpty.nullOrEmpty((Object[])to) || from.matches((ContentType[])to)) {
            return entity;
        }
        Transcoder t = this.chooseTranscoder(from, (ContentType[])to);
        if (t != null) {
            return (Entity)t.apply(this.suppressContentLength(entity));
        }
        throw WebException.badRequest(Reason.reason(HttpHeader.CONTENT_TYPE.toString(), new TranslatableMessage(ResourceTemplateMessages.class, "Transcoders.0", "Cannot convert from: {0} to: {1}", new Object[]{from, Iterables.join((Iterable)preferred, (String)", ")})));
    }

    private Transcoder chooseTranscoder(ContentType from, ContentType ... to) {
        for (Transcoder t : ServiceLocator.acquireAll(Transcoder.class, (String[])new String[0])) {
            if (!t.canTransform(from, to)) continue;
            return t;
        }
        return null;
    }

    private ContentType from(EntityHeaders headers) {
        EntityHeader contentType = headers.header(HttpHeader.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        return ContentType.contentType(contentType.value());
    }

    private Entity suppressContentLength(Entity entity) {
        try {
            return Entities.entity(entity.body(), Entities.suppress(entity.headers(), HttpHeader.CONTENT_LENGTH));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }
}

