/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.uri;

import java.net.URI;
import oracle.dbtools.common.util.URIs;

public class URISandbox
implements Comparable<URISandbox> {
    private final URI root;

    private URISandbox(URI root) {
        this.root = root.normalize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URISandbox other = (URISandbox)obj;
        return !(this.root == null ? other.root != null : !this.root.toString().equals(other.toString()));
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return this.root.toString();
    }

    public URI uri(String path) {
        URI candidate = URIs.resolve((URI)this.root, (String)path);
        if (URIs.within((URI)this.root, (URI)(candidate = candidate.normalize()))) {
            return candidate;
        }
        return null;
    }

    public static URISandbox sandbox(URI root) {
        return new URISandbox(root);
    }

    @Override
    public int compareTo(URISandbox o) {
        return this.root.toString().compareTo(o.root.toString());
    }
}

