/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.uri;

import java.text.StringCharacterIterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Template;
import oracle.dbtools.common.util.URLEncoding;

public class URITemplate
extends Template
implements Comparable<URITemplate> {
    private final Pattern pattern;
    private final int priority;
    private static final char[] REGEX_CHARS = new char[]{'.', '\\', '?', '*', '+', '&', ':', '[', ']', '(', ')', '^', '$'};

    public URITemplate(String template) {
        this(template, 0);
    }

    public URITemplate(String template, int priority) {
        super(template);
        this.priority = priority;
        template = this.escapeRegexChars(template);
        this.pattern = this.getPattern(template);
    }

    @Override
    public int compareTo(URITemplate o) {
        int compare = this.priority - o.priority;
        if (compare == 0 && (compare = o.parameters().size() - this.parameters().size()) == 0) {
            return o.toString().compareTo(this.toString());
        }
        return compare;
    }

    public Map<String, String> decode(String uri) {
        if (null == uri) {
            throw new NullPointerException("uri cannot be null");
        }
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Matcher m = this.matcher(uri);
        if (m.matches()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                String match = m.group(i + 1);
                values.put(this.parameter(i), URLEncoding.decode((String)match));
            }
        }
        return values;
    }

    public String encode(Map<String, String> values) {
        return super.encode(values);
    }

    public boolean matches(String text) {
        Matcher m = this.matcher(text);
        return m.matches();
    }

    public int priority() {
        return this.priority;
    }

    private String escapeRegexChars(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            for (char needsEscaping : REGEX_CHARS) {
                if (needsEscaping != character) continue;
                result.append('\\');
            }
            result.append(character);
            character = iterator.next();
        }
        return result.toString();
    }

    private Pattern getPattern(String template) {
        String pattern = template;
        for (String parameter : this.parameters()) {
            pattern = pattern.replace('{' + this.escapeRegexChars(parameter) + '}', "(.+?)");
        }
        return Pattern.compile("^" + pattern + "$");
    }

    private Matcher matcher(String text) {
        return this.pattern.matcher(text);
    }
}

