/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Reflections;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.validation.Constraint;
import oracle.dbtools.rt.validation.ConstraintDescriptor;
import oracle.dbtools.rt.validation.ConstraintDescriptorImpl;
import oracle.dbtools.rt.validation.ConstraintValidator;
import oracle.dbtools.rt.validation.ConstraintViolation;
import oracle.dbtools.rt.validation.ViolationsBuilder;

@Service
public class Validator {
    public static final String SUPPORTED_CONSTRAINT = "oracle.dbtools.rt.validator.supportedConstraint";

    public <T> Set<ConstraintViolation<T>> validate(Iterable<T> objects) {
        LinkedHashSet<ConstraintViolation<T>> allViolations = new LinkedHashSet<ConstraintViolation<T>>();
        this.validate((Set<ConstraintViolation<T>>)allViolations, objects);
        return allViolations;
    }

    public <T> Set<ConstraintViolation<T>> validate(T ... objects) {
        return this.validate((Iterable<T>)Arrays.asList(objects));
    }

    private <T> void validate(Set<ConstraintViolation<T>> allViolations, Iterable<T> objects) {
        for (T object : objects) {
            if (object == null) continue;
            ViolationsBuilder<T> violations = new ViolationsBuilder<T>(object);
            Class<?> clazz = object.getClass();
            for (Field field : Validator.constrainedFields(clazz)) {
                Validator.validateField(violations, field, object);
            }
            allViolations.addAll(violations.violations());
        }
    }

    static <A extends Annotation> ConstraintDescriptor<A> constraintDescriptor(A annotation) {
        return (ConstraintDescriptor)Validator.constraintDescriptor().apply(annotation);
    }

    static Selector<Annotation> isConstraint() {
        return new Selector<Annotation>(){

            public Boolean apply(Annotation x) {
                return x.annotationType().getAnnotation(Constraint.class) != null;
            }
        };
    }

    private static Iterable<Field> constrainedFields(Class<?> clazz) {
        return Iterables.select((Iterable)Reflections.fields(clazz), (Selector)Selectors.and((Selector)Reflections.hasAnnotations(), Validator.hasConstraints()));
    }

    private static <T extends Annotation> Transform<T, ConstraintDescriptor<T>> constraintDescriptor() {
        return new Transform<T, ConstraintDescriptor<T>>(){

            public ConstraintDescriptor<T> apply(T x) {
                return new ConstraintDescriptorImpl(x);
            }
        };
    }

    private static <A extends Annotation, V> void defaultValidators(A annotation, List<ConstraintValidator<A, V>> validators) {
        for (ConstraintValidator validator : ServiceLocator.acquireAll(ConstraintValidator.class, (String[])new String[]{SUPPORTED_CONSTRAINT, annotation.annotationType().getName()})) {
            validators.add(validator);
        }
    }

    private static Selector<Field> hasConstraints() {
        return new Selector<Field>(){

            public Boolean apply(Field x) {
                return Iterables.contains((Iterable)Reflections.annotations((Field)x), Validator.isConstraint());
            }
        };
    }

    private static <V, T> void validate(ViolationsBuilder<T> violations, Iterable<ConstraintDescriptor<Annotation>> constraints, V value) {
        for (ConstraintDescriptor<Annotation> constraint : constraints) {
            Validator.validate(violations, value, constraint);
        }
    }

    private static <T, A extends Annotation, V> void validate(ViolationsBuilder<T> violations, V value, ConstraintDescriptor<A> descriptor) {
        List<ConstraintValidator<A, V>> validators = Validator.validators(value, descriptor);
        for (ConstraintValidator<A, V> constraintValidator : validators) {
            constraintValidator.initialize(descriptor.getAnnotation());
            if (constraintValidator.isValid(value)) continue;
            violations.violation(value, descriptor);
        }
        for (ConstraintDescriptor constraintDescriptor : descriptor.getComposingConstraints()) {
            Validator.validate(violations, value, constraintDescriptor);
        }
    }

    /*
     * Exception decompiling
     */
    private static <T, V> void validateField(ViolationsBuilder<T> violations, Field field, T object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <A extends Annotation, V> ConstraintValidator<A, V> validator(Class<? extends ConstraintValidator<A, ?>> validatorClass, V value) {
        return (ConstraintValidator)Reflections.newInstance(validatorClass);
    }

    private static <A extends Annotation, V> List<ConstraintValidator<A, V>> validators(V value, ConstraintDescriptor<A> descriptor) {
        ArrayList<ConstraintValidator<A, V>> validators = new ArrayList<ConstraintValidator<A, V>>();
        for (Class<ConstraintValidator<A, ?>> validatorClass : descriptor.getConstraintValidatorClasses()) {
            ConstraintValidator<A, V> validator = Validator.validator(validatorClass, value);
            validators.add(validator);
        }
        if (validators.isEmpty()) {
            Validator.defaultValidators(descriptor.getAnnotation(), validators);
        }
        return validators;
    }
}

