/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.util.URIs;

public abstract class BaseAndPath {
    private BaseAndPath() {
    }

    public static String[] baseAndPath(HttpServletRequest req) {
        try {
            URI baseUri = new URI(req.getScheme(), null, req.getServerName(), BaseAndPath.standardPort(req), req.getContextPath(), null, null);
            String base = baseUri.toString() + '/';
            String path = req.getRequestURI();
            path = path.substring(req.getContextPath().length());
            String queryString = req.getQueryString();
            if (queryString != null) {
                path = path + "?" + queryString;
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            return new String[]{base, path, null};
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri((URISyntaxException)e);
        }
    }

    private static int standardPort(HttpServletRequest req) {
        int serverPort = req.getServerPort();
        if ("http".equalsIgnoreCase(req.getScheme()) && 80 == serverPort || "https".equalsIgnoreCase(req.getScheme()) && 443 == serverPort) {
            serverPort = -1;
        }
        return serverPort;
    }
}

