/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.Regex;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class ContentType
implements CharSequence {
    private final Map<String, String> parameters;
    private final String subType;
    private final String suffix;
    private final String type;
    static final String CONTENT_TYPE_REGEXP = "^(\\p{Alpha}+|\\*)/([\\p{Alpha}\\.\\+-]+|\\*|\\*\\+\\p{Alpha}+)(;\\s*(.+))?$";
    private static final Pattern CONTENT_PARAM = Pattern.compile("\\s*([^=\\s,]*)=([^=\\s,\"]*)");
    private static final Pattern CONTENT_TYPE = Pattern.compile("^(\\p{Alpha}+|\\*)/([\\p{Alpha}\\.\\+-]+|\\*|\\*\\+\\p{Alpha}+)(;\\s*(.+))?$");

    private ContentType(String type, String subType, String suffix, Map<String, String> parameters) {
        this.type = type;
        this.subType = subType;
        this.suffix = suffix;
        this.parameters = parameters;
    }

    public ContentType changeSuffix(String suffix) {
        if (this.suffix != null) {
            return new ContentType(this.type, this.subType, suffix, this.parameters);
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public boolean equals(Object other) {
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    public boolean matches(ContentType ... candidates) {
        for (ContentType candidate : candidates) {
            if (candidate == null || !"*".equals(candidate.type) && !candidate.type.equalsIgnoreCase(this.type) || !"*".equals(candidate.subType) && !candidate.subType.equalsIgnoreCase(this.subType) || (candidate.suffix != null || this.suffix != null) && !candidate.suffix.equalsIgnoreCase(this.suffix) || (!candidate.parameters.isEmpty() || !this.parameters.isEmpty()) && !Maps.contains(this.parameters, candidate.parameters)) continue;
            return true;
        }
        return false;
    }

    public String mediaType() {
        return this.toString();
    }

    public String parameter(String param) {
        return this.parameters.get(this.keyIgnoreCase(param));
    }

    public ContentType removeParameter(String param) {
        String found = this.keyIgnoreCase(param);
        if (found != null) {
            LinkedHashMap<String, String> mutated = new LinkedHashMap<String, String>();
            mutated.putAll(this.parameters);
            mutated.remove(found);
            return new ContentType(this.type, this.subType, this.suffix, mutated);
        }
        return this;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.type);
        b.append("/");
        b.append(this.subType);
        if (this.suffix != null) {
            b.append('+');
            b.append(this.suffix);
        }
        if (!this.parameters.isEmpty()) {
            b.append("; ");
            b.append(Maps.join(this.parameters, (String)"=", (String)","));
        }
        return b.toString();
    }

    private String keyIgnoreCase(String param) {
        String found = null;
        for (String key : this.parameters.keySet()) {
            if (!key.equalsIgnoreCase(param)) continue;
            found = key;
        }
        return found;
    }

    public static ContentType contentType(CharSequence mediaType) {
        Map<String, String> parameters;
        String suffix;
        String subType;
        String type;
        if (mediaType == null) {
            return null;
        }
        Matcher m = CONTENT_TYPE.matcher(mediaType);
        if (m.find()) {
            type = m.group(1);
            subType = m.group(2);
            int lastPlus = subType.lastIndexOf(43);
            if (lastPlus == -1 || lastPlus == subType.length() - 1) {
                suffix = null;
            } else {
                suffix = subType.substring(lastPlus + 1);
                subType = subType.substring(0, lastPlus);
            }
            parameters = m.groupCount() > 2 ? ContentType.getParams(m) : Collections.emptyMap();
        } else {
            throw WebException.badRequest(Reason.reason("contentType", new TranslatableMessage(ResourceTemplateMessages.class, "ContentType.0", "Invalid Content Type value", new Object[0])));
        }
        return new ContentType(type, subType, suffix, parameters);
    }

    public static ContentType[] contentTypes(Iterable<String> contentTypes) {
        ArrayList ct = new ArrayList();
        Iterables.add(ct, (Iterable)Iterables.transform(contentTypes, (Transform)new Transform<String, ContentType>(){

            public ContentType apply(String x) {
                return ContentType.contentType(x);
            }
        }));
        return ct.toArray(new ContentType[ct.size()]);
    }

    public static ContentType[] contentTypes(String ... contentTypes) {
        ContentType[] ct = new ContentType[contentTypes.length];
        for (int i = 0; i < contentTypes.length; ++i) {
            ct[i] = ContentType.contentType(contentTypes[i]);
        }
        return ct;
    }

    public static boolean matches(ContentType[] types, ContentType ... candidates) {
        for (ContentType type : types) {
            if (!type.matches(candidates)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> getParams(Matcher m) {
        if (null == m.group(4)) {
            return Collections.EMPTY_MAP;
        }
        return Regex.getMatchPairs((Pattern)CONTENT_PARAM, (String)m.group(4));
    }
}

