/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.rt.web.Cookie;
import oracle.dbtools.rt.web.CookieWrapper;

public class CookieBuilder {
    private String comment;
    private String domain;
    private int maxAge = -1;
    private final String name;
    private String path;
    private boolean secure;
    private final String value;
    private int version;

    private CookieBuilder(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Cookie cookie(String name, String value) {
        return CookieBuilder.builder(name, value).path("/").build();
    }

    public static CookieBuilder builder(String name, String value) {
        return new CookieBuilder(name, value);
    }

    public CookieBuilder comment(String comment) {
        this.comment = comment;
        return this;
    }

    public CookieBuilder domain(String domain) {
        this.domain = domain;
        return this;
    }

    public CookieBuilder maxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CookieBuilder path(String path) {
        this.path = path;
        return this;
    }

    public CookieBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public CookieBuilder version(int version) {
        this.version = version;
        return this;
    }

    public Cookie build() {
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(this.name, this.value);
        if (this.comment != null) {
            c.setComment(this.comment);
        }
        if (this.domain != null) {
            c.setDomain(this.domain);
        }
        c.setMaxAge(this.maxAge);
        if (this.path != null) {
            c.setPath(this.path);
        }
        c.setSecure(this.secure);
        if (this.version > 0) {
            c.setVersion(this.version);
        }
        CookieWrapper cookie = new CookieWrapper(c);
        return cookie;
    }

    public String toString() {
        return this.build().toString();
    }

    static void setCookies(HttpServletResponse response, Iterable<Cookie> cookies) {
        for (Cookie c : cookies) {
            response.addCookie(((CookieWrapper)c).cookie());
        }
    }
}

