/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.dbtools.common.config.Configuration;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpHeader;

abstract class ForceSecure {
    private static boolean forceHttps = false;
    private static final int HTTPS_PORT = 443;
    private static final String HTTPS_SCHEME = "https";
    private static final ConfigurationEventListener LISTENER = new ConfigurationEventListener(){

        public void configurationChanged(String name, Configuration newConf) {
            forceHttps = (Boolean)PrimitiveTypes.valueOf((String)newConf.get("security.forceHTTPS", "false"), Boolean.class);
            if (forceHttps) {
                LOG.info("All requests are being treated as HTTPS requests");
            }
        }

        public void configurationRemoved(String name) {
        }
    };
    private static final Log LOG = Log.get(DispatchLog.class);

    private ForceSecure() {
    }

    static final Pair<HttpServletRequest, HttpServletResponse> filter(HttpServletRequest req, HttpServletResponse res) {
        if (forceHttps) {
            URI httpsRequestUri = ForceSecure.httpsRequestUri(req);
            ForceHttpsRequest httpsRequest = new ForceHttpsRequest(httpsRequestUri, req);
            URI documentBase = ForceSecure.documentBaseUri(httpsRequestUri);
            ForceHttpsResponse httpsResponse = new ForceHttpsResponse(documentBase, res);
            return Pair.pair((Object)((Object)httpsRequest), (Object)((Object)httpsResponse));
        }
        return Pair.pair((Object)req, (Object)res);
    }

    static void setup() {
        ConfigurationsProvider.INSTANCE.addListener("defaults", LISTENER);
    }

    static void teardown() {
        forceHttps = false;
        ConfigurationsProvider.INSTANCE.removeListener(LISTENER);
    }

    private static URI documentBaseUri(URI requestPath) {
        return requestPath.resolve("./");
    }

    private static URI httpsRequestUri(HttpServletRequest req) {
        try {
            URI requestUri = new URI(HTTPS_SCHEME, null, req.getServerName(), -1, URLEncoding.decode((String)req.getRequestURI()), null, null);
            return requestUri;
        }
        catch (URISyntaxException e) {
            throw URIs.illegalUri((URISyntaxException)e);
        }
    }

    private static class ForceHttpsResponse
    extends HttpServletResponseWrapper {
        private final URI documentBase;

        public ForceHttpsResponse(URI documentBase, HttpServletResponse response) {
            super(response);
            this.documentBase = documentBase;
        }

        public void addHeader(String name, String value) {
            value = this.resolve(name, value);
            super.addHeader(name, value);
        }

        public void sendRedirect(String location) throws IOException {
            location = this.resolve(location);
            super.sendRedirect(location);
        }

        public void setHeader(String name, String value) {
            value = this.resolve(name, value);
            super.setHeader(name, value);
        }

        private final String resolve(String location) {
            return URIs.resolve((URI)this.documentBase, (String)location).toString();
        }

        private String resolve(String name, String value) {
            if (HttpHeader.LOCATION.matches(name)) {
                value = this.resolve(value);
            }
            return value;
        }
    }

    private static class ForceHttpsRequest
    extends HttpServletRequestWrapper {
        private final URI requestUri;

        ForceHttpsRequest(URI requestUri, HttpServletRequest request) {
            super(request);
            this.requestUri = requestUri;
        }

        public int getLocalPort() {
            return 443;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.requestUri.toString());
        }

        public String getScheme() {
            return ForceSecure.HTTPS_SCHEME;
        }

        public int hashCode() {
            return this.getRequest().hashCode();
        }

        public boolean isSecure() {
            return true;
        }

        public String toString() {
            return this.getRequest().toString();
        }
    }
}

