/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.Forms;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.URLEncoding;

public class QueryString
extends MultiAssociativeArrays.Base<String, String> {
    private final MultiAssociativeArray<String, String> parameters;
    private final String path;
    private static final MultiAssociativeArray<String, String> NO_QUERY_STRING = MultiAssociativeArrays.builder().build();

    private QueryString(String path, MultiAssociativeArray<String, String> parameters) {
        this.path = path;
        this.parameters = parameters;
    }

    public String get(Object key) {
        return (String)this.parameters.get(key);
    }

    public Iterator<String> iterator() {
        return this.parameters.iterator();
    }

    public QueryString put(AssociativeArray<String, String> values) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.put(values));
    }

    public QueryString put(String key, String value) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.put((Object)key, (Object)value));
    }

    public QueryString remove(MultiAssociativeArray<String, String> toRemove) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.remove(toRemove));
    }

    public QueryString remove(String key, String value) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.remove((Object)key, (Object)value));
    }

    public MultiAssociativeArray<String, String> replace(MultiAssociativeArray<String, String> toReplace) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.replace(toReplace));
    }

    public QueryString replace(String key, String value) {
        return this.queryString((MultiAssociativeArray<String, String>)this.parameters.replace((Object)key, (Object)value));
    }

    public String toString() {
        if (NullOrEmpty.nullOrEmpty((Iterable)((Object)this))) {
            return this.path;
        }
        StringBuilder b = new StringBuilder(this.path);
        b.append('?');
        b.append(Forms.encode(this.values().iterator()));
        return b.toString();
    }

    public Iterable<Pair<String, String>> values() {
        return this.parameters.values();
    }

    public List<String> values(Object key) {
        return this.parameters.values(key);
    }

    private QueryString queryString(MultiAssociativeArray<String, String> parameters) {
        return new QueryString(this.path, parameters);
    }

    public static QueryString parse(String path) {
        String[] segments;
        int questionMark = path.indexOf("?");
        if (questionMark == -1) {
            return new QueryString(path, NO_QUERY_STRING);
        }
        String text = path.substring(questionMark + 1);
        path = path.substring(0, questionMark);
        MultiAssociativeArrays.Builder parameters = MultiAssociativeArrays.builder();
        for (String segment : segments = text.split("&")) {
            String[] keyValue = segment.split("=");
            String key = URLEncoding.decode((String)keyValue[0]);
            String value = keyValue.length == 1 ? "" : keyValue[1];
            parameters.pair((Object)key, (Object)URLEncoding.decode((String)value));
        }
        return new QueryString(path, (MultiAssociativeArray<String, String>)parameters);
    }
}

