/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.PrintWriter;
import java.util.Locale;
import oracle.dbtools.common.TranslatableMessage;

public class Reason {
    private final TranslatableMessage reason;
    private final String target;

    private Reason(String target, TranslatableMessage reason) {
        this.target = target;
        this.reason = reason;
    }

    public TranslatableMessage reason() {
        return this.reason;
    }

    public String target() {
        return this.target;
    }

    public String toString(Locale locale) {
        return "BadRequestReason [reason=" + this.reason.toString(locale) + ", target=" + this.target + "]";
    }

    public String toString() {
        return "BadRequestReason [reason=" + this.reason + ", target=" + this.target + "]";
    }

    public static Reason reason(String target, TranslatableMessage reason) {
        return new Reason(target, reason);
    }

    public static void render(PrintWriter writer, Iterable<Reason> reasons) {
        writer.print("<ul>");
        for (Reason reason : reasons) {
            writer.print("<li>");
            writer.print(reason.reason());
            writer.print("</li>");
        }
        writer.print("</ul>");
    }
}

