/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.SessionVerifier;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.HttpResource;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

public abstract class RequestHandler
implements RequestDispatcher {
    private final String method;
    private final SecurityConfig security;
    private final URITemplate uriTemplate;
    private final boolean validateCSRFToken;
    public static final SecurityConfig NO_SECURITY = new SecurityConfig(SecurityConstraint.NONE, null, null);
    public static final SecurityConfig SECURE = new SecurityConfig(SecurityConstraint.SECURE, AuthenticationRealm.NONE, "sign-on?r={referrer}");
    public static final SecurityConfig SECURE_RESOURCE_TEMPLATE = new SecurityConfig(SecurityConstraint.SECURE_AND_AUTHENTICATED, AuthenticationRealm.RESOURCE_TEMPLATES, null);
    public static final SecurityConfig SECURE_SESSION = new SecurityConfig(SecurityConstraint.SECURE_AND_AUTHENTICATED, AuthenticationRealm.SESSION, "sign-on?r={referrer}");
    private static final String CSRF_FIELD_NAME = "csrf_token";

    protected RequestHandler(CharSequence method, SecurityConfig securityConfig, URITemplate uriTemplate, boolean validateCSRFToken) {
        this.method = ((Object)method).toString();
        this.security = securityConfig;
        this.uriTemplate = uriTemplate;
        this.validateCSRFToken = validateCSRFToken;
    }

    @Override
    public RequestDispatcher.Score canDispatch(RequestEntity request) {
        return this.choose(request);
    }

    @Override
    public final HttpResource dispatch(RequestDispatcher.Score score, RequestEntity request) throws IOException {
        if (score == null) {
            score = this.choose(request);
        }
        if (score.score() < 0) {
            throw WebException.notFound();
        }
        this.authorize(request);
        return this.dispatch(request);
    }

    protected abstract HttpResource dispatch(RequestEntity var1) throws IOException;

    protected int score(URITemplate uriTemplate, RequestPaths request) {
        return uriTemplate.priority();
    }

    protected SessionState session(RequestEntity request) {
        SessionState session = SessionVerifier.session(request);
        if (session == null) {
            throw RedirectException.notAuthorized(this.security.logonRedirect);
        }
        return session;
    }

    private void authorize(RequestEntity request) {
        request.verifySecurityConstraint(this.security.constraint, this.security.logonRedirect);
        this.crossSiteRequestForgeryProtection(request);
    }

    private RequestDispatcher.Score choose(RequestEntity request) {
        int score;
        if (this.method.equalsIgnoreCase(request.method()) && this.uriTemplate.matches(request.path()) && (score = this.score(this.uriTemplate, request)) >= 0) {
            return new RequestDispatcher.Score(score, this.security.scope, null);
        }
        return RequestDispatcher.NO_MATCH;
    }

    private void crossSiteRequestForgeryProtection(RequestEntity request) {
        if (this.validateCSRFToken && this.method.equals(HttpMethod.POST.method())) {
            SessionState session = this.session(request);
            String expectedToken = session.csrfToken();
            String actualToken = null;
            for (Pair<String, Object> field : Requests.formFields(request)) {
                String name = (String)field.first();
                if (!CSRF_FIELD_NAME.equals(name)) continue;
                actualToken = (String)field.second();
                break;
            }
            if (!expectedToken.equals(actualToken)) {
                throw RedirectException.notAuthorized(this.security.logonRedirect);
            }
        }
    }

    public static class SecurityConfig {
        private final SecurityConstraint constraint;
        private final String logonRedirect;
        private final AuthenticationRealm scope;

        public SecurityConfig(SecurityConstraint constraint, AuthenticationRealm realm, String logonRedirect) {
            this.constraint = constraint;
            this.scope = realm == null ? RequestDispatcher.NO_SECURITY_REALM : realm;
            this.logonRedirect = logonRedirect;
        }

        public SecurityConstraint constraint() {
            return this.constraint;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SecurityConfig other = (SecurityConfig)obj;
            if (this.constraint != other.constraint) {
                return false;
            }
            if (this.logonRedirect == null ? other.logonRedirect != null : !this.logonRedirect.equals(other.logonRedirect)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals((Object)other.scope));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.constraint == null ? 0 : this.constraint.hashCode());
            result = 31 * result + (this.logonRedirect == null ? 0 : this.logonRedirect.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public String logonRedirect() {
            return this.logonRedirect;
        }

        public AuthenticationRealm realm() {
            return this.scope;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SecurityConfig [constraint=");
            builder.append((Object)this.constraint);
            builder.append(", realm=");
            builder.append((Object)this.scope);
            builder.append(", logonRedirect=");
            builder.append(this.logonRedirect);
            builder.append("]");
            return builder.toString();
        }
    }
}

