/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.ResourceTemplateMessages;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaderBase;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.ApexHeaders;
import oracle.dbtools.rt.web.BaseAndPath;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.Cookie;
import oracle.dbtools.rt.web.CookieWrapper;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HTTPRequestEntityHeaders;
import oracle.dbtools.rt.web.HasRoles;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RedirectException;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestPaths;
import oracle.dbtools.rt.web.SecurityConstraint;
import oracle.dbtools.rt.web.WebException;

public final class Requests {
    public static final ContentType FORM_DATA = ContentType.contentType("application/x-www-form-urlencoded");
    private static final String REASON_REQUIRES_SECURE_ACCESS = "uri.scheme";
    private static boolean verifyTransport = true;

    private Requests() {
    }

    public static void acceptable(ContentType contentType, ContentType ... acceptable) {
        if (!NullOrEmpty.nullOrEmpty((Object[])acceptable) && !contentType.matches(acceptable)) {
            if (DispatchLog.isEnabled()) {
                DispatchLog.log(contentType + " is not an acceptable media type");
            }
            throw WebException.unsupportedMediaType();
        }
    }

    public static void acceptable(RequestEntity request, ContentType ... contentTypes) {
        Requests.acceptable(request.contentType(), new ContentType[0]);
    }

    public static Cookie cookie(RequestEntity request, String cookieName) {
        return Requests.wrapper(request).cookie(cookieName);
    }

    public static void doNotVerifyTransport() {
        verifyTransport = false;
    }

    public static List<Pair<String, Object>> formFields(RequestEntity request) {
        return Requests.wrapper(request).formFields;
    }

    public static RequestEntity forward(RequestEntity request, CharSequence path, boolean forceGet, EntityHeaders additionalHeaders) {
        EntityHeaders headers = request.headers();
        if (additionalHeaders != null) {
            headers = Entities.merge(request.headers(), additionalHeaders);
        }
        headers = Entities.merge(headers, Requests.forwardedPath(request, path, forceGet));
        Entity forwardedEntity = Entities.entity(StreamCopy.emptyStream(), headers);
        RequestEntityWrapper existingRequest = Requests.wrapper(request);
        return new RequestEntityWrapper(forwardedEntity, existingRequest.req, request.principal());
    }

    public static boolean hasContent(RequestEntity request) {
        String method = request.method();
        if (HttpMethod.GET.equals(method) || HttpMethod.HEAD.equals(method) || HttpMethod.DELETE.equals(method)) {
            return false;
        }
        return request.contentType() != null;
    }

    public static void invalidateSession(RequestEntity request) {
        Requests.wrapper(request).invalidateSession();
    }

    public static boolean isHtmlForm(RequestEntity request) {
        return FORM_DATA.matches(request.contentType());
    }

    public static boolean isStandardPort(RequestPaths request) {
        if (request instanceof HttpTransport) {
            return ((HttpTransport)((Object)request)).standardPort();
        }
        return false;
    }

    public static RequestEntity merge(RequestEntity existing, Entity updated) throws IOException {
        Entity mergedEntity = Entities.entity(updated.body(), Entities.merge(existing.headers(), updated.headers()));
        return new RequestEntityWrapper(mergedEntity, Requests.wrapper(existing).req, existing.principal());
    }

    public static Pair<String, String> pathAndQuery(RequestPaths request) {
        String path = request.path();
        String[] segments = path.split("\\?");
        if (segments.length == 1) {
            return Pair.pair((Object)path, null);
        }
        return Pair.pair((Object)segments[0], (Object)segments[1]);
    }

    public static RequestEntity principal(RequestEntity request, CompoundPrincipal authenticatedUser) {
        return new MutatedPrincipal(request, request.principal().identifiedAs((Iterable)authenticatedUser));
    }

    public static String remoteUser(RequestEntity request) {
        return request.principal().getName();
    }

    public static RequestEntity replacePrincipal(RequestEntity request, Principal principal, Class<? extends Principal> replaceTypesOf) {
        if (principal == null) {
            return request;
        }
        CompoundPrincipal existing = request.principal();
        CompoundPrincipal mutated = existing.replace(replaceTypesOf, principal);
        return new MutatedPrincipal(request, mutated);
    }

    public static RequestEntity request(HttpServletRequest request) throws IOException {
        Entity entity = Entities.entity((InputStream)request.getInputStream(), Requests.headers(request));
        return new RequestEntityWrapper(entity, request, null);
    }

    public static Object sessionAttribute(RequestEntity request, String attributeName) {
        return Requests.wrapper(request).sessionAttribute(attributeName);
    }

    public static TenantPrincipal tenant(RequestEntity request) {
        TenantPrincipal tenant = Requests.principal(request, TenantPrincipal.class);
        if (tenant == null) {
            tenant = TenantPrincipal.noTenant();
        }
        return tenant;
    }

    private static boolean checkConfig() {
        return (Boolean)PrimitiveTypes.valueOf((String)GlobalConfiguration.globalConfiguration().get("security.verifySSL", "true"), Boolean.class);
    }

    private static String documentBase(String base, String path) {
        URI context = URIs.create((String)base);
        URI absoluteUri = URIs.resolve((URI)context, (String)path);
        URI documentBase = absoluteUri.resolve("./");
        return documentBase.toString();
    }

    private static EntityHeaders forwardedPath(RequestPaths request, CharSequence path, boolean forceGet) {
        CharSequence[] values = null;
        values = forceGet ? new CharSequence[]{"X-APEX-METHOD", HttpMethod.GET, "X-APEX-PATH", path, "X-APEX-DOC-BASE", Requests.documentBase(request.base(), ((Object)path).toString())} : new CharSequence[]{"X-APEX-PATH", path, "X-APEX-DOC-BASE", Requests.documentBase(request.base(), ((Object)path).toString())};
        return Entities.headers(values);
    }

    private static EntityHeaders headers(HttpServletRequest request) {
        String charsetParameter;
        String[] baseAndPath = BaseAndPath.baseAndPath(request);
        String base = baseAndPath[0];
        String path = baseAndPath[1];
        String mediaType = request.getHeader(HttpHeader.CONTENT_TYPE.toString());
        ContentType contentType = null;
        String charset = Text.defaultEncoding();
        if (mediaType != null && (charsetParameter = (contentType = ContentType.contentType(mediaType)).parameter("charset")) != null) {
            contentType = contentType.removeParameter("charset");
            charset = charsetParameter;
        }
        return Entities.merge(Entities.suppress((EntityHeaders)new HTTPRequestEntityHeaders(request), ApexHeaders.ALL), Entities.headers("X-APEX-METHOD", request.getMethod(), "X-APEX-BASE", base, "X-APEX-PATH", path, "X-APEX-CHARSET", charset, "X-APEX-DOC-BASE", Requests.documentBase(base, path), HttpHeader.CONTENT_TYPE, contentType, "X-APEX-REMOTE-ADDRESS", request.getRemoteAddr()));
    }

    private static boolean isUserInRole(CompoundPrincipal compoundPrincipal, String name) {
        if (name == null) {
            return false;
        }
        for (Principal principal : compoundPrincipal) {
            if (!name.equals(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private static <T extends Principal> T principal(RequestEntity request, Class<T> type) {
        CompoundPrincipal root = request.principal();
        Principal principal = null;
        if (root != null && root instanceof CompoundPrincipal) {
            CompoundPrincipal compound = root;
            principal = compound.principal(type);
        }
        return (T)principal;
    }

    private static void verifySecurityConstraint(HttpTransport transport, CompoundPrincipal principal, SecurityConstraint securityConstraint, String logonRedirect) {
        if (securityConstraint != SecurityConstraint.NONE) {
            if ((securityConstraint == SecurityConstraint.SECURE || securityConstraint == SecurityConstraint.SECURE_AND_AUTHENTICATED) && Requests.verifyTransportRequired() && !transport.secure()) {
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log("must be accessed over https only");
                }
                throw WebException.forbidden().reasons(Reason.reason(REASON_REQUIRES_SECURE_ACCESS, new TranslatableMessage(ResourceTemplateMessages.class, "ResourceTemplate.0", "This resource must be accessed over HTTPS only", new Object[0])));
            }
            if ((securityConstraint == SecurityConstraint.AUTHENTICATED || securityConstraint == SecurityConstraint.SECURE_AND_AUTHENTICATED) && ((Object)principal.primary()).equals(AnonymousPrincipal.ANONYMOUS)) {
                if (DispatchLog.isEnabled()) {
                    DispatchLog.log("not a public resource, no user authenticated, not authorized");
                }
                if (logonRedirect == null) {
                    throw WebException.notAuthorized();
                }
                throw RedirectException.notAuthorized(logonRedirect);
            }
        }
    }

    private static boolean verifyTransportRequired() {
        return verifyTransport && Requests.checkConfig();
    }

    private static RequestEntityWrapper wrapper(RequestEntity request) {
        if (request instanceof RequestEntityWrapper) {
            RequestEntityWrapper wrapper = (RequestEntityWrapper)request;
            return wrapper;
        }
        if (request instanceof MutatedPrincipal) {
            return Requests.wrapper(((MutatedPrincipal)request).request);
        }
        throw new IllegalStateException("No RequestEntityWrapper found in this request");
    }

    private static class ServletRequestPrincipal
    implements Principal,
    HasRoles {
        private final HttpServletRequest request;

        ServletRequestPrincipal(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServletRequestPrincipal other = (ServletRequestPrincipal)obj;
            return !(this.request == null ? other.request != null : !this.request.equals(other.request));
        }

        @Override
        public String getName() {
            return this.request.getRemoteUser();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
            return result;
        }

        @Override
        public boolean isInRole(String role) {
            return this.request.isUserInRole(role);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private static final class RequestEntityWrapper
    implements RequestEntity,
    HttpTransport {
        private final Entity entity;
        private final List<Pair<String, Object>> formFields;
        private final CompoundPrincipal principal;
        private final HttpServletRequest req;
        private static final String SECURE_PROTOCOL = "https";

        private RequestEntityWrapper(Entity entity, HttpServletRequest req, CompoundPrincipal existingPrincipal) {
            this.req = req;
            this.principal = existingPrincipal == null ? RequestEntityWrapper.principal(req) : existingPrincipal;
            this.entity = Entities.merge(entity, (EntityHeaders)new ApexUserHeader(entity.headers(), this.principal));
            this.formFields = RequestEntityWrapper.formFields(req.getParameterMap());
        }

        @Override
        public String base() {
            EntityHeader h = this.entity.headers().header("X-APEX-BASE");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public InputStream body() throws IOException {
            return this.entity.body();
        }

        @Override
        public void close() throws IOException {
            this.entity.close();
        }

        @Override
        public ContentType contentType() {
            EntityHeader h = this.entity.headers().header(HttpHeader.CONTENT_TYPE);
            if (h == null) {
                return null;
            }
            return ContentType.contentType(h.value());
        }

        public Cookie cookie(String cookieName) {
            javax.servlet.http.Cookie[] all = this.req.getCookies();
            if (all != null) {
                for (javax.servlet.http.Cookie cookie : all) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    return new CookieWrapper(cookie);
                }
            }
            return null;
        }

        @Override
        public String documentBase() {
            EntityHeader h = this.entity.headers().header("X-APEX-DOC-BASE");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public EntityHeaders headers() {
            return this.entity.headers();
        }

        public void invalidateSession() {
            HttpSession session = this.req.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        @Override
        public boolean isUserInRole(String name) {
            return Requests.isUserInRole(this.principal, name);
        }

        @Override
        public String method() {
            EntityHeader h = this.entity.headers().header("X-APEX-METHOD");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public String path() {
            EntityHeader h = this.entity.headers().header("X-APEX-PATH");
            if (h == null) {
                return null;
            }
            return h.value();
        }

        @Override
        public CompoundPrincipal principal() {
            return this.principal;
        }

        @Override
        public boolean secure() {
            return SECURE_PROTOCOL.equals(this.req.getScheme()) || this.req.isSecure();
        }

        public Object sessionAttribute(String attributeName) {
            HttpSession session = this.req.getSession(false);
            if (session != null) {
                return session.getAttribute(attributeName);
            }
            return null;
        }

        @Override
        public boolean standardPort() {
            return this.secure() && this.req.getServerPort() == 443 || this.req.getServerPort() == 80;
        }

        public String toString() {
            return this.entity.toString();
        }

        @Override
        public void verifySecurityConstraint(SecurityConstraint securityConstraint, String logonRedirect) {
            RequestEntityWrapper transport = this;
            CompoundPrincipal principal = this.principal();
            Requests.verifySecurityConstraint(transport, principal, securityConstraint, logonRedirect);
        }

        private static List<Pair<String, Object>> formFields(Map<String, String[]> parameters) {
            ArrayList<Pair<String, Object>> formFields = new ArrayList<Pair<String, Object>>();
            if (parameters != null) {
                for (String name : parameters.keySet()) {
                    String[] values;
                    for (String value : values = parameters.get(name)) {
                        formFields.add((Pair<String, Object>)Pair.pair((Object)name, (Object)value));
                    }
                }
            }
            return formFields;
        }

        private static CompoundPrincipal principal(HttpServletRequest request) {
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                return CompoundPrincipal.anonymous();
            }
            return CompoundPrincipal.external((Principal)new ServletRequestPrincipal(request));
        }
    }

    private static final class MutatedPrincipal
    implements RequestEntity,
    HttpTransport {
        private final EntityHeaders headers;
        private final CompoundPrincipal mutated;
        private final RequestEntity request;

        private MutatedPrincipal(RequestEntity request, CompoundPrincipal mutated) {
            this.request = request;
            this.mutated = mutated;
            this.headers = new ApexUserHeader(request.headers(), this.mutated);
        }

        @Override
        public String base() {
            return this.request.base();
        }

        @Override
        public InputStream body() throws IOException {
            return this.request.body();
        }

        @Override
        public void close() throws IOException {
            this.request.close();
        }

        @Override
        public ContentType contentType() {
            return this.request.contentType();
        }

        @Override
        public String documentBase() {
            return this.request.documentBase();
        }

        @Override
        public EntityHeaders headers() {
            return this.headers;
        }

        @Override
        public boolean isUserInRole(String name) {
            return Requests.isUserInRole(this.principal(), name);
        }

        @Override
        public String method() {
            return this.request.method();
        }

        @Override
        public String path() {
            return this.request.path();
        }

        @Override
        public CompoundPrincipal principal() {
            return this.mutated;
        }

        @Override
        public boolean secure() {
            return ((HttpTransport)((Object)this.request)).secure();
        }

        @Override
        public boolean standardPort() {
            return ((HttpTransport)((Object)this.request)).standardPort();
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        public void verifySecurityConstraint(SecurityConstraint securityConstraint, String logonRedirect) {
            Requests.verifySecurityConstraint(this, this.principal(), securityConstraint, logonRedirect);
        }
    }

    private static interface HttpTransport {
        public boolean secure();

        public boolean standardPort();
    }

    private static final class ApexUserHeader
    implements EntityHeaders {
        private final Iterable<String> names;
        private final EntityHeaders target;
        private final String user;

        ApexUserHeader(EntityHeaders target, CompoundPrincipal principal) {
            this.target = target;
            this.user = principal == null ? null : principal.getName();
            if (this.user == null) {
                this.names = target;
            } else {
                LinkedHashSet<String> headers = new LinkedHashSet<String>();
                Iterators.add(headers, target.iterator());
                headers.add("X-APEX-USER");
                this.names = headers;
            }
        }

        @Override
        public int compareTo(EntityHeaders o) {
            return this.target.compareTo(o);
        }

        @Override
        public EntityHeader header(CharSequence name) {
            if (this.user != null && "X-APEX-USER".equalsIgnoreCase(((Object)name).toString())) {
                return new EntityHeaderBase("X-APEX-USER"){

                    @Override
                    public String toString() {
                        return Entities.string(this);
                    }

                    @Override
                    public Iterable<String> values() {
                        return Iterables.iterable((Object[])new String[]{ApexUserHeader.this.user});
                    }
                };
            }
            return this.target.header(name);
        }

        @Override
        public Iterator<String> iterator() {
            return this.names.iterator();
        }

        public String toString() {
            return Entities.toString(this);
        }
    }
}

