/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import oracle.dbtools.apex.ErrorResponse;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

class WebErrorResponse
implements ErrorResponse {
    private Throwable cause;
    private ByteArrayOutputStream errorContent;
    private final List<Reason> reasons = new ArrayList<Reason>();
    private HttpStatusCode statusCode = null;
    private Iterable<String> supportedMethods;

    WebErrorResponse() {
    }

    public void badRequest(String target, TranslatableMessage msg) {
        this.error(400);
        this.reasons(Reason.reason(target, msg));
    }

    public void error(int statusCode) {
        this.statusCode = HttpStatusCode.valueOf(statusCode);
    }

    public void error(WebException cause) {
        this.statusCode = cause.statusCode();
        this.cause = cause;
        Iterables.add(this.reasons, cause.reasons());
    }

    public ServletOutputStream getOutputStream(ServletOutputStream target) throws IOException {
        return new DeferErrorOuput(target);
    }

    public void internalError(Throwable cause) {
        this.error(500, cause);
    }

    public void methodNotAllowed(String method, String ... supportedMethods) {
        this.error(405);
        this.supportedMethods = Arrays.asList(supportedMethods);
    }

    public void notFound() {
        this.error(404);
    }

    public WebErrorResponse reasons(Iterable<Reason> reasons) {
        Iterables.add(this.reasons, reasons);
        return this;
    }

    public WebErrorResponse reasons(Reason ... reasons) {
        this.reasons(Iterables.iterable((Object[])reasons));
        return this;
    }

    public void serviceUnavailable(Throwable cause) {
        this.error(503, cause);
    }

    protected boolean hasError() {
        return this.statusCode != null;
    }

    Throwable cause() {
        return this.cause;
    }

    InputStream errorContent() {
        return new ByteArrayInputStream(this.errorContent.toByteArray());
    }

    Iterable<Reason> reasons() {
        return this.reasons;
    }

    HttpStatusCode statusCode() {
        return this.statusCode;
    }

    Iterable<String> supportedMethods() {
        return this.supportedMethods;
    }

    private void error(int statusCode, Throwable cause) {
        this.error(statusCode);
        this.cause = cause;
    }

    final class DeferErrorOuput
    extends ServletOutputStream {
        private final ServletOutputStream target;

        private DeferErrorOuput(ServletOutputStream target) {
            this.target = target;
        }

        public void flush() throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.flush();
            } else {
                this.target.flush();
            }
        }

        public void write(byte[] b) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b);
            } else {
                this.target.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b, off, len);
            } else {
                this.target.write(b, off, len);
            }
        }

        public void write(int b) throws IOException {
            if (WebErrorResponse.this.hasError()) {
                WebErrorResponse.this.errorContent.write(b);
            } else {
                this.target.write(b);
            }
        }
    }
}

