/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.apex.Version;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Maps;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Throwables;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URITemplate;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.DispatchLog;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.HttpStatusCode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.TemplateResourceGenerator;
import oracle.dbtools.rt.web.WebErrorResponse;

@Service
public class WebErrorResponses {
    private TemplateResourceGenerator errorTemplate;
    private TemplateResourceGenerator reasonTemplate;
    private URITemplate externalErrors = null;
    private final ConcurrentHashMap<HttpStatusCode, Entity> externalErrorPages = new ConcurrentHashMap();
    private static final String DEFAULT_EXTERNAL_PATTERN = "{status}.html";

    public WebErrorResponse errorResponse() {
        return new WebErrorResponse();
    }

    public void render(URI serverUri, LocalePreference localePreference, HttpServletResponse response, WebErrorResponse errors) throws IOException {
        if (errors.hasError()) {
            Throwable cause;
            HttpStatusCode statusCode = errors.statusCode();
            response.setStatus(statusCode.statusCode());
            if (HttpStatusCode.METHOD_NOT_ALLOWED == statusCode) {
                response.setHeader(HttpHeader.ALLOW.toString(), Iterables.join(errors.supportedMethods(), (String)", "));
            }
            if (HttpStatusCode.INTERNAL_SERVER_ERROR.equals((Object)statusCode) && (cause = errors.cause()) != null && DispatchLog.isEnabled()) {
                DispatchLog.log(cause);
            }
            if (statusCode.hasBody()) {
                if (this.hasExternalErrorPage(serverUri, statusCode)) {
                    this.renderExternalErrorPage(serverUri, response, statusCode);
                } else {
                    this.renderInternalErrorPage(localePreference, response, errors);
                }
            }
        }
    }

    private void renderExternalErrorPage(URI serverUri, HttpServletResponse response, HttpStatusCode statusCode) throws IOException {
        Entity resource = this.checkErrorPageExists(serverUri, statusCode);
        EntityHeaders headers = resource.headers();
        for (String header : headers) {
            if (header.toUpperCase().startsWith("X-APEX-")) continue;
            Iterable<String> values = headers.header(header).values();
            for (String value : values) {
                response.setHeader(header, value);
            }
        }
        Version.setServerHeader((HttpServletResponse)response);
        ServletOutputStream outputStream = response.getOutputStream();
        StreamCopy.drain((InputStream)resource.body(), (OutputStream)outputStream);
        outputStream.flush();
    }

    private boolean hasExternalErrorPage(URI serverUri, HttpStatusCode statusCode) {
        try {
            Entity resource = this.checkErrorPageExists(serverUri, statusCode);
            return resource != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Entity checkErrorPageExists(URI serverUri, HttpStatusCode statusCode) throws IOException {
        Entity resource = null;
        if (this.externalErrors != null) {
            resource = this.externalErrorPages.get((Object)statusCode);
            if (resource == null) {
                resource = this.externalPage(serverUri, statusCode);
            }
            if (resource != null) {
                this.externalErrorPages.putIfAbsent(statusCode, resource);
            }
        }
        return resource;
    }

    private Entity externalPage(URI serverUri, HttpStatusCode statusCode) throws IOException {
        String path = this.externalErrors.encode(Maps.toMap((String[])new String[]{"status", "" + statusCode.statusCode()}));
        URI pageUri = URIs.resolve((URI)serverUri, (String)path);
        URLConnection conn = null;
        InputStream body = null;
        try {
            Entity buffered;
            conn = pageUri.toURL().openConnection();
            Map<String, List<String>> hdrs = conn.getHeaderFields();
            EntityHeadersBuilder b = Entities.headers();
            for (String name : hdrs.keySet()) {
                if (name == null) continue;
                b.header((CharSequence)name, (Iterable)hdrs.get(name));
            }
            body = conn.getInputStream();
            Entity entity = buffered = Entities.buffer(Entities.entity(body, b.build()));
            return entity;
        }
        catch (MalformedURLException e) {
            throw UnrecoverableException.unrecoverable((Throwable)e);
        }
        finally {
            Closeables.close((Object)conn);
        }
    }

    private void renderInternalErrorPage(LocalePreference localePreference, HttpServletResponse response, WebErrorResponse errors) throws IOException {
        response.setContentType(ContentTypes.HTML.mediaType());
        Version.setServerHeader((HttpServletResponse)response);
        Text.setCharacterEncoding((ServletResponse)response);
        ServletOutputStream w = response.getOutputStream();
        StringBuilder reasonsText = new StringBuilder();
        for (Reason reason : errors.reasons()) {
            reasonsText.append(this.reasonTemplate.encode(localePreference, "target", reason.target(), "reason", reason.reason().toString(localePreference.iterator())));
        }
        String stackTrace = "";
        Throwable cause = errors.cause();
        HttpStatusCode statusCode = errors.statusCode();
        if (cause != null && this.includeStackTrace()) {
            stackTrace = Throwables.stackTrace((Throwable)cause);
        }
        String html = this.errorTemplate.encode(localePreference, "statusCode", Integer.toString(statusCode.statusCode()), "statusMessage", statusCode.message(), "reasons", reasonsText.toString(), "stackTrace", stackTrace);
        w.print(html);
        w.flush();
    }

    private boolean includeStackTrace() {
        return (Boolean)PrimitiveTypes.valueOf((String)GlobalConfiguration.globalConfiguration().get("debug.printDebugToScreen", "false"), Boolean.class);
    }

    protected void activate(ServiceProperties properties) {
        this.errorTemplate = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "error.html");
        this.reasonTemplate = TemplateResourceGenerator.templateFromUrl(ContentTypes.HTML, "reason.html");
        String externalPath = GlobalConfiguration.globalConfiguration().get("error.externalPath");
        if (externalPath != null) {
            String externalPattern = GlobalConfiguration.globalConfiguration().get("error.externalPattern", DEFAULT_EXTERNAL_PATTERN);
            this.externalErrors = new URITemplate(externalPath + '/' + externalPattern);
        }
    }
}

