/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.rt.web.ContentType;

public class MimeTypes {
    private static final String COMMENT = "^#.*$";
    private static final Map<String, String> MIME_TYPES;

    public static ContentType get(String path) {
        int lastDot;
        String type = null;
        if (path != null && (lastDot = path.lastIndexOf(46)) != -1 && lastDot != path.length() - 1) {
            String extension = path.substring(lastDot + 1);
            type = MIME_TYPES.get(extension.toLowerCase());
        }
        return ContentType.contentType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        BufferedReader reader;
        InputStream in;
        block7: {
            MIME_TYPES = new HashMap<String, String>();
            in = null;
            reader = null;
            try {
                in = MimeTypes.class.getResourceAsStream("mime.types");
                if (in == null) break block7;
                reader = new BufferedReader(Text.reader((InputStream)in));
                String line = reader.readLine();
                while (null != line) {
                    String[] segments;
                    if (!line.matches(COMMENT) && (segments = line.split("\\s+")).length > 1) {
                        String type = segments[0];
                        for (int i = 1; i < segments.length; ++i) {
                            String extension = segments[i].trim().toLowerCase();
                            if (extension.isEmpty()) continue;
                            MIME_TYPES.put(extension, type);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException iOException) {
                Closeables.close((Object[])new Closeable[]{reader, in});
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Closeable[]{reader, in});
                    throw throwable;
                }
            }
        }
        Closeables.close((Object[])new Closeable[]{reader, in});
    }
}

