/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web.content;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Projects;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.rt.locale.LocalePreference;
import oracle.dbtools.rt.uri.URISandbox;

public abstract class StaticContent {
    private static final Set<URI> SEARCH_LOCATIONS = new LinkedHashSet<URI>();
    private static final String STATIC_PATH = "../static/src/main/resources/";
    private static final String STATIC_PREFIX = "www/";

    private StaticContent() {
    }

    public static void setSearchStatic(boolean searchStatic) {
        URI staticResources = StaticContent.staticResources();
        if (staticResources != null) {
            if (searchStatic) {
                StaticContent.addLocation(staticResources);
            } else {
                StaticContent.removeLocation(staticResources);
            }
        }
    }

    public static URI uri(LocalePreference localePreference, String resourcePath) {
        URI uri = null;
        for (URI root : SEARCH_LOCATIONS) {
            URIs.Status status;
            URI l8nRoot = localePreference.choose(root);
            URISandbox sandbox = URISandbox.sandbox(l8nRoot);
            URI resource = sandbox.uri(resourcePath);
            if (resource == null || URIs.Status.DOES_NOT_EXIST == (status = URIs.status((URI)resource))) continue;
            uri = resource;
            break;
        }
        return uri;
    }

    static void addLocation(URI location) {
        URI staticLocation = StaticContent.staticLocation(location);
        if (URIs.exists((URI)staticLocation)) {
            SEARCH_LOCATIONS.add(staticLocation);
        }
    }

    static void removeLocation(URI location) {
        SEARCH_LOCATIONS.remove(StaticContent.staticLocation(location));
    }

    private static URI staticLocation(URI location) {
        return URIs.resolve((URI)location, (String)STATIC_PREFIX);
    }

    private static URI staticResources() {
        File project = Projects.project(StaticContent.class);
        return Files.file((File)project, (String)STATIC_PATH).toURI();
    }

    static {
        try {
            Enumeration<URL> cpRoots = Thread.currentThread().getContextClassLoader().getResources(STATIC_PREFIX);
            while (cpRoots.hasMoreElements()) {
                URL cpRoot = cpRoots.nextElement();
                if (cpRoot == null || !URIs.exists((URI)cpRoot.toURI())) continue;
                SEARCH_LOCATIONS.add(cpRoot.toURI());
            }
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable((Throwable)e);
        }
    }
}

