/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.ide.Version;
import oracle.ide.performance.PerformanceFormatter;
import oracle.ide.performance.PerformanceLogRecord;

final class PerformanceHandler
extends ConsoleHandler {
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing = !Boolean.getBoolean("ide.AssertTracingDisabled");

    public PerformanceHandler() {
        this.setFormatter(this.getFormatter("formatter", new PerformanceFormatter()));
        this.setFilter(this.getFilter("filter", new DebugBuildFilter()));
    }

    private Formatter getFormatter(String name, Formatter defaultValue) {
        return (Formatter)this.getPropertyObject(name, defaultValue);
    }

    private Filter getFilter(String name, Filter defaultValue) {
        return (Filter)this.getPropertyObject(name, defaultValue);
    }

    private Object getPropertyObject(String name, Object defaultValue) {
        String fullPropertyName = PerformanceHandler.class.getName() + "." + name;
        String val = LogManager.getLogManager().getProperty(fullPropertyName);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    private static final class DebugBuildFilter
    implements Filter {
        private DebugBuildFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return record instanceof PerformanceLogRecord && Version.DEBUG_BUILD == 1 && tracing;
        }
    }
}

