/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.util.NullArgumentException;

public final class MultiLock {
    private static final Comparator<Lock> LOCK_ORDER_COMPARATOR = new Comparator<Lock>(){

        @Override
        public int compare(Lock lock1, Lock lock2) {
            return System.identityHashCode(lock1.lock) - System.identityHashCode(lock2.lock);
        }
    };
    private final List<Lock> locks;

    public static MultiLock getReadLock(ReadWriteLock ... locks) {
        if (locks == null || locks.length == 0) {
            throw new IllegalArgumentException("must specify one or more locks");
        }
        return MultiLock.get(Arrays.asList(locks), Collections.<ReadWriteLock>emptySet());
    }

    public static MultiLock getWriteLock(ReadWriteLock ... locks) {
        if (locks == null || locks.length == 0) {
            throw new IllegalArgumentException("must specify one or more locks");
        }
        return MultiLock.get(Collections.<ReadWriteLock>emptySet(), Arrays.asList(locks));
    }

    public static MultiLock getCopyLock(ReadWriteLock src, ReadWriteLock dest) {
        if (src == null) {
            throw new NullArgumentException("null src lock");
        }
        if (dest == null) {
            throw new NullArgumentException("null dest lock");
        }
        return MultiLock.get(Collections.singleton(src), Collections.singleton(dest));
    }

    public static MultiLock get(Collection<ReadWriteLock> read, Collection<ReadWriteLock> write) {
        if (read == null) {
            throw new NullArgumentException("null read locks");
        }
        if (write == null) {
            throw new NullArgumentException("null write locks");
        }
        if (read.isEmpty() && write.isEmpty()) {
            throw new IllegalArgumentException("must specify one or more locks");
        }
        ArrayList<Lock> locks = new ArrayList<Lock>(read.size() + write.size());
        for (ReadWriteLock lock : read) {
            if (lock == null) {
                throw new NullArgumentException("null read lock");
            }
            if (write.contains(lock)) continue;
            locks.add(new ReadLock(lock));
        }
        for (ReadWriteLock lock : write) {
            if (lock == null) {
                throw new NullArgumentException("null write lock");
            }
            locks.add(new WriteLock(lock));
        }
        Collections.sort(locks, LOCK_ORDER_COMPARATOR);
        return new MultiLock(locks);
    }

    private MultiLock(List<Lock> locks) {
        this.locks = locks;
    }

    public void lock() {
        for (Lock lock : this.locks) {
            lock.lock();
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        try {
            for (int i = 0; i < this.locks.size(); ++i) {
                this.locks.get(i).lockInterruptibly();
            }
        }
        catch (InterruptedException e) {
            for (int j = i - 1; j >= 0; --j) {
                this.locks.get(j).unlock();
            }
            throw e;
        }
    }

    public boolean tryLock() {
        for (int i = 0; i < this.locks.size(); ++i) {
            if (this.locks.get(i).tryLock()) continue;
            for (int j = i - 1; j >= 0; --j) {
                this.locks.get(j).unlock();
            }
            return false;
        }
        return true;
    }

    public void unlock() {
        for (int j = this.locks.size() - 1; j >= 0; --j) {
            this.locks.get(j).unlock();
        }
    }

    private static final class WriteLock
    extends Lock {
        WriteLock(ReadWriteLock lock) {
            super(lock);
        }

        @Override
        public void lock() {
            this.lock.writeLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.writeLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryWriteLock();
        }

        @Override
        public void unlock() {
            this.lock.writeUnlock();
        }
    }

    private static final class ReadLock
    extends Lock {
        ReadLock(ReadWriteLock lock) {
            super(lock);
        }

        @Override
        public void lock() {
            this.lock.readLock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock.readLockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.lock.tryReadLock();
        }

        @Override
        public void unlock() {
            this.lock.readUnlock();
        }
    }

    private static abstract class Lock {
        protected final ReadWriteLock lock;

        Lock(ReadWriteLock lock) {
            this.lock = lock;
        }

        public abstract void lock();

        public abstract void lockInterruptibly() throws InterruptedException;

        public abstract boolean tryLock();

        public abstract void unlock();
    }
}

