/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;

public final class Names {
    private static InitialContext _cachedContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitialContext newInitialContext() {
        Class<Names> clazz = Names.class;
        synchronized (Names.class) {
            if (_cachedContext == null) {
                try {
                    _cachedContext = new InitialContext();
                }
                catch (NoInitialContextException e) {
                    throw Names.internalEx(e, "Unable to create an InitialContext.");
                }
                catch (NamingException e) {
                    throw Names.internalEx(e, "Unexpected exception while trying to create InitialContext");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _cachedContext;
        }
    }

    public static Object lookup(Context context, String name) {
        try {
            return context.lookup(name);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NamingException e) {
            throw Names.internalEx(e, "Unexpected exception while looking up object whose name is \"" + name + "\".");
        }
    }

    public static void bind(Context context, String name, Object obj) {
        try {
            context.rebind(name, obj);
        }
        catch (NameNotFoundException e) {
            Names.ensureSubcontexts(context, name, 1);
            try {
                context.rebind(name, obj);
            }
            catch (NamingException ne) {
                throw Names.internalEx(ne, "Unable to bind object whose name is \"" + name + "\" to the context.");
            }
        }
        catch (NamingException e) {
            throw Names.internalEx(e, "Unable to bind object whose name is \"" + name + "\" to the context.");
        }
    }

    public static void unbind(Context context, String name) {
        try {
            context.unbind(name);
        }
        catch (NamingException e) {
            throw Names.internalEx(e, "Unable to unbind object whose name is \"" + name + "\".");
        }
    }

    public static void createSubcontext(Context context, String name) {
        Names.ensureSubcontexts(context, name, 0);
    }

    private static void ensureSubcontexts(Context context, String name, int except) {
        StringTokenizer tok = new StringTokenizer(name, "/");
        int n = tok.countTokens() - except;
        try {
            Context curContext = context;
            for (int i = 0; i < n; ++i) {
                try {
                    curContext = curContext.createSubcontext(tok.nextToken());
                    continue;
                }
                catch (NameAlreadyBoundException e) {
                    // empty catch block
                }
            }
        }
        catch (NamingException e) {
            throw Names.internalEx(e, "Unable to create necesary subcontexts for object \"" + name + "\".");
        }
    }

    private static IllegalStateException internalEx(Exception cause, String mesg) {
        IllegalStateException ise = new IllegalStateException(mesg);
        ise.initCause(cause);
        return ise;
    }

    private Names() {
    }
}

