/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.css;

import java.io.IOException;
import java.io.Reader;
import oracle.javatools.parser.css.CSSTokenizer;
import oracle.javatools.parser.css.ParseException;
import oracle.javatools.parser.css.TokenizerUtil;

public class Tokenizer
extends CSSTokenizer {
    protected Reader reader;
    protected char[] readBuffer;
    protected int readPosition;
    protected int readCount;
    protected char[] buffer = new char[128];
    protected boolean replaceEscapedCharacters;
    protected boolean completeToken;
    protected int escapedCharacters;
    protected int currentEscapedCharacters;
    protected boolean returnErrorToken;

    public Tokenizer(Reader r) throws ParseException {
        this.returnErrorToken(false);
        this.replaceEscaped(true);
        this.completeToken(false);
        try {
            this.reader = r;
            this.readBuffer = new char[4096];
            this.setCurrentChar(this.nextChar());
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public Tokenizer(String s) throws ParseException {
        this.returnErrorToken(false);
        this.replaceEscaped(true);
        this.completeToken(false);
        try {
            this.reader = null;
            this.readBuffer = s.toCharArray();
            this.readPosition = 0;
            this.readCount = this.readBuffer.length;
            this.collapseCRNL(0);
            if (this.readCount == 0) {
                this.setCurrentChar(-1);
            } else {
                this.setCurrentChar(this.nextChar());
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void returnErrorToken(boolean useToken) {
        this.returnErrorToken = useToken;
    }

    public void replaceEscaped(boolean replace) {
        this.replaceEscapedCharacters = replace;
    }

    public void completeToken(boolean complete) {
        this.completeToken = complete;
    }

    public final boolean isNextEOF() {
        return this.current == -1;
    }

    @Override
    public void reset() {
        try {
            this.escapedCharacters = 0;
            this.start = 0;
            this.end = 0;
            this.position = 0;
            this.column = 0;
            this.line = 1;
            this.type = 13;
            this.readPosition = 0;
            if (this.reader == null) {
                this.readCount = this.readBuffer.length;
                this.collapseCRNL(0);
                if (this.readCount == 0) {
                    this.setCurrentChar(-1);
                } else {
                    this.setCurrentChar(this.nextChar());
                }
            } else {
                this.readCount = 0;
                this.setCurrentChar(this.nextChar());
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void setPosition(int newPosition, int newLine, int newColumn) {
        if (this.replaceEscapedCharacters || !this.completeToken) {
            throw new IllegalStateException("Can't set Tokenizer's position");
        }
        try {
            this.escapedCharacters = 0;
            this.start = 0;
            this.end = newPosition;
            this.position = newPosition;
            this.column = newColumn;
            this.line = newLine;
            this.type = 13;
            this.readPosition = 0;
            if (this.reader == null) {
                this.readCount = this.readBuffer.length;
                this.collapseCRNL(0);
                if (this.readCount == 0) {
                    this.setCurrentChar(-1);
                } else {
                    this.setCurrentChar(this.nextChar());
                }
            } else {
                this.readCount = 0;
                this.setCurrentChar(this.nextChar());
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getStart() {
        return this.start + (this.escapedCharacters - this.currentEscapedCharacters);
    }

    @Override
    public int getEnd() {
        return this.end + this.escapedCharacters;
    }

    public void clearBuffer() {
        if (this.position <= 0) {
            this.position = 0;
        } else {
            this.buffer[0] = this.buffer[this.position - 1];
            this.position = 1;
        }
    }

    public String getStringValue(int endOffset) {
        if (this.end - this.start + endOffset <= 0) {
            return "";
        }
        return new String(this.buffer, this.start, this.end - this.start + endOffset).intern();
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    @Override
    public int next() throws ParseException {
        this.currentEscapedCharacters = 0;
        this.blankCharacters = 0;
        this.start = this.position - 1;
        this.type = 13;
        this.nextToken();
        this.escapedCharacters += this.currentEscapedCharacters;
        this.end = this.position - this.endGap();
        if (!this.returnErrorToken() && this.type == -1) {
            throw new ParseException(this.errorMessage, this.line, this.column);
        }
        return this.type;
    }

    public int currentChar() {
        return this.buffer[this.end];
    }

    @Override
    protected void replaceEscapeSequance(int escStart, int escEnd) {
        int newPosition;
        int moveChar;
        if (!this.replaceEscapedCharacters) {
            return;
        }
        int n = moveChar = escEnd != this.position ? this.current : -1;
        if (TokenizerUtil.isCSSSpace(this.buffer[escEnd - 1])) {
            --escEnd;
        }
        int unicode = 0;
        int firstChar = this.buffer[escStart + 1];
        if (TokenizerUtil.isCSSHexadecimalCharacter((char)firstChar)) {
            for (int i = escStart + 1; i < escEnd; ++i) {
                int digit = Character.digit(this.buffer[i], 16);
                unicode = (unicode << 4) + digit;
            }
        } else {
            unicode = firstChar;
        }
        this.buffer[escStart] = (char)unicode;
        this.setCurrentCharEscaped(true);
        if (moveChar != -1) {
            this.buffer[escStart + 1] = (char)moveChar;
            newPosition = escStart + 2;
            this.currentEscapedCharacters += this.position - newPosition;
            this.position = newPosition;
        } else {
            newPosition = escStart + 1;
            this.currentEscapedCharacters += this.position - newPosition;
            this.position = newPosition;
        }
    }

    protected static boolean isEqualIgnoreCase(int i, char c) {
        return i == -1 ? false : Character.toLowerCase((char)i) == c;
    }

    @Override
    protected int nextChar() throws IOException {
        if (this.readPosition == this.readCount && !this.fillReadBuffer()) {
            this.current = -1;
            return -1;
        }
        if (this.current != 10) {
            ++this.column;
        } else {
            ++this.line;
            this.column = 1;
        }
        this.current = this.readBuffer[this.readPosition++];
        char ch = (char)this.current;
        if (this.position == this.buffer.length) {
            char[] t = new char[this.position * 3 / 2];
            System.arraycopy(this.buffer, 0, t, 0, this.position);
            this.buffer = t;
        } else if (this.position > this.buffer.length) {
            this.buffer = new char[this.position * 3 / 2];
        }
        char c = ch;
        this.buffer[this.position++] = c;
        return c;
    }

    private boolean fillReadBuffer() throws IOException {
        int read;
        if (this.readCount != 0) {
            if (this.readPosition == this.readCount) {
                this.readBuffer[0] = this.readBuffer[this.readCount - 1];
                this.readCount = 1;
                this.readPosition = 1;
            } else {
                System.arraycopy(this.readBuffer, this.readPosition - 1, this.readBuffer, 0, this.readCount - this.readPosition + 1);
                this.readCount = this.readCount - this.readPosition + 1;
                this.readPosition = 1;
            }
        }
        if (this.reader == null) {
            return this.readCount != this.readPosition;
        }
        int src = this.readCount - 1;
        if (src < 0) {
            src = 0;
        }
        if ((read = this.reader.read(this.readBuffer, this.readCount, this.readBuffer.length - this.readCount)) == -1) {
            return this.readCount != this.readPosition;
        }
        this.readCount += read;
        this.collapseCRNL(src);
        return this.readCount != this.readPosition;
    }

    private void collapseCRNL(int src) {
        while (src < this.readCount) {
            if (this.readBuffer[src] != '\r') {
                ++src;
                continue;
            }
            this.readBuffer[src] = 10;
            if (++src >= this.readCount) break;
            if (this.readBuffer[src] != '\n') continue;
            int dst = src++;
            while (src < this.readCount) {
                if (this.readBuffer[src] == '\r') {
                    this.readBuffer[dst++] = 10;
                    if (++src >= this.readCount) break;
                    if (this.readBuffer[src] != '\n') continue;
                    ++src;
                    continue;
                }
                this.readBuffer[dst++] = this.readBuffer[src++];
            }
            this.readCount = dst;
            break;
        }
    }

    @Override
    protected boolean returnCompleteToken() {
        return this.completeToken;
    }

    @Override
    protected boolean returnErrorToken() {
        return this.returnErrorToken;
    }
}

