/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import java.net.URL;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.internal.parser.ParserDriver;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFileSym;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceFile;

public class JavaParser {
    public static final String JOT_JDKVERSION_OVERRIDE = "Jot_JdkVersion_Override";
    private static final Logger LOG = Logger.getLogger(JavaParser.class.getName());
    @Deprecated
    public static byte j2se;
    private static JdkVersion jdkVersion;

    private static JdkVersion versionPropertyToJdkVersion(String property) {
        JdkVersion jdkVersion = null;
        if (property != null) {
            if (property.equals("1.3") || property.equals("13")) {
                jdkVersion = JdkVersion.JDK_1_3;
            } else if (property.equals("1.4") || property.equals("14")) {
                jdkVersion = JdkVersion.JDK_1_4;
            } else if (property.equals("1.5") || property.equals("15")) {
                jdkVersion = JdkVersion.JDK_1_5;
            } else if (property.equals("1.6") || property.equals("16")) {
                jdkVersion = JdkVersion.JDK_1_6;
            } else if (property.equals("1.7") || property.equals("17")) {
                jdkVersion = JdkVersion.JDK_1_7;
            } else if (property.equals("1.8") || property.equals("18")) {
                jdkVersion = JdkVersion.JDK_1_8;
            }
        }
        return jdkVersion;
    }

    private static boolean classExists(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static JdkVersion getJdkVersion() {
        return jdkVersion;
    }

    public static SourceFile parse(ReadTextBuffer textBuffer) {
        return JavaParser.parseImpl(textBuffer, JavaParser.getJdkVersion(), false);
    }

    @Deprecated
    public static SourceFile parse(ReadTextBuffer textBuffer, int j2se) {
        return JavaParser.parse(textBuffer, JdkVersion.getJdkVersion((byte)j2se));
    }

    public static SourceFile parse(ReadTextBuffer textBuffer, JdkVersion jdkVersion) {
        return JavaParser.parseImpl(textBuffer, jdkVersion, false);
    }

    @Deprecated
    public static JavaFile lightParse(ReadTextBuffer textBuffer, URL url, JavaProvider javaProvider, int j2se) {
        return JavaParser.lightParse(textBuffer, url, javaProvider, JdkVersion.getJdkVersion((byte)j2se));
    }

    public static JavaFile lightParse(ReadTextBuffer textBuffer, URL url, JavaProvider javaProvider, JdkVersion jdkVersion) {
        SourceFile sourceFile = JavaParser.parseImpl(textBuffer, jdkVersion, true);
        if (sourceFile == null) {
            return null;
        }
        sourceFile.setURL(url);
        sourceFile.setProvider(javaProvider);
        return new JavaFileSym(sourceFile);
    }

    private static SourceFile parseImpl(ReadTextBuffer textBuffer, JdkVersion jdkVersion, boolean lightParse) {
        JdkVersion jdkVersionOverride = JavaParser.versionPropertyToJdkVersion(System.getProperty(JOT_JDKVERSION_OVERRIDE));
        if (jdkVersionOverride != null) {
            jdkVersion = jdkVersionOverride;
        }
        ParserDriver driver = new ParserDriver();
        driver.setTextBuffer(textBuffer);
        try {
            SourceFile file = driver.parse(jdkVersion, lightParse);
            return file;
        }
        catch (CancellationException cancelEx) {
            throw cancelEx;
        }
        catch (ExpiredTextBufferException etbe) {
            throw etbe;
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean cancelParse(Thread thread) {
        return ParserDriver.cancelParse(thread);
    }

    public static Logger getLogger() {
        return LOG;
    }

    static {
        String property = System.getProperty("EDITOR_J2SE_VERSION");
        if (property != null) {
            jdkVersion = JavaParser.versionPropertyToJdkVersion(property);
        } else {
            String property2 = System.getProperty("EDITOR_ENABLE_ASSERT");
            if (property2 != null && property2.equals("false")) {
                jdkVersion = JdkVersion.JDK_1_3;
            }
        }
        if (jdkVersion == null) {
            jdkVersion = JavaParser.classExists("java.lang.annotation.Repeatable") || JavaParser.classExists("java.util.function.Function") ? JdkVersion.JDK_1_8 : (JavaParser.classExists("java.lang.AutoCloseable") ? JdkVersion.JDK_1_7 : JdkVersion.JDK_1_6);
        }
        j2se = jdkVersion.getJ2se();
    }
}

