/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import java.util.HashMap;
import java.util.Map;

public enum JdkVersion {
    JDK_UNKNOWN(0, ""),
    JDK_1_3(1, "1.3"),
    JDK_1_4(2, "1.4"),
    JDK_1_5(3, "1.5"),
    JDK_1_6(4, "1.6"),
    JDK_1_7(5, "1.7"),
    JDK_1_8(6, "1.8");

    private static Map<Byte, JdkVersion> j2seToJdkVersion;
    private byte j2se;
    private String version;

    public static JdkVersion getMinVersion() {
        JdkVersion[] jdkVersions = JdkVersion.values();
        return jdkVersions[0];
    }

    public static JdkVersion getMaxVersion() {
        JdkVersion[] jdkVersions = JdkVersion.values();
        return jdkVersions[jdkVersions.length - 1];
    }

    public boolean hasGenerics() {
        return this.j2se >= JdkVersion.JDK_1_5.j2se;
    }

    public boolean isJdk3OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_3.j2se;
    }

    public boolean isJdk4OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_4.j2se;
    }

    public boolean isJdk5OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_5.j2se;
    }

    public boolean isJdk6OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_6.j2se;
    }

    public boolean isJdk7OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_7.j2se;
    }

    public boolean isJdk8OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_8.j2se;
    }

    public static JdkVersion getJdkVersion(byte j2se) {
        JdkVersion version = j2seToJdkVersion.get(j2se);
        if (version != null) {
            return version;
        }
        return JDK_UNKNOWN;
    }

    public byte getJ2se() {
        return this.j2se;
    }

    public String getVersionString() {
        return this.version;
    }

    private JdkVersion(int j2se, String version) {
        this.j2se = (byte)j2se;
        this.version = version;
    }

    static {
        j2seToJdkVersion = new HashMap<Byte, JdkVersion>();
        for (JdkVersion jdkVersion : JdkVersion.values()) {
            j2seToJdkVersion.put(jdkVersion.j2se, jdkVersion);
        }
    }
}

