/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.ByteArrayInputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClParser;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.common.AbstractAnnotation;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.AbstractVariable;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.util.NullProvider;

public class ClClass
extends AbstractClass {
    private static final List kEmptyList = Collections.EMPTY_LIST;
    final JavaProvider provider;
    private final ClassFile classFile;
    private final JavaFile javaFile;
    protected Collection annotations;
    protected Map<String, ClTypeParameter> typeParameters = Collections.emptyMap();
    protected SignatureHasType superclass;
    protected Collection interfaceTypes;
    private Collection interfaces;
    private Collection<UnresolvedType> unresolvedInterfaces;
    private Map<String, List<ClMethod>> methods;
    private Collection constructors;
    private ClMethod clinitMethod;
    private Map<String, ClField> fields;
    private List<JavaClass> memberClasses;
    private List<JavaClass> anonymousClasses;
    private List<JavaClass> localClasses;
    private JavaClass cachedOwningClass = this;
    private SourceClass sourceClass;
    private WeakReference<SourceElement> cachedSourceElement;

    public ClClass(ClassFile classFile, JavaProvider provider) {
        this.classFile = classFile;
        if (provider != null) {
            this.provider = provider;
        } else {
            this.provider = NullProvider.getInstance();
            new NullPointerException("Null provider").printStackTrace();
        }
        this.javaFile = new ClFile(this, classFile.getURL());
        String signature = classFile.getSignature();
        if (signature != null) {
            this.parseSignature(signature);
            if (this.interfaceTypes == null) {
                this.interfaces = kEmptyCollection;
            }
        } else {
            Name nameType = classFile.getBaseClass();
            if (nameType != null) {
                this.superclass = new SignatureHasType('L', nameType.toString(), provider);
            }
        }
    }

    private void parseSignature(String signature) {
        ClParser parser = new ClParser(signature, this);
        parser.parseClassSignature0(this);
    }

    public ByteArrayInputStream getClassFileBytes() {
        return this.classFile.getBytes();
    }

    final ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public JavaFile getFile() {
        return this.javaFile;
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        String qualifiedName = this.getRawName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    @Override
    public String getSignature() {
        String signature = this.classFile.getSignature();
        if (signature != null) {
            return signature;
        }
        return super.getSignature();
    }

    @Override
    public boolean isInterface() {
        return (this.classFile.getModifiers() & 0x200) != 0;
    }

    @Override
    public String getQualifiedName() {
        JavaClass outerClass;
        String vmName;
        int lastDollar;
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isLocalClass() && (lastDollar = (vmName = this.getVMName()).lastIndexOf(36)) > 0) {
            int nameIndex;
            for (nameIndex = lastDollar + 1; nameIndex < vmName.length() && Character.isDigit(vmName.charAt(nameIndex)); ++nameIndex) {
            }
            nameIndex = nameIndex < vmName.length() ? nameIndex : lastDollar + 1;
            return vmName.substring(nameIndex);
        }
        vmName = this.getVMName();
        lastDollar = vmName.lastIndexOf(36);
        if (lastDollar != -1 && (outerClass = this.getOwningClass()) != null) {
            String shortName = vmName.substring(lastDollar + 1);
            String prefix = outerClass.getQualifiedName();
            if (prefix != null && !prefix.isEmpty()) {
                return prefix + '.' + shortName;
            }
            return shortName;
        }
        return vmName.replace('/', '.');
    }

    @Override
    public String getVMName() {
        return this.classFile.getFullClassName();
    }

    @Override
    public JavaPackage getPackage() {
        return this.provider.getPackage(this.getPackageName());
    }

    @Override
    public String getPackageName() {
        JavaClass owningClass = this.getOwningClass();
        if (owningClass != null) {
            return owningClass.getPackageName();
        }
        String qualifiedName = this.getRawName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return "";
    }

    @Override
    public boolean hasTypeParameters() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public Collection getTypeParameters() {
        return this.copyCollection(this.typeParameters.values());
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.typeParameters.get(name);
    }

    @Override
    public JavaType getSuperclass() {
        if (this.superclass != null) {
            Collection<ClassFile.TypeAnnotation> typeAnnotations = this.classFile.getTypeAnnotations();
            if (!typeAnnotations.isEmpty()) {
                List<JavaAnnotation> javaAnnotations = this.getSuperAnnotations(typeAnnotations, '\uffff');
                return this.superclass.getResolvedType(javaAnnotations, typeAnnotations);
            }
            return this.superclass.getResolvedType();
        }
        return null;
    }

    private List<JavaAnnotation> getSuperAnnotations(Collection<ClassFile.TypeAnnotation> typeAnnotations, char superIndex) {
        ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>();
        for (ClassFile.TypeAnnotation typeAnnotation : typeAnnotations) {
            ClassFile.SuperTargetInfo targetInfo;
            if (typeAnnotation.getTargetInfo().getTargetInfoType() == ClassFile.TargetInfoType.CLASS_EXTENDS && (targetInfo = (ClassFile.SuperTargetInfo)typeAnnotation.getTargetInfo()).getSuperIndex() == superIndex) {
                javaAnnotations.add(new ClAnnotation(this, typeAnnotation.getClassAnnotation()));
                continue;
            }
            javaAnnotations.add(null);
        }
        return javaAnnotations;
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        if (this.superclass != null) {
            return this.superclass.getUnresolvedType();
        }
        return QuickUnresolvedType.createUnresolvedType("java.lang.Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getInterfaces() {
        if (this.interfaces == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.interfaces == null) {
                    Collection<ClassFile.TypeAnnotation> typeAnnotations = this.classFile.getTypeAnnotations();
                    if (this.interfaceTypes != null) {
                        ArrayList<JavaType> list = new ArrayList<JavaType>();
                        ArrayList unresolvedList = new ArrayList();
                        Iterator iterator = this.interfaceTypes.iterator();
                        char interfaceIndex = '\u0000';
                        while (iterator.hasNext()) {
                            JavaType type;
                            SignatureHasType clType = (SignatureHasType)iterator.next();
                            if (!typeAnnotations.isEmpty()) {
                                List<JavaAnnotation> javaAnnotations = this.getSuperAnnotations(typeAnnotations, interfaceIndex);
                                type = clType.getResolvedType(javaAnnotations, typeAnnotations);
                            } else {
                                type = clType.getResolvedType();
                            }
                            if (type != null) {
                                list.add(type);
                            }
                            unresolvedList.add(clType.getUnresolvedType());
                            interfaceIndex = (char)(interfaceIndex + '\u0001');
                        }
                        this.interfaces = list;
                        this.unresolvedInterfaces = unresolvedList.isEmpty() ? Collections.emptyList() : unresolvedList;
                        this.interfaceTypes = null;
                    } else {
                        Name[] things = this.classFile.getBaseInterfaces();
                        int thingCount = things.length;
                        if (thingCount == 0) {
                            this.interfaces = kEmptyCollection;
                            this.unresolvedInterfaces = Collections.emptyList();
                        } else {
                            ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                            ArrayList unresolvedList = new ArrayList();
                            for (int i = 0; i < thingCount; ++i) {
                                Name thing = things[i];
                                if (thing == null) continue;
                                JavaType type = null;
                                JavaClass classType = this.provider.getClassByVMName(things[i].toString());
                                if (classType != null) {
                                    type = classType;
                                    if (classType.hasTypeParameters() && !classType.hasActualTypeArguments()) {
                                        type = CommonUtilities.createTypeErasedClass(this.provider, type);
                                    }
                                    if (!typeAnnotations.isEmpty()) {
                                        String signature = classType.getTypeSignature();
                                        SignatureHasType sigHasType = new SignatureHasType(signature.charAt(0), signature.substring(1, signature.length() - 1), this.provider);
                                        List<JavaAnnotation> javaAnnotations = this.getSuperAnnotations(typeAnnotations, (char)i);
                                        type = sigHasType.getResolvedType(javaAnnotations, typeAnnotations);
                                    }
                                }
                                if (type != null) {
                                    list.add((JavaClass)type);
                                }
                                unresolvedList.add(QuickUnresolvedType.createUnresolvedType(thing.toString()));
                            }
                            this.interfaces = list;
                            Collection<Object> collection = this.unresolvedInterfaces = unresolvedList.isEmpty() ? Collections.emptyList() : unresolvedList;
                        }
                    }
                    if (this.interfaces.isEmpty()) {
                        this.interfaces = kEmptyCollection;
                    }
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public JavaField getDeclaredField(String name) {
        this.loadDeclaredFields();
        return this.fields.get(name);
    }

    @Override
    public Collection getDeclaredFields() {
        this.loadDeclaredFields();
        return this.copyCollection(this.fields.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredFields() {
        if (this.fields == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.fields == null) {
                    ClassFile.ClassField[] things = this.classFile.getDeclaredFields();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.fields = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, ClField> list = new LinkedHashMap<String, ClField>();
                        for (int i = 0; i < thingCount; ++i) {
                            ClassFile.ClassField thing = things[i];
                            if ((thing.getModifiers() & 0x1000) != 0) continue;
                            ClField field = new ClField(thing);
                            list.put(field.getName(), field);
                        }
                        this.fields = list;
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods() {
        this.loadDeclaredMethods();
        ArrayList<ClMethod> copy = new ArrayList<ClMethod>();
        for (List<ClMethod> list : this.methods.values()) {
            copy.addAll(list);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredMethods() {
        if (this.methods == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.methods == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredMethods();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.methods = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, List<ClMethod>> methodMap = new LinkedHashMap<String, List<ClMethod>>();
                        for (int i = 0; i < thingCount; ++i) {
                            ClassFile.ClassMethod thing = things[i];
                            if (thing.getMethodName().startsWith("access$") || (thing.getModifiers() & 0x1000) != 0) continue;
                            ClMethod clMethod = new ClMethod(thing);
                            ArrayList<ClMethod> clMethods = (ArrayList<ClMethod>)methodMap.get(clMethod.getName());
                            if (clMethods == null) {
                                clMethods = new ArrayList<ClMethod>();
                                methodMap.put(clMethod.getName(), clMethods);
                            }
                            clMethods.add(clMethod);
                        }
                        this.methods = methodMap;
                    }
                    ClassFile.ClassMethod clinit = this.classFile.getClinitMethod();
                    if (clinit != null) {
                        this.clinitMethod = new ClMethod(clinit);
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods(String name) {
        this.loadDeclaredMethods();
        return this.copyCollection((Collection)this.methods.get(name));
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredMethod(this, name, targetTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.constructors == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredConstructors();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.constructors = kEmptyCollection;
                    } else {
                        ArrayList<ClMethod> list = new ArrayList<ClMethod>();
                        for (int i = 0; i < thingCount; ++i) {
                            list.add(new ClMethod(things[i]));
                        }
                        this.constructors = list;
                    }
                }
            }
        }
        return this.constructors;
    }

    @Override
    public JavaMethod getClinitMethod() {
        this.getDeclaredMethods();
        return this.clinitMethod;
    }

    @Override
    public Collection getDeclaredClasses() {
        this.loadDeclaredClasses();
        return this.copyCollection(this.memberClasses);
    }

    @Override
    public Collection getDeclaredAnonymousClasses() {
        this.loadDeclaredClasses();
        return this.copyCollection(this.anonymousClasses);
    }

    @Override
    public Collection getDeclaredLocalClasses() {
        this.loadDeclaredClasses();
        return this.copyCollection(this.localClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredClasses() {
        if (this.memberClasses == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.memberClasses == null) {
                    Name[] things = this.classFile.getDeclaredInnerClasses();
                    int thingCount = things.length;
                    int anonymousClassCount = 0;
                    int localClassCount = 0;
                    List classes = null;
                    for (int i = 0; i < thingCount; ++i) {
                        JavaClass member = this.getInnerClassByVMName(things[i].toString());
                        if (member == null) continue;
                        if (member.isAnonymousClass()) {
                            if (anonymousClassCount++ == 0) {
                                this.anonymousClasses = new ArrayList<JavaClass>();
                            }
                            this.anonymousClasses.add(member);
                            continue;
                        }
                        if (member.isLocalClass()) {
                            if (localClassCount++ == 0) {
                                this.localClasses = new ArrayList<JavaClass>();
                            }
                            this.localClasses.add(member);
                            continue;
                        }
                        if (classes == null) {
                            classes = new ArrayList();
                        }
                        classes.add(member);
                    }
                    if (classes == null) {
                        classes = Collections.emptyList();
                    }
                    this.memberClasses = classes;
                }
            }
        }
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        Collection classes = this.getDeclaredClasses();
        for (JavaClass innerClass : classes) {
            if (!innerClass.getName().equals(name)) continue;
            return innerClass;
        }
        return null;
    }

    @Override
    public JavaClass getOwningClass() {
        if (this.cachedOwningClass == this) {
            String name = null;
            Name nameType = this.classFile.getOuterClass();
            if (nameType != null) {
                name = nameType.toString();
            }
            if (name == null) {
                name = this.classFile.getEnclosingClassName();
            }
            this.cachedOwningClass = name != null ? this.provider.getClassByVMName(name) : null;
        }
        return this.cachedOwningClass;
    }

    JavaMethod getEnclosingMethod() {
        String enclosingClassName = this.classFile.getEnclosingClassName();
        JavaClass enclosingClass = null;
        if (enclosingClassName != null) {
            enclosingClass = this.provider.getClassByVMName(enclosingClassName);
        }
        if (enclosingClass != null) {
            String enclosingMethodName = this.classFile.getEnclosingMethodName();
            String enclosingMethodDescriptor = this.classFile.getEnclosingMethodDescriptor();
            if (enclosingMethodName != null && enclosingMethodDescriptor != null) {
                ClMethod clMethod = null;
                clMethod = this.getMatchedMethod(enclosingClass.getDeclaredMethods(), enclosingMethodName, enclosingMethodDescriptor);
                if (clMethod == null) {
                    clMethod = this.getMatchedMethod(enclosingClass.getDeclaredConstructors(), enclosingMethodName, enclosingMethodDescriptor);
                }
                if (clMethod != null) {
                    return clMethod;
                }
            }
        }
        return null;
    }

    @Override
    public JavaElement getOwner() {
        JavaMethod enclosingMethod;
        if ((this.isLocalClass() || this.isAnonymousClass()) && (enclosingMethod = this.getEnclosingMethod()) != null) {
            return enclosingMethod;
        }
        JavaClass type = this.getOwningClass();
        if (type != null) {
            return type;
        }
        return this.getPackage();
    }

    private ClMethod getMatchedMethod(Collection methods, String name, String descriptor) {
        for (ClMethod clMethod : methods) {
            if (!name.equals(clMethod.getName()) || !descriptor.equals(clMethod.getDescriptor())) continue;
            return clMethod;
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return this.classFile.isDeprecated();
    }

    @Override
    public boolean isHidden() {
        return this.classFile.isHidden();
    }

    @Override
    public int getModifiers() {
        return this.classFile.getModifiers();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.classFile.isAnonymous();
    }

    @Override
    public boolean isLocalClass() {
        return this.classFile.isLocal();
    }

    public void setSourceElement(SourceElement input) {
        this.sourceClass = (SourceClass)input;
    }

    @Override
    public SourceElement getSourceElement() {
        if (this.sourceClass != null) {
            return this.sourceClass;
        }
        SourceElement sourceElement = ClClass.getCachedSourceElement(this.cachedSourceElement);
        if (sourceElement != null) {
            return sourceElement;
        }
        sourceElement = this.getSourceClass(this.classFile.getSourceFilename());
        if (sourceElement != null) {
            this.cachedSourceElement = new WeakReference<SourceElement>(sourceElement);
            return sourceElement;
        }
        this.cachedSourceElement = null;
        return null;
    }

    private static SourceElement getCachedSourceElement(WeakReference<SourceElement> sourceElementRef) {
        SourceElement sourceElement;
        SourceElement sourceElement2 = sourceElement = sourceElementRef == null ? null : (SourceElement)sourceElementRef.get();
        if (sourceElement != null) {
            SourceFile sourceFile = sourceElement.getOwningSourceFile();
            if (sourceFile == null || sourceFile.isExpired()) {
                return null;
            }
            return sourceElement;
        }
        return null;
    }

    @Override
    public URL getURL() {
        return this.classFile.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredAnnotations() {
        if (this.annotations == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.annotations == null) {
                    ClassFile.ClassAnnotation[] things = this.classFile.getDeclaredAnnotations();
                    this.annotations = this.createAnnotations(this, things);
                }
            }
        }
        return this.annotations;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.interfaces = null;
        this.sourceClass = null;
        this.annotations = null;
        for (AbstractElement thing : this.getTypeParameters()) {
            ((ClTypeParameter)thing).clearCompiledInfo();
        }
        for (AbstractElement thing : this.getDeclaredMethods()) {
            ((ClMethod)thing).clearCompiledInfo();
        }
        Iterator iterator = this.getDeclaredFields().iterator();
        while (iterator.hasNext()) {
            ((ClField)iterator.next()).clearCompiledInfo();
        }
        iterator = this.getDeclaredClasses().iterator();
        while (iterator.hasNext()) {
            ((JavaClass)iterator.next()).clearCompiledInfo();
        }
    }

    protected SourceClass getSourceClass(String sourceFileNameHint) {
        return this.provider.getSourceClass(this.getRawName());
    }

    protected JavaClass getInnerClassByVMName(String fqInnerVMName) {
        JavaClass inner = this.provider.getClassByVMName(fqInnerVMName);
        return inner;
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        if (this.interfaces == null) {
            this.getInterfaces();
        }
        return this.unresolvedInterfaces != null ? this.unresolvedInterfaces : Collections.emptyList();
    }

    private Object readComponentValue(ClassFile.ComponentValue value, JavaElement owner, boolean resolve) {
        Object o = value.getComponentValue();
        char ch = value.getComponentTag();
        switch (ch) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return o;
            }
            case 's': {
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
            case 'c': {
                Name cNameType = (Name)o;
                SignatureHasType hasType = this.nameType2signatureHasType(cNameType);
                JavaType resolvedType = hasType.getResolvedType();
                if (resolvedType != null) {
                    return resolvedType;
                }
                return resolve ? null : hasType;
            }
            case 'e': {
                ClassFile.EnumReference e = (ClassFile.EnumReference)o;
                SignatureHasType hasType = this.nameType2signatureHasType(e.enumClassname);
                JavaType resolvedType = hasType.getResolvedType();
                if (resolvedType != null) {
                    return resolvedType.getDeclaredField(e.enumName.toString());
                }
                if (resolve) {
                    return null;
                }
                return QuickHasName.createHasName(hasType.getSimplifiedName() + "." + e.enumName);
            }
            case '@': {
                ClassFile.ClassAnnotation a = (ClassFile.ClassAnnotation)o;
                return new ClAnnotation(owner, a);
            }
            case '[': {
                ClassFile.ComponentValue[] values = (ClassFile.ComponentValue[])o;
                int count = values.length;
                if (count == 0) {
                    return EMPTY_OBJECT_ARRAY;
                }
                Object[] things = new Object[count];
                for (int i = 0; i < count; ++i) {
                    things[i] = this.readComponentValue(values[i], owner, resolve);
                }
                return things;
            }
        }
        CommonUtilities.panic("Unknown component tag: " + ch);
        return null;
    }

    private List<JavaAnnotation> createAnnotations(JavaHasAnnotations owner, ClassFile.ClassAnnotation[] things) {
        int thingCount = things.length;
        if (thingCount == 0) {
            return Collections.emptyList();
        }
        JavaAnnotation[] array = new JavaAnnotation[thingCount];
        for (int i = 0; i < thingCount; ++i) {
            array[i] = new ClAnnotation(owner, things[i]);
        }
        return Arrays.asList(array);
    }

    private List<JavaAnnotation> getMemberAnnotations(JavaHasAnnotations owner, Collection<ClassFile.TypeAnnotation> typeAnnotations, ClassFile.TargetInfoType targetInfoType, byte byteIndex, char charIndex) {
        ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>();
        for (ClassFile.TypeAnnotation typeAnnotation : typeAnnotations) {
            ClassFile.TargetInfo targetInfo = typeAnnotation.getTargetInfo();
            if (targetInfo.getTargetInfoType() == targetInfoType) {
                boolean addAnnotation = false;
                switch (targetInfoType) {
                    case METHOD_PARAMETER: {
                        if (((ClassFile.ParamTargetInfo)targetInfo).getParamIndex() != byteIndex) break;
                        addAnnotation = true;
                        break;
                    }
                    case THROWS: {
                        if (((ClassFile.CharIndexTargetInfo)targetInfo).getCharIndex() != charIndex) break;
                        addAnnotation = true;
                        break;
                    }
                    default: {
                        addAnnotation = true;
                    }
                }
                if (addAnnotation) {
                    javaAnnotations.add(new ClAnnotation(owner, typeAnnotation.getClassAnnotation()));
                    continue;
                }
            }
            javaAnnotations.add(null);
        }
        return javaAnnotations;
    }

    private SignatureHasType nameType2signatureHasType(Name nameType) {
        String lnameString = nameType.toString();
        int len = lnameString.length();
        if (len == 1) {
            return new SignatureHasType(lnameString.charAt(0), this.provider);
        }
        String name = lnameString.substring(1, len - 1);
        return new SignatureHasType('L', name, this.provider);
    }

    private <T> List<T> copyCollection(Collection<T> original) {
        if (original == null) {
            return Collections.emptyList();
        }
        ArrayList<T> copy = new ArrayList<T>(original.size());
        for (T member : original) {
            copy.add(member);
        }
        return copy;
    }

    protected class ClAnnotation
    extends AbstractAnnotation
    implements JavaAnnotation {
        private final JavaElement owner;
        private final ClassFile.ClassAnnotation thing;
        private final SignatureHasType annotationType;
        private Map resolvedComponents;
        private Map<String, Object> unresolvedArguments;
        private WeakReference<SourceElement> cachedSourceElement;

        protected ClAnnotation(JavaElement owner, ClassFile.ClassAnnotation thing) {
            this.owner = owner;
            this.thing = thing;
            this.annotationType = ClClass.this.nameType2signatureHasType(thing.getAnnotationType());
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        @Override
        public int getElementKind() {
            return 2;
        }

        @Override
        public JavaElement getOwner() {
            return this.owner;
        }

        @Override
        public SourceElement getSourceElement() {
            SourceHasModifiers ownerElement;
            SourceElement sourceElement = ClClass.getCachedSourceElement(this.cachedSourceElement);
            if (sourceElement != null) {
                return sourceElement;
            }
            SourceElement ownerSource = this.owner.getSourceElement();
            if (ownerSource instanceof SourceHasModifiers && (sourceElement = CommonUtilities.getSourceElement(this, ownerElement = (SourceHasModifiers)ownerSource)) != null) {
                this.cachedSourceElement = new WeakReference<SourceElement>(sourceElement);
                return sourceElement;
            }
            this.cachedSourceElement = null;
            return null;
        }

        @Override
        public JavaType getResolvedType() {
            return this.annotationType.getResolvedType();
        }

        @Override
        public Map getArguments() {
            return InternalUtilities.getAnnotationArguments(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> getUnresolvedArguments() {
            if (this.unresolvedArguments == null) {
                ClAnnotation clAnnotation = this;
                synchronized (clAnnotation) {
                    if (this.unresolvedArguments == null) {
                        try {
                            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                            String[] names = this.thing.getComponentNames();
                            int count = names.length;
                            if (count > 0) {
                                ClassFile.ComponentValue[] values = this.thing.getComponentValues();
                                for (int i = 0; i < count; ++i) {
                                    Object value = ClClass.this.readComponentValue(values[i], this, false);
                                    if (value == null) {
                                        value = "<Unknown>";
                                    }
                                    map.put(names[i], value);
                                }
                            }
                            this.unresolvedArguments = map;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.unresolvedArguments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getComponents() {
            if (this.resolvedComponents == null) {
                ClAnnotation clAnnotation = this;
                synchronized (clAnnotation) {
                    if (this.resolvedComponents == null) {
                        try {
                            AnnotationComponents map = AnnotationComponents.createInstance(this.getResolvedType());
                            String[] names = this.thing.getComponentNames();
                            int count = names.length;
                            if (count > 0) {
                                ClassFile.ComponentValue[] values = this.thing.getComponentValues();
                                for (int i = 0; i < count; ++i) {
                                    Object value = ClClass.this.readComponentValue(values[i], this, true);
                                    if (value == null) continue;
                                    map.assignValue(names[i], value);
                                }
                            }
                            this.resolvedComponents = map;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.resolvedComponents;
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.annotationType.getUnresolvedType();
        }
    }

    protected class ClTypeParameter
    extends AbstractType
    implements JavaTypeVariable {
        private final JavaIsGeneric owner;
        private final String name;
        protected SignatureHasType superclassBound;
        protected List interfaceBounds;
        private JavaType[] resolvedInterfaces;
        private JavaType[] resolvedBounds;
        private int index;

        protected ClTypeParameter(JavaIsGeneric owner, String name, int index) {
            this.owner = owner;
            this.name = name;
            this.index = index;
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        @Override
        public String getTypeSignature() {
            return CommonUtilities.getTypeSignature(this);
        }

        @Override
        public String getDescriptor() {
            return CommonUtilities.getDescriptor(this);
        }

        @Override
        public String getUniqueIdentifier() {
            return CommonUtilities.getUniqueIdentifier(this);
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public String getVMName() {
            return this.getName();
        }

        @Override
        public String getRawName() {
            return this.getName();
        }

        @Override
        public int getElementKind() {
            return 10;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JavaElement getOwner() {
            return this.owner;
        }

        @Override
        public JavaMember getOwningMember() {
            return this.owner;
        }

        @Override
        public JavaClass getTypeErasure() {
            return CommonUtilities.getTypeErasure(this);
        }

        @Override
        public Collection<JavaAnnotation> getTypeAnnotations() {
            ClassFile.TargetInfoType targetInfoType;
            Collection<Object> typeAnnotations;
            ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>();
            int elementKind = this.owner.getElementKind();
            switch (elementKind) {
                case 3: {
                    typeAnnotations = ClClass.this.classFile.getTypeAnnotations();
                    targetInfoType = ClassFile.TargetInfoType.CLASS_TYPE_PARAMETER;
                    break;
                }
                case 8: {
                    typeAnnotations = ((ClMethod)this.owner).thing.getTypeAnnotations();
                    targetInfoType = ClassFile.TargetInfoType.METHOD_TYPE_PARAMETER;
                    break;
                }
                default: {
                    typeAnnotations = Collections.EMPTY_LIST;
                    targetInfoType = null;
                }
            }
            if (!typeAnnotations.isEmpty()) {
                for (ClassFile.TypeAnnotation typeAnnotation : typeAnnotations) {
                    ClassFile.TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                    if (targetInfo.getTargetInfoType() != targetInfoType || ((ClassFile.ParamTargetInfo)targetInfo).getParamIndex() != this.index) continue;
                    javaAnnotations.add(new ClAnnotation(this, typeAnnotation.getClassAnnotation()));
                }
            }
            return javaAnnotations;
        }

        @Override
        public JavaType getSuperclass() {
            JavaType resolved = this.getSuperclassBoundResolvedType();
            if (resolved != null) {
                return resolved;
            }
            return ClClass.this.provider.getClassByVMName("java/lang/Object");
        }

        private JavaType getSuperclassBoundResolvedType() {
            if (this.superclassBound != null) {
                ClassFile.TargetInfoType targetInfoType;
                Collection<Object> typeAnnotations;
                int elementKind = this.owner.getElementKind();
                switch (elementKind) {
                    case 3: {
                        typeAnnotations = ClClass.this.classFile.getTypeAnnotations();
                        targetInfoType = ClassFile.TargetInfoType.CLASS_TYPE_PARAMETER_BOUND;
                        break;
                    }
                    case 8: {
                        typeAnnotations = ((ClMethod)this.owner).thing.getTypeAnnotations();
                        targetInfoType = ClassFile.TargetInfoType.METHOD_TYPE_PARAMETER_BOUND;
                        break;
                    }
                    default: {
                        typeAnnotations = Collections.EMPTY_LIST;
                        targetInfoType = null;
                    }
                }
                if (!typeAnnotations.isEmpty()) {
                    List<JavaAnnotation> javaAnnotations = this.getBoundAnnotations(typeAnnotations, targetInfoType, (byte)0);
                    return this.superclassBound.getResolvedType(javaAnnotations, typeAnnotations);
                }
                return this.superclassBound.getResolvedType();
            }
            return null;
        }

        private List<JavaAnnotation> getBoundAnnotations(Collection<ClassFile.TypeAnnotation> typeAnnotations, ClassFile.TargetInfoType targetInfoType, byte boundIndex) {
            ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>();
            for (ClassFile.TypeAnnotation typeAnnotation : typeAnnotations) {
                ClassFile.TypeParamBoundTargetInfo targetInfo;
                if (typeAnnotation.getTargetInfo().getTargetInfoType() == targetInfoType && (targetInfo = (ClassFile.TypeParamBoundTargetInfo)typeAnnotation.getTargetInfo()).getParamIndex() == this.index && targetInfo.getBoundIndex() == boundIndex) {
                    javaAnnotations.add(new ClAnnotation(this.owner, typeAnnotation.getClassAnnotation()));
                    continue;
                }
                javaAnnotations.add(null);
            }
            return javaAnnotations;
        }

        @Override
        public UnresolvedType getUnresolvedSuperclass() {
            if (this.superclassBound != null) {
                return this.superclassBound.getUnresolvedType();
            }
            return QuickUnresolvedType.createUnresolvedType("java.lang.Object");
        }

        @Override
        public Collection getInterfaces() {
            JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
            if (resolvedInterfaces.length > 0) {
                return Arrays.asList(resolvedInterfaces);
            }
            return kEmptyCollection;
        }

        @Override
        public Collection<UnresolvedType> getUnresolvedInterfaces() {
            if (this.interfaceBounds == null || this.interfaceBounds.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<UnresolvedType> types = new ArrayList<UnresolvedType>();
            for (SignatureHasType clType : this.interfaceBounds) {
                UnresolvedType type = clType.getUnresolvedType();
                if (type == null) continue;
                types.add(type);
            }
            return types;
        }

        public Collection getBounds() {
            JavaType[] resolvedBounds = this.getResolvedBounds();
            if (resolvedBounds.length > 0) {
                return Arrays.asList(resolvedBounds);
            }
            return kEmptyCollection;
        }

        @Override
        public Collection<UnresolvedType> getUnresolvedBounds() {
            ArrayList<UnresolvedType> bounds = new ArrayList<UnresolvedType>();
            UnresolvedType superClassType = this.getUnresolvedSuperclass();
            if (!"java.lang.Object".equals(superClassType.toString())) {
                bounds.add(superClassType);
            }
            bounds.addAll(this.getUnresolvedInterfaces());
            return bounds;
        }

        @Override
        public void clearCompiledInfo() {
            super.clearCompiledInfo();
            ClClass.this.interfaces = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaType[] getResolvedInterfaces() {
            if (this.resolvedInterfaces == null) {
                ClTypeParameter clTypeParameter = this;
                synchronized (clTypeParameter) {
                    if (this.resolvedInterfaces == null) {
                        ArrayList<JavaType> list = kEmptyList;
                        if (this.interfaceBounds != null && !this.interfaceBounds.isEmpty()) {
                            ClassFile.TargetInfoType targetInfoType;
                            Collection<Object> typeAnnotations;
                            List<JavaAnnotation> javaAnnotations = null;
                            int elementKind = this.owner.getElementKind();
                            switch (elementKind) {
                                case 3: {
                                    typeAnnotations = ClClass.this.classFile.getTypeAnnotations();
                                    targetInfoType = ClassFile.TargetInfoType.CLASS_TYPE_PARAMETER_BOUND;
                                    break;
                                }
                                case 8: {
                                    typeAnnotations = ((ClMethod)this.owner).thing.getTypeAnnotations();
                                    targetInfoType = ClassFile.TargetInfoType.METHOD_TYPE_PARAMETER_BOUND;
                                    break;
                                }
                                default: {
                                    typeAnnotations = Collections.EMPTY_LIST;
                                    targetInfoType = null;
                                }
                            }
                            list = new ArrayList<JavaType>();
                            Iterator iterator = this.interfaceBounds.iterator();
                            byte interfaceIndex = 1;
                            while (iterator.hasNext()) {
                                JavaType type;
                                SignatureHasType clType = (SignatureHasType)iterator.next();
                                if (!typeAnnotations.isEmpty()) {
                                    javaAnnotations = this.getBoundAnnotations(typeAnnotations, targetInfoType, interfaceIndex);
                                    type = clType.getResolvedType(javaAnnotations, typeAnnotations);
                                } else {
                                    type = clType.getResolvedType();
                                }
                                if (type != null) {
                                    list.add(type);
                                }
                                interfaceIndex = (byte)(interfaceIndex + 1);
                            }
                        }
                        this.resolvedInterfaces = list.isEmpty() ? JavaType.EMPTY_ARRAY : list.toArray(new JavaType[list.size()]);
                    }
                }
            }
            return this.resolvedInterfaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaType[] getResolvedBounds() {
            if (this.resolvedBounds == null) {
                ClTypeParameter clTypeParameter = this;
                synchronized (clTypeParameter) {
                    if (this.resolvedBounds == null) {
                        JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
                        JavaType superType = this.getSuperclassBoundResolvedType();
                        if (superType != null) {
                            int count = resolvedInterfaces.length;
                            JavaType[] newArray = new JavaType[count + 1];
                            newArray[0] = superType;
                            System.arraycopy(resolvedInterfaces, 0, newArray, 1, count);
                            this.resolvedBounds = newArray;
                        } else {
                            this.resolvedBounds = resolvedInterfaces;
                        }
                    }
                }
            }
            return this.resolvedBounds;
        }
    }

    protected class ClMethod
    extends AbstractMethod {
        private final ClassFile.ClassMethod thing;
        protected Collection annotations;
        protected Map<String, ClTypeParameter> typeParameters = Collections.emptyMap();
        protected SignatureHasType returnType;
        protected Collection formalParameters = kEmptyCollection;
        protected Collection exceptionTypes;
        private Collection exceptions;
        private Object value;
        private WeakReference<SourceElement> cachedSourceElement;

        private ClMethod(ClassFile.ClassMethod thing) {
            this.thing = thing;
            String signature = thing.getSignature();
            if (signature != null) {
                if (thing.isConstructor() && this.getOwningClass().isMemberClass() && !this.getOwningClass().isStatic()) {
                    this.parseSignature(thing.getDescriptor());
                    Collection paramsFromDescriptor = this.formalParameters;
                    this.parseSignature(signature);
                    ArrayList finalParams = new ArrayList();
                    Iterator descriptorParamIter = paramsFromDescriptor.iterator();
                    for (int diff = paramsFromDescriptor.size() - this.formalParameters.size(); diff > 0; --diff) {
                        finalParams.add(descriptorParamIter.next());
                    }
                    Iterator signatureParamIter = this.formalParameters.iterator();
                    while (signatureParamIter.hasNext()) {
                        finalParams.add(signatureParamIter.next());
                    }
                    this.formalParameters = finalParams;
                } else {
                    this.parseSignature(signature);
                }
            } else {
                String descriptor = thing.getDescriptor();
                this.parseSignature(descriptor);
            }
        }

        private void parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this, this);
            parser.parseMethodTypeSignature0(this);
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        final ClassFile.ClassMethod getClassMethod() {
            return this.thing;
        }

        @Override
        public boolean isConstructor() {
            return this.thing.isConstructor();
        }

        @Override
        public JavaType getResolvedType() {
            Collection<ClassFile.TypeAnnotation> typeAnnotations = this.thing.getTypeAnnotations();
            if (!typeAnnotations.isEmpty()) {
                List javaAnnotations = ClClass.this.getMemberAnnotations(this, typeAnnotations, ClassFile.TargetInfoType.METHOD_RETURN, (byte)0, '\u0000');
                return this.returnType.getResolvedType(javaAnnotations, typeAnnotations);
            }
            return this.returnType.getResolvedType();
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.returnType.getUnresolvedType();
        }

        @Override
        public String getName() {
            return this.thing.getMethodName();
        }

        @Override
        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        @Override
        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        @Override
        public boolean hasTypeParameters() {
            return !this.typeParameters.isEmpty();
        }

        @Override
        public Collection getTypeParameters() {
            return this.typeParameters.values();
        }

        @Override
        public JavaTypeVariable getTypeParameter(String name) {
            return this.typeParameters.get(name);
        }

        @Override
        public Collection getParameters() {
            return this.formalParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getExceptions() {
            if (this.exceptions == null) {
                ClMethod clMethod = this;
                synchronized (clMethod) {
                    if (this.exceptions == null) {
                        Collection<ClassFile.TypeAnnotation> typeAnnotations = this.thing.getTypeAnnotations();
                        if (this.exceptionTypes != null) {
                            ArrayList<JavaType> list = new ArrayList<JavaType>();
                            Iterator iterator = this.exceptionTypes.iterator();
                            char exceptionCount = '\u0000';
                            while (iterator.hasNext()) {
                                JavaType type;
                                SignatureHasType clType = (SignatureHasType)iterator.next();
                                if (!typeAnnotations.isEmpty()) {
                                    List javaAnnotations = ClClass.this.getMemberAnnotations(this, typeAnnotations, ClassFile.TargetInfoType.THROWS, (byte)0, exceptionCount);
                                    type = clType.getResolvedType(javaAnnotations, typeAnnotations);
                                } else {
                                    type = clType.getResolvedType();
                                }
                                if (type != null) {
                                    list.add(type);
                                }
                                exceptionCount = (char)(exceptionCount + '\u0001');
                            }
                            this.exceptions = list;
                            this.exceptionTypes = null;
                        } else {
                            Name[] things = this.thing.getThrownExceptionTypes();
                            int thingCount = things.length;
                            if (thingCount == 0) {
                                this.exceptions = kEmptyCollection;
                            } else {
                                ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                                for (int i = 0; i < thingCount; ++i) {
                                    JavaType type = null;
                                    JavaClass classType = ClClass.this.provider.getClassByVMName(things[i].toString());
                                    if (classType != null) {
                                        type = classType;
                                        if (!typeAnnotations.isEmpty()) {
                                            String signature = classType.getTypeSignature();
                                            SignatureHasType sigHasType = new SignatureHasType(signature.charAt(0), signature.substring(1, signature.length() - 1), ClClass.this.provider);
                                            List javaAnnotations = ClClass.this.getMemberAnnotations(this, typeAnnotations, ClassFile.TargetInfoType.THROWS, (byte)0, (char)i);
                                            type = sigHasType.getResolvedType(javaAnnotations, typeAnnotations);
                                        }
                                    }
                                    if (type == null) continue;
                                    list.add((JavaClass)type);
                                }
                                this.exceptions = list;
                            }
                        }
                        if (this.exceptions.isEmpty()) {
                            this.exceptions = kEmptyCollection;
                        }
                    }
                }
            }
            return this.exceptions;
        }

        @Override
        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        @Override
        public boolean isHidden() {
            return this.thing.isHidden();
        }

        @Override
        public int getModifiers() {
            return this.thing.getModifiers();
        }

        @Override
        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        @Override
        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        @Override
        public SourceElement getSourceElement() {
            SourceElement sourceElement = ClClass.getCachedSourceElement(this.cachedSourceElement);
            if (sourceElement != null) {
                return sourceElement;
            }
            SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
            if (sourceClass != null && (sourceElement = CommonUtilities.getSourceElement(this, sourceClass)) != null) {
                this.cachedSourceElement = new WeakReference<SourceElement>(sourceElement);
                return sourceElement;
            }
            this.cachedSourceElement = null;
            return null;
        }

        @Override
        public Object getDefaultValue() {
            ClassFile.ComponentValue cv;
            if (this.value == null && (cv = this.thing.getDefaultValue()) != null) {
                this.value = ClClass.this.readComponentValue(cv, this, true);
            }
            return this.value;
        }

        @Override
        public void clearCompiledInfo() {
            this.exceptions = null;
            this.annotations = null;
            this.value = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClMethod clMethod = this;
                synchronized (clMethod) {
                    if (this.annotations == null) {
                        ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                        this.annotations = ClClass.this.createAnnotations(this, things);
                    }
                }
            }
            return this.annotations;
        }

        public Collection getDeclaredLocalClasses() {
            JavaClass owningClass = this.getOwningClass();
            Collection<JavaClass> localClasses = owningClass.getDeclaredLocalClasses();
            Iterator<JavaClass> iterator = localClasses.iterator();
            while (iterator.hasNext()) {
                JavaClass localClass = iterator.next();
                if (localClass.getOwner() == this) continue;
                iterator.remove();
            }
            return localClasses;
        }

        public Collection getDeclaredAnonymousClasses() {
            JavaClass owningClass = this.getOwningClass();
            Collection<JavaClass> localClasses = owningClass.getDeclaredAnonymousClasses();
            Iterator<JavaClass> iterator = localClasses.iterator();
            while (iterator.hasNext()) {
                ClClass localClass = (ClClass)iterator.next();
                if (localClass.getEnclosingMethod() == this) continue;
                iterator.remove();
            }
            return localClasses;
        }

        @Override
        public Collection<JavaAnnotation> getReceiverAnnotations() {
            Collection<ClassFile.TypeAnnotation> typeAnnotations = this.thing.getTypeAnnotations();
            if (!typeAnnotations.isEmpty()) {
                List receiverAnnotations = ClClass.this.getMemberAnnotations(this, typeAnnotations, ClassFile.TargetInfoType.METHOD_RECEIVER, (byte)0, '\u0000');
                Iterator iter = receiverAnnotations.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != null) continue;
                    iter.remove();
                }
                return receiverAnnotations;
            }
            return Collections.emptyList();
        }

        protected class ClVariable
        extends AbstractVariable
        implements JavaLocalVariable {
            private final SignatureHasType type;
            private final int index;
            private Collection annotations;
            private WeakReference<SourceElement> cachedSourceElement;

            protected ClVariable(SignatureHasType type, int index) {
                this.type = type;
                this.index = index;
            }

            @Override
            public JavaFile getFile() {
                return ClClass.this.javaFile;
            }

            @Override
            public int getElementKind() {
                return 7;
            }

            @Override
            public JavaType getResolvedType() {
                Collection<ClassFile.TypeAnnotation> typeAnnotations = ClMethod.this.thing.getTypeAnnotations();
                if (!typeAnnotations.isEmpty()) {
                    List javaAnnotations = ClClass.this.getMemberAnnotations(ClMethod.this, typeAnnotations, ClassFile.TargetInfoType.METHOD_PARAMETER, (byte)this.index, '\u0000');
                    return this.type.getResolvedType(javaAnnotations, typeAnnotations);
                }
                return this.type.getResolvedType();
            }

            @Override
            public UnresolvedType getUnresolvedType() {
                return this.type.getUnresolvedType();
            }

            @Override
            public String getName() {
                SourceVariable var = (SourceVariable)this.getSourceElement();
                if (var != null) {
                    return var.getName();
                }
                return "";
            }

            @Override
            public JavaElement getOwner() {
                return ClMethod.this;
            }

            @Override
            public int getModifiers() {
                if (ClMethod.this.isVarargs() && this.index == ClMethod.this.formalParameters.size() - 1) {
                    return 128;
                }
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection getDeclaredAnnotations() {
                if (this.annotations == null) {
                    ClVariable clVariable = this;
                    synchronized (clVariable) {
                        if (this.annotations == null) {
                            ClassFile.ClassAnnotation[][] allThings = ClMethod.this.thing.getParameterAnnotations();
                            if (allThings != null && allThings.length > 0) {
                                try {
                                    ClassFile.ClassAnnotation[] things = allThings[this.index];
                                    this.annotations = ClClass.this.createAnnotations(this, things);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    URL url = ClClass.this.classFile.getURL();
                                    if (url != null) {
                                        new RuntimeException(url.toString(), e).printStackTrace();
                                    }
                                    e.printStackTrace();
                                }
                            }
                            if (this.annotations == null) {
                                this.annotations = kEmptyList;
                            }
                        }
                    }
                }
                return this.annotations;
            }

            @Override
            public SourceElement getSourceElement() {
                List<SourceVariable> parameters;
                SourceElement sourceElement = ClClass.getCachedSourceElement(this.cachedSourceElement);
                if (sourceElement != null) {
                    return sourceElement;
                }
                SourceMethod sourceMethod = (SourceMethod)ClMethod.this.getSourceElement();
                if (sourceMethod != null && this.index < (parameters = sourceMethod.getSourceParameters()).size() && (sourceElement = (SourceElement)parameters.get(this.index)) != null) {
                    this.cachedSourceElement = new WeakReference<SourceElement>(sourceElement);
                    return sourceElement;
                }
                this.cachedSourceElement = null;
                return null;
            }

            @Override
            public JavaLocalVariable getLocalVariableErasure() {
                return this;
            }
        }
    }

    private class ClField
    extends AbstractField {
        private ClassFile.ClassField thing;
        protected Collection annotations;
        private SignatureHasType type;
        private JavaType resolvedType;
        private WeakReference<SourceElement> cachedSourceElement;

        private ClField(ClassFile.ClassField thing) {
            this.thing = thing;
            String signature = thing.getSignature();
            this.type = signature != null ? this.parseSignature(signature) : this.parseSignature(thing.getDescriptor());
        }

        private SignatureHasType parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this);
            return (SignatureHasType)parser.parseTypeSignature0();
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        @Override
        public synchronized JavaType getResolvedType() {
            if (this.resolvedType == null) {
                Collection<ClassFile.TypeAnnotation> typeAnnotations = this.thing.getTypeAnnotations();
                if (!typeAnnotations.isEmpty()) {
                    List javaAnnotations = ClClass.this.getMemberAnnotations(this, typeAnnotations, ClassFile.TargetInfoType.FIELD, (byte)0, '\u0000');
                    this.resolvedType = this.type.getResolvedType(javaAnnotations, typeAnnotations);
                } else {
                    this.resolvedType = this.type.getResolvedType();
                }
            }
            return this.resolvedType;
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.type.getUnresolvedType();
        }

        @Override
        public String getName() {
            return this.thing.getFieldName();
        }

        @Override
        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        @Override
        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        @Override
        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        @Override
        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        @Override
        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        @Override
        public boolean isHidden() {
            return this.thing.isHidden();
        }

        @Override
        public int getModifiers() {
            return this.thing.getModifiers();
        }

        @Override
        public SourceElement getSourceElement() {
            SourceElement sourceElement = ClClass.getCachedSourceElement(this.cachedSourceElement);
            if (sourceElement != null) {
                return sourceElement;
            }
            SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
            if (sourceClass != null && (sourceElement = CommonUtilities.getSourceElement(this, sourceClass)) != null) {
                this.cachedSourceElement = new WeakReference<SourceElement>(sourceElement);
                return sourceElement;
            }
            this.cachedSourceElement = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClField clField = this;
                synchronized (clField) {
                    if (this.annotations == null) {
                        ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                        this.annotations = ClClass.this.createAnnotations(this, things);
                    }
                }
            }
            return this.annotations;
        }

        @Override
        public Object getConstantValue() {
            if (this.isEnumConstant()) {
                return this;
            }
            if (this.isFinal() && this.isStatic()) {
                return this.thing.getConstantValue();
            }
            return null;
        }

        @Override
        public void clearCompiledInfo() {
            this.annotations = null;
        }
    }
}

