/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;

public abstract class AbstractField
extends AbstractElement
implements JavaField {
    @Override
    public abstract int getModifiers();

    @Override
    public abstract JavaClass getOwningClass();

    @Override
    public abstract String getName();

    @Override
    public abstract JavaType getResolvedType();

    @Override
    public JavaFile getFile() {
        JavaClass owning = this.getOwningClass();
        if (owning != null) {
            return owning.getFile();
        }
        return null;
    }

    @Override
    public int getElementKind() {
        return 5;
    }

    @Override
    public JavaElement getOwner() {
        return this.getOwningClass();
    }

    @Override
    public boolean isVarargs() {
        return false;
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaField getFieldErasure() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaField) {
            return CommonUtilities.equals(this, (JavaField)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public String printCompiledInfo() {
        JavaClass owningClass = this.getOwningClass();
        if (owningClass == null) {
            return "<unknown>." + this.getName();
        }
        return owningClass.getVMName() + '.' + this.getName();
    }
}

