/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.MethodHierarchy;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public abstract class AbstractMethod
extends AbstractElement
implements JavaMethod {
    private WeakReference hierarchyRef = null;

    @Override
    public abstract int getModifiers();

    @Override
    public abstract JavaClass getOwningClass();

    @Override
    public abstract String getName();

    @Override
    public abstract JavaType getResolvedType();

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public JavaMethod getMethodErasure() {
        return this;
    }

    @Override
    public JavaFile getFile() {
        JavaClass owning = this.getOwningClass();
        if (owning != null) {
            return owning.getFile();
        }
        return null;
    }

    @Override
    public int getElementKind() {
        return 8;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isNative() {
        return (this.getModifiers() & 0x100) != 0;
    }

    @Override
    public JavaElement getOwner() {
        return this.getOwningClass();
    }

    @Override
    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    public Collection getParameters() {
        return kEmptyCollection;
    }

    @Override
    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    public Collection getExceptions() {
        return kEmptyCollection;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return kEmptyCollection;
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return kEmptyCollection;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    @Override
    public boolean hasSubsignatureOf(JavaMethod other) {
        return Conversions.hasSubsignatureOf(this, other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getOverriddenMethods() {
        AbstractMethod abstractMethod = this;
        synchronized (abstractMethod) {
            Object o;
            if (this.hierarchyRef != null && (o = this.hierarchyRef.get()) != null) {
                return (Collection)o;
            }
            MethodHierarchy hierarchy = new MethodHierarchy(this);
            this.hierarchyRef = new WeakReference<MethodHierarchy>(hierarchy);
            return hierarchy;
        }
    }

    @Override
    public Collection<JavaAnnotation> getReceiverAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        AbstractMethod abstractMethod = this;
        synchronized (abstractMethod) {
            this.hierarchyRef = null;
        }
    }
}

