/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodHierarchy
extends AbstractCollection
implements JavaConstants {
    private List<JavaMethod> methodHierarchy;
    private JavaMethod thisMethod;

    @Override
    public Iterator iterator() {
        return this.methodHierarchy.iterator();
    }

    @Override
    public int size() {
        return this.methodHierarchy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.methodHierarchy.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.methodHierarchy.toArray();
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public MethodHierarchy(JavaMethod thisMethod) {
        this.thisMethod = thisMethod;
        this.calculateHierarchy();
    }

    private void calculateHierarchy() {
        if (this.thisMethod.isConstructor() || this.thisMethod.isStatic()) {
            this.methodHierarchy = Collections.emptyList();
            return;
        }
        JavaClass owningClass = this.thisMethod.getOwningClass();
        if (owningClass == null) {
            this.methodHierarchy = Collections.emptyList();
            return;
        }
        Collection<JavaMethod> superMethods = CommonUtilities.getMethods(owningClass, this.thisMethod.getName());
        Iterator<JavaMethod> methodIterator = superMethods.iterator();
        this.methodHierarchy = new ArrayList<JavaMethod>();
        while (methodIterator.hasNext()) {
            JavaMethod superMethod = methodIterator.next();
            if (superMethod.equals(this.thisMethod) || owningClass == superMethod.getOwningClass() || !Conversions.hasSubsignatureOf(this.thisMethod, superMethod) || !CommonUtilities.hasOverrideCompatibleVisibility(this.thisMethod, superMethod) || !Conversions.isReturnTypeSubstitutable(this.thisMethod, superMethod) || CommonUtilities.methodThrowsMoreCheckedExceptions(this.thisMethod, superMethod)) continue;
            this.methodHierarchy.add(superMethod);
        }
    }
}

