/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.common.ClassHierarchy;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.InstantValue;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public class QuickJavaClass
implements JavaClass {
    protected JavaType superClass;
    protected List<JavaType> interfaces;

    public QuickJavaClass(JavaType superClass, List<JavaType> interfaces) {
        if (superClass == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        this.superClass = superClass;
        this.interfaces = interfaces == null ? new ArrayList() : interfaces;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JavaType) {
            return CommonUtilities.equals(this, (JavaType)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public void clearCompiledInfo() {
    }

    @Override
    public JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    @Override
    public CompiledTmpVariable getThisValue() {
        return new InstantValue(this);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaType getComponentType() {
        return null;
    }

    @Override
    public int getArrayDimensions() {
        return 0;
    }

    @Override
    public JavaType getBaseComponentType() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isMemberClass() {
        return false;
    }

    @Override
    public boolean isAnonymousClass() {
        return false;
    }

    @Override
    public boolean isLocalClass() {
        return false;
    }

    @Override
    public String getName() {
        return "QuickJavaType";
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getRawName() {
        return this.getName();
    }

    @Override
    public String getVMName() {
        return this.getName();
    }

    @Override
    public JavaClass getTypeErasure() {
        JavaClass erasedSuper = this.superClass.getTypeErasure();
        ArrayList<JavaType> erasedInterfaces = new ArrayList<JavaType>(this.interfaces.size());
        for (JavaType oneInterface : this.interfaces) {
            erasedInterfaces.add(oneInterface.getTypeErasure());
        }
        return new QuickJavaClass(erasedSuper, erasedInterfaces);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaPackage getPackage() {
        return null;
    }

    @Override
    public String getPackageName() {
        return "";
    }

    @Override
    public JavaType getSuperclass() {
        return this.superClass;
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        return QuickUnresolvedType.createUnresolvedType(this.superClass);
    }

    @Override
    public Collection<JavaType> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        ArrayList<UnresolvedType> unresolvedInterfaces = new ArrayList<UnresolvedType>(this.interfaces.size());
        for (JavaType oneInterface : this.interfaces) {
            unresolvedInterfaces.add(QuickUnresolvedType.createUnresolvedType(oneInterface));
        }
        return unresolvedInterfaces;
    }

    @Override
    public Set<JavaType> getHierarchy() {
        return new ClassHierarchy(this);
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        return Collections.emptySet();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        return null;
    }

    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        return Collections.emptySet();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] parameters) {
        return null;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods(String name) {
        return Collections.emptySet();
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] parameters) {
        return null;
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        return Collections.emptySet();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        return null;
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return Collections.emptySet();
    }

    @Override
    public JavaMethod getClinitMethod() {
        return null;
    }

    @Override
    public Collection<JavaField> getFields() {
        return CommonUtilities.getFields(this);
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return CommonUtilities.getMethods(this);
    }

    @Override
    public Collection<JavaMethod> getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType[] parameters) {
        return CommonUtilities.getMethod(this, name, parameters);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return CommonUtilities.getClasses(this);
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public JavaClass getOwningClass() {
        return null;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isPackagePrivate() {
        return false;
    }

    @Override
    public int getElementKind() {
        return 3;
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public JavaElement getOwner() {
        return null;
    }

    @Override
    public boolean isSourceElement() {
        return false;
    }

    @Override
    public SourceElement getSourceElement() {
        return null;
    }

    @Override
    public int getModifiers() {
        return 4097;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String printCompiledInfo() {
        return null;
    }

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
        return null;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    public Collection<JavaTypeVariable> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return null;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return false;
    }

    @Override
    public Collection<JavaType> getActualTypeArguments() {
        return Collections.emptySet();
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isErasedType() {
        return false;
    }
}

