/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaWildcardType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class SignatureHasType
extends AbstractElement
implements JavaHasType,
UnresolvedType {
    private final JavaProvider provider;
    private final byte ch;
    protected byte bound = 0;
    private final JavaIsGeneric owningGeneric;
    private final String name;
    protected short array = 0;
    protected List<JavaHasType> arguments = Collections.EMPTY_LIST;
    protected List<InnerType> inners = Collections.EMPTY_LIST;

    public SignatureHasType(char ch, String name, JavaProvider provider) {
        this.ch = (byte)ch;
        this.name = name;
        this.owningGeneric = null;
        this.provider = provider;
    }

    public SignatureHasType(char ch, JavaProvider provider) {
        this.ch = (byte)ch;
        this.name = null;
        this.owningGeneric = null;
        this.provider = provider;
    }

    SignatureHasType(String name, JavaIsGeneric owner, JavaProvider provider) {
        this.ch = (byte)84;
        this.name = name;
        this.owningGeneric = owner;
        this.provider = provider;
    }

    public void pushTypeArgument(SignatureHasType argument) {
        if (this.inners.isEmpty()) {
            if (this.arguments == Collections.EMPTY_LIST) {
                this.arguments = new ArrayList<JavaHasType>();
            }
            this.arguments.add(argument);
        } else {
            int innerLength = this.inners.size();
            InnerType inner = this.inners.get(innerLength - 1);
            if (inner.arguments == Collections.EMPTY_LIST) {
                inner.arguments = new ArrayList<JavaHasType>();
            }
            inner.arguments.add(argument);
        }
    }

    public void pushInnerType(String name) {
        if (this.inners == Collections.EMPTY_LIST) {
            this.inners = new ArrayList<InnerType>();
        }
        InnerType type = new InnerType(name);
        this.inners.add(type);
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public int getElementKind() {
        return 1;
    }

    @Override
    public int getModifiers() {
        return 4096;
    }

    @Override
    public JavaElement getOwner() {
        return null;
    }

    @Override
    public JavaType getResolvedType() {
        return this.getResolvedType(null, null, null);
    }

    public JavaType getResolvedType(List<JavaAnnotation> javaAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations) {
        return this.getResolvedType(javaAnnotations, typeAnnotations, new ArrayList<Byte>());
    }

    private JavaType getResolvedType(List<JavaAnnotation> javaAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<Byte> typeLocations) {
        JavaType result = this.getResolvedTypeImpl(javaAnnotations, typeAnnotations, typeLocations);
        if (result != null && result.hasTypeParameters() && !result.hasActualTypeArguments()) {
            return CommonUtilities.createTypeErasedClass(this.provider, result);
        }
        return result;
    }

    private JavaType getResolvedTypeImpl(List<JavaAnnotation> javaAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<Byte> typeLocations) {
        JavaType type;
        if (typeAnnotations != null && this.bound != 0) {
            typeLocations.add((byte)0);
        }
        switch (this.ch) {
            case 84: {
                type = this.resolveTypeVariable(this.name);
                break;
            }
            case 42: {
                type = CommonUtilities.createWildcardType((byte)3, null, this.provider);
                break;
            }
            default: {
                if (this.name != null) {
                    type = this.provider.getClassByVMName(this.name);
                    type = this.resolveTypeArguments(type, this.arguments, javaAnnotations, typeAnnotations, typeLocations);
                    int typeLocationIndex = 0;
                    if (typeLocations != null) {
                        typeLocationIndex = typeLocations.size();
                        typeLocations.add((byte)0);
                    }
                    for (InnerType inner : this.inners) {
                        JavaType innerType;
                        if (type == null) break;
                        JavaClass genericInner = type.getClass(inner.name);
                        type = innerType = this.resolveTypeArguments(genericInner, inner.arguments, javaAnnotations, typeAnnotations, typeLocations);
                        if (typeLocations == null) continue;
                        typeLocations.set(typeLocationIndex, (byte)(typeLocations.get(typeLocationIndex) + 1));
                    }
                    if (typeLocations == null) break;
                    typeLocations.remove(typeLocationIndex);
                    break;
                }
                type = PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
            }
        }
        if (type == null) {
            return null;
        }
        if (this.array > 0) {
            if (typeAnnotations != null) {
                typeLocations.add((byte)(this.array - 1));
                List<JavaAnnotation> arrayComponentAnnotations = this.getCurrentTypeAnnotations(javaAnnotations, typeAnnotations, typeLocations);
                typeLocations.remove(typeLocations.size() - 1);
                if (arrayComponentAnnotations != null) {
                    type = CommonUtilities.createAnnotatedJavaType(type, arrayComponentAnnotations);
                }
                ArrayList<List<JavaAnnotation>> allDimensionsAnnotations = new ArrayList<List<JavaAnnotation>>();
                List<JavaAnnotation> oneDimensionAnnotations = this.getCurrentTypeAnnotations(javaAnnotations, typeAnnotations, typeLocations);
                if (oneDimensionAnnotations != null) {
                    allDimensionsAnnotations.add(oneDimensionAnnotations);
                } else {
                    allDimensionsAnnotations.add(Collections.emptyList());
                }
                for (int x = 0; x < this.array - 1; ++x) {
                    typeLocations.add((byte)x);
                    oneDimensionAnnotations = this.getCurrentTypeAnnotations(javaAnnotations, typeAnnotations, typeLocations);
                    typeLocations.remove(typeLocations.size() - 1);
                    if (oneDimensionAnnotations != null) {
                        allDimensionsAnnotations.add(oneDimensionAnnotations);
                        continue;
                    }
                    allDimensionsAnnotations.add(Collections.emptyList());
                }
                type = CommonUtilities.createArrayType(this.provider, type, this.array, allDimensionsAnnotations);
            } else {
                type = CommonUtilities.createArrayType(this.provider, type, this.array);
            }
        } else if (this.bound != 0 && typeAnnotations != null) {
            List<JavaAnnotation> boundAnnotations = this.getCurrentTypeAnnotations(javaAnnotations, typeAnnotations, typeLocations);
            if (boundAnnotations != null) {
                type = CommonUtilities.createAnnotatedJavaType(type, boundAnnotations);
            } else if (!type.getTypeAnnotations().isEmpty()) {
                type = CommonUtilities.createAnnotatedJavaType(type, Collections.EMPTY_LIST);
            }
        }
        if (typeAnnotations != null && this.bound != 0) {
            typeLocations.remove(typeLocations.size() - 1);
        }
        List<JavaAnnotation> typeArgAnnotations = null;
        if (typeAnnotations != null) {
            typeArgAnnotations = this.getCurrentTypeAnnotations(javaAnnotations, typeAnnotations, typeLocations);
        }
        if (this.bound == 0) {
            if (typeArgAnnotations != null) {
                type = CommonUtilities.createAnnotatedJavaType(type, typeArgAnnotations);
            } else if (!type.getTypeAnnotations().isEmpty()) {
                type = CommonUtilities.createAnnotatedJavaType(type, Collections.EMPTY_LIST);
            }
        } else {
            type = CommonUtilities.createWildcardType(this.bound, type, this.provider);
            if (typeArgAnnotations != null) {
                type = new AnnotatedJavaWildcardType((JavaWildcardType)type, typeArgAnnotations);
            } else if (!type.getTypeAnnotations().isEmpty()) {
                type = new AnnotatedJavaWildcardType((JavaWildcardType)type, (List<JavaAnnotation>)Collections.EMPTY_LIST);
            }
        }
        return type;
    }

    private List<JavaAnnotation> getCurrentTypeAnnotations(List<JavaAnnotation> javaAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<Byte> typeLocations) {
        ArrayList<JavaAnnotation> grabbedAnnotations = null;
        Iterator<ClassFile.TypeAnnotation> iterator = typeAnnotations.iterator();
        block0: for (int x = 0; x < typeAnnotations.size(); ++x) {
            ClassFile.TypeAnnotation typeAnnotation = iterator.next();
            JavaAnnotation javaAnnotation = javaAnnotations.get(x);
            if (javaAnnotation == null) continue;
            ClassFile.TargetInfo targetInfo = typeAnnotation.getTargetInfo();
            ClassFile.TargetLocation location = targetInfo.getTargetLocation();
            if (location != null) {
                byte[] locations = location.getLocations();
                if (locations.length != typeLocations.size()) continue;
                for (int y = 0; y < locations.length; ++y) {
                    if (locations[y] != typeLocations.get(y)) continue block0;
                }
            } else if (!typeLocations.isEmpty()) continue;
            if (grabbedAnnotations == null) {
                grabbedAnnotations = new ArrayList<JavaAnnotation>();
            }
            grabbedAnnotations.add(javaAnnotations.get(x));
        }
        return grabbedAnnotations;
    }

    private JavaType resolveTypeArguments(JavaType type, List<JavaHasType> arguments, List<JavaAnnotation> javaAnnotations, Collection<ClassFile.TypeAnnotation> typeAnnotations, List<Byte> typeLocations) {
        if (type == null) {
            return null;
        }
        if (arguments.isEmpty()) {
            return type;
        }
        if (!type.hasTypeParameters()) {
            return type;
        }
        int count = arguments.size();
        JavaType[] array = new JavaType[count];
        Iterator<JavaHasType> iterator = arguments.iterator();
        int i = 0;
        int typeLocationIndex = 0;
        if (typeLocations != null) {
            typeLocationIndex = typeLocations.size();
            typeLocations.add((byte)0);
        }
        while (iterator.hasNext()) {
            SignatureHasType thing = (SignatureHasType)iterator.next();
            array[i++] = thing.getResolvedType(javaAnnotations, typeAnnotations, typeLocations);
            if (typeLocations == null) continue;
            typeLocations.set(typeLocationIndex, (byte)(typeLocations.get(typeLocationIndex) + 1));
        }
        if (typeLocations != null) {
            typeLocations.remove(typeLocationIndex);
        }
        try {
            return CommonUtilities.createParameterizedType(this.provider, type, array);
        }
        catch (IllegalArgumentException e) {
            Logger log = JavaParser.getLogger();
            String message = "Failed for: " + type.getQualifiedName();
            log.log(Level.INFO, message, e);
            return type;
        }
    }

    private JavaTypeVariable resolveTypeVariable(String name) {
        for (JavaIsGeneric generic = this.owningGeneric; generic != null; generic = generic.getOwningClass()) {
            JavaTypeVariable found = generic.getTypeParameter(name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return this;
    }

    private String getUnresolvedName(boolean simplified) {
        String searchString = null;
        switch (this.ch) {
            case 84: {
                searchString = this.name;
                break;
            }
            case 42: {
                searchString = "java.lang.Object";
                break;
            }
            default: {
                if (this.name != null) {
                    if (simplified) {
                        int lastDollar;
                        int lastSlash = this.name.lastIndexOf(47);
                        if (lastSlash <= (lastDollar = this.name.lastIndexOf(36))) {
                            searchString = this.name.substring(lastDollar + 1);
                            break;
                        }
                        searchString = this.name.substring(lastSlash + 1);
                        break;
                    }
                    searchString = this.name;
                    searchString = searchString.replace('/', '.');
                    searchString = searchString.replace('$', '.');
                    break;
                }
                PrimitiveType primitive = PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
                searchString = primitive.getName();
            }
        }
        for (int i = 0; i < this.array; ++i) {
            searchString = searchString + "[]";
        }
        return searchString;
    }

    @Override
    public String getSimplifiedName() {
        return this.getUnresolvedName(true);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getUnresolvedName(false));
        if (!this.arguments.isEmpty()) {
            buf.append('<');
            boolean emitComma = false;
            for (JavaHasType arg : this.arguments) {
                if (emitComma) {
                    buf.append(", ");
                } else {
                    emitComma = true;
                }
                UnresolvedType argType = arg.getUnresolvedType();
                if (argType != null) {
                    buf.append(argType.toString());
                    continue;
                }
                buf.append("java.lang.Object");
            }
            buf.append('>');
        }
        return buf.toString();
    }

    private class InnerType {
        private final String name;
        protected List<JavaHasType> arguments = Collections.EMPTY_LIST;

        private InnerType(String name) {
            this.name = name;
        }
    }
}

