/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

class VMNameHasType
extends QuickHasType
implements UnresolvedType {
    private final JavaProvider provider;
    private final SourceFile file;
    private final String vmName;

    @Override
    public JavaType getResolvedType() {
        JavaProvider p = this.provider != null ? this.provider : this.file.getProvider();
        if (p != null) {
            return p.getClassByVMName(this.vmName);
        }
        return null;
    }

    VMNameHasType(JavaProvider provider, String vmName) {
        this.provider = provider;
        this.file = null;
        this.vmName = vmName;
    }

    VMNameHasType(SourceFile file, String vmName) {
        this.provider = null;
        this.file = file;
        this.vmName = vmName;
    }

    @Override
    public JavaFile getFile() {
        return this.file;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return this;
    }

    @Override
    public String getSimplifiedName() {
        int lastDollar;
        int lastSlash = this.vmName.lastIndexOf(47);
        if (lastSlash <= (lastDollar = this.vmName.lastIndexOf(36))) {
            return this.vmName.substring(lastDollar + 1);
        }
        return this.vmName.substring(lastSlash + 1);
    }

    @Override
    public String toString() {
        String tmp = this.vmName.replace('/', '.');
        return tmp.replace('$', '.');
    }
}

