/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class WildcardType
extends AbstractType
implements JavaWildcardType {
    public static final String TYPE_SIGNATURE = "*";
    public final JavaType wildcardUpper;
    public final JavaType wildcardLower;
    public final JavaProvider provider;

    WildcardType(JavaType upper, JavaType lower, JavaProvider provider) {
        this.wildcardUpper = upper;
        this.wildcardLower = lower;
        this.provider = provider;
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public int getElementKind() {
        return 11;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public String getName() {
        if (this.wildcardUpper != null) {
            return "? extends " + this.wildcardUpper.getUnqualifiedName();
        }
        if (this.wildcardLower != null) {
            return "? super " + this.wildcardLower.getUnqualifiedName();
        }
        return "?";
    }

    @Override
    public String getQualifiedName() {
        if (this.wildcardUpper != null) {
            return "? extends " + this.wildcardUpper.getQualifiedName();
        }
        if (this.wildcardLower != null) {
            return "? super " + this.wildcardLower.getQualifiedName();
        }
        return this.getName();
    }

    @Override
    public String getVMName() {
        if (this.wildcardUpper != null) {
            return "? extends " + this.wildcardUpper.getVMName();
        }
        if (this.wildcardLower != null) {
            return "? super " + this.wildcardLower.getVMName();
        }
        return this.getName();
    }

    @Override
    public String getDescriptor() {
        JavaClass erasure = this.getTypeErasure();
        if (erasure != null) {
            return erasure.getDescriptor();
        }
        return "Ljava/lang/Object;";
    }

    @Override
    public String getTypeSignature() {
        if (this.wildcardUpper != null) {
            return '+' + this.wildcardUpper.getTypeSignature();
        }
        if (this.wildcardLower != null) {
            return '-' + this.wildcardLower.getTypeSignature();
        }
        return TYPE_SIGNATURE;
    }

    @Override
    public String getSignature() {
        return this.getTypeSignature();
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaClass getTypeErasure() {
        if (this.wildcardUpper != null) {
            return this.wildcardUpper.getTypeErasure();
        }
        return this.provider.getClassByVMName("java/lang/Object");
    }

    @Override
    public JavaType getSuperclass() {
        if (this.wildcardUpper == null) {
            return this.provider.getClassByVMName("java/lang/Object");
        }
        if (this.wildcardUpper.isInterface()) {
            return this.wildcardUpper.getSuperclass();
        }
        return this.wildcardUpper.getTypeErasure();
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        if (this.wildcardUpper == null) {
            return QuickUnresolvedType.createUnresolvedType("java.lang.Object");
        }
        return this.wildcardUpper.getUnresolvedSuperclass();
    }

    @Override
    public Collection getInterfaces() {
        if (this.wildcardUpper != null && this.wildcardUpper.isInterface()) {
            return Arrays.asList((JavaClass)this.wildcardUpper);
        }
        return kEmptyCollection;
    }

    public JavaType getUpperBound() {
        return this.wildcardUpper;
    }

    public JavaType getLowerBound() {
        return this.wildcardLower;
    }

    public Collection getUpperBounds() {
        JavaType upper = this.getUpperBound();
        if (upper != null) {
            return Arrays.asList(upper);
        }
        return kEmptyCollection;
    }

    public Collection getLowerBounds() {
        JavaType lower = this.getLowerBound();
        if (lower != null) {
            return Arrays.asList(lower);
        }
        return kEmptyCollection;
    }
}

