/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;

public final class CallerContextImpl
extends CallerContext
implements JavaConstants,
CallerContext.Constants {
    public final Sym scopeCookie;
    public final CompilerDriver compiler;

    @Override
    public SourceElement getSourceScope() {
        return this.scopeCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType resolveTypeName(String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveType(this.scopeCookie, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType resolveTypeName(JavaHasType lhs, String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            if (lhs == null) {
                return null;
            }
            return this.compiler.resolveType(this.scopeCookie, lhs.getResolvedType(), name);
        }
    }

    @Override
    public JavaHasType resolveExpressionName(String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return this.resolveName(null, name, false);
    }

    @Override
    public JavaHasType resolveExpressionName(JavaHasType lhs, String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return this.resolveName(lhs, name, false);
    }

    @Override
    public JavaHasType resolveAmbiguousName(String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return this.resolveName(null, name, true);
    }

    @Override
    public JavaHasType resolveAmbiguousName(JavaHasType lhs, String name) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return this.resolveName(lhs, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaHasType resolveName(JavaHasType lhs, String name, boolean ambiguous) {
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveName(this.scopeCookie, lhs, null, name, ambiguous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaMethod resolveMethod(JavaHasType lhs, String name, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if (argumentTypes == null) {
            argumentTypes = JavaType.EMPTY_ARRAY;
        }
        if (arguments == null) {
            arguments = JavaHasType.EMPTY_ARRAY;
        }
        assert (argumentTypes.length == arguments.length) : "Argument count != argument type count";
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveMethodCall(this.scopeCookie, name, lhs, typeArguments, arguments, argumentTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaMethod resolveConstructor(JavaType target, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if (argumentTypes == null) {
            argumentTypes = JavaType.EMPTY_ARRAY;
        }
        if (arguments == null) {
            arguments = JavaHasType.EMPTY_ARRAY;
        }
        assert (argumentTypes.length == arguments.length) : "Argument count != argument type count";
        CompilerDriver compilerDriver = this.compiler;
        synchronized (compilerDriver) {
            return this.compiler.resolveMethodCall(this.scopeCookie, "<init>", target, typeArguments, arguments, argumentTypes);
        }
    }

    @Override
    public CallerContext.Output listNames(JavaPackage lhs, CallerContext.InputOptions options) {
        if (Thread.currentThread().isInterrupted()) {
            return new OutputImpl();
        }
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        OutputImpl output = new OutputImpl();
        options.input &= 0xFFFFFFF6;
        InputImpl inputImpl = new InputImpl(options);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        if (Thread.currentThread().isInterrupted()) {
            return new OutputImpl();
        }
        return output;
    }

    @Override
    public CallerContext.Output listNames(JavaHasType lhs, CallerContext.InputOptions options) {
        Sym cookieParent;
        OutputImpl output = new OutputImpl();
        if (Thread.currentThread().isInterrupted()) {
            return output;
        }
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        if (lhs != null) {
            options.input &= 0xFFFFFFFD;
        } else if (this.scopeCookie != null && this.scopeCookie.symKind == 4) {
            options.input &= 0xFFFFFF86;
        } else if (this.scopeCookie != null && this.scopeCookie.symKind == 20 && (cookieParent = this.scopeCookie.getParentSym()) != null) {
            switch (cookieParent.symKind) {
                case 27: {
                    break;
                }
                case 10: 
                case 13: 
                case 17: 
                case 19: 
                case 28: 
                case 31: {
                    return output;
                }
            }
        }
        InputImpl inputImpl = new InputImpl(options);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        if (Thread.currentThread().isInterrupted()) {
            return new OutputImpl();
        }
        return output;
    }

    @Override
    public CallerContext.Output listMethods(JavaHasType lhs, String name, JavaType[] tArguments, CallerContext.InputOptions options) {
        if (Thread.currentThread().isInterrupted()) {
            return new OutputImpl();
        }
        if (options == null) {
            options = new CallerContext.InputOptions();
        }
        OutputImpl output = new OutputImpl();
        options.input |= 1;
        options.input &= 0xFFFFFFF1;
        InputImpl inputImpl = new InputImpl(options, name, tArguments);
        this.compiler.listNames(this.scopeCookie, lhs, inputImpl, output);
        ArrayList methods = output.all;
        if (methods != null && tArguments != null && tArguments.length > 0) {
            ArrayList<JavaMethod> newMethods = new ArrayList<JavaMethod>();
            for (int x = 0; x < methods.size(); ++x) {
                JavaMethod method = (JavaMethod)methods.get(x);
                Collection<JavaTypeVariable> typeParams = method.getTypeParameters();
                if (typeParams != null && typeParams.size() == tArguments.length) {
                    method = CallerContextImpl.createParameterizedMethod(this.compiler.provider, method, tArguments);
                }
                newMethods.add(method);
            }
            methods.clear();
            methods.addAll(newMethods);
        }
        if (Thread.currentThread().isInterrupted()) {
            return new OutputImpl();
        }
        return output;
    }

    @Override
    public boolean isCompatibleMethodReference(SourceElement scope, JavaHasType lhs, List<JavaType> typeArguments, String methodName, JavaType functionalInterface) {
        if (scope == null || lhs == null || methodName == null || functionalInterface == null) {
            return false;
        }
        if (!CommonUtilities.isFunctionalInterface(functionalInterface)) {
            return false;
        }
        JavaType javaType = lhs.getResolvedType();
        if (javaType == null) {
            return false;
        }
        JavaType[] typeArgArray = typeArguments == null ? new JavaType[]{} : typeArguments.toArray(new JavaType[typeArguments.size()]);
        if ("new".equals(methodName)) {
            methodName = "<init>";
        }
        List<JavaMethod> possibleMethods = this.compiler.resolveMethod((Sym)scope, methodName, lhs, typeArgArray);
        ArrayList<JavaType> targetTypes = new ArrayList<JavaType>(1);
        targetTypes.add(functionalInterface);
        JavaType result = this.compiler.resolve(scope, lhs, possibleMethods, targetTypes, null, new boolean[1], new JavaMethod[1]);
        return result != null;
    }

    public CallerContextImpl(JavaProvider provider, Sym scope, boolean forgiving, JdkVersion jdkVersion) {
        assert (scope != null) : "Scope cannot be null in CallerContextImpl";
        this.compiler = new CompilerDriver(provider, jdkVersion, forgiving, scope != null ? scope.symFile : null);
        if (!this.compiler.jdkVersion.isJdk8OrAbove()) {
            this.compiler.flag_nonFinalLocalVars = true;
        }
        this.scopeCookie = scope;
    }
}

