/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.SelfVariable;
import oracle.javatools.parser.java.v2.internal.compiler.TypeDeclObj;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;

public final class ClassObj
extends TypeDeclObj {
    JavaType typeSuperclass;
    JavaMethod classClinit;
    private SelfVariable thisVariable;
    private SelfVariable superVariable;
    private JavaType thisVariableType;
    private JavaType superVariableType;

    @Override
    public int getBindingType() {
        return 5;
    }

    public JavaMethod getClinitMethod() {
        if (!this.flag_resolved) {
            this.objSym.resolve();
        }
        return this.classClinit;
    }

    public JavaVariable getThisVariable() {
        if (this.thisVariable == null) {
            if (!this.flag_resolved) {
                this.objSym.resolve();
            }
            this.thisVariable = new SelfVariable(this.thisVariableType, true);
        }
        return this.thisVariable;
    }

    public JavaVariable getSuperVariable() {
        if (this.superVariable == null) {
            if (!this.flag_resolved) {
                this.objSym.resolve();
            }
            this.superVariable = new SelfVariable(this.superVariableType, false);
        }
        return this.superVariable;
    }

    public JavaType getSuperclass() {
        if (!this.flag_resolved) {
            this.objSym.resolve();
        }
        return this.typeSuperclass;
    }

    void resolveSelfTypes(CompilerDriver compiler) {
        this.thisVariableType = this.getResolvedSelfType(compiler, (ClassSym)this.objSym);
        this.superVariableType = this.getResolvedSelfType(compiler, this.typeSuperclass);
    }

    private JavaType getResolvedSelfType(CompilerDriver compiler, JavaType selfType) {
        Collection<JavaType> actualTypeArguments;
        if (selfType == null) {
            return null;
        }
        JavaType resolvedType = selfType;
        Collection<JavaTypeVariable> typeParameters = selfType.getTypeParameters();
        int size = typeParameters.size();
        if (size != 0 && selfType.hasActualTypeArguments() && (actualTypeArguments = selfType.getActualTypeArguments()).size() == size) {
            JavaType[] arguments = actualTypeArguments.toArray(new JavaType[size]);
            resolvedType = CompilerUtilities.createParameterizedType(compiler.provider, selfType, arguments);
        }
        return resolvedType;
    }
}

