/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickJavaClass;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.FinallyStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

abstract class CompilerUtilities
extends InternalUtilities
implements ObjConstants {
    private static final String kUnknown = "<unknown>";
    protected static final String kJavaLang = "java.lang";
    protected static final String kJavaLangStar = "java.lang.*";
    protected static final String kJavaLangObject = "java.lang.Object";
    protected static final String kJavaLangString = "java.lang.String";
    static final String kThis = "this";
    static final String kSuper = "super";
    static final String kInit = "<init>";

    CompilerUtilities() {
    }

    protected static boolean isComponentAssignment(Sym e) {
        Sym grandpa;
        Sym parent = e.getParentSym();
        return parent != null && parent.symKind == 55 && (grandpa = parent.getParentSym()) != null && grandpa.symKind == 1;
    }

    protected static boolean isMoreSpecific(JavaMethod subject, JavaMethod target, JavaType[] argumentTypes, boolean allowBoxing, JavaProvider provider, JdkVersion jdkVersion) {
        int argumentCount;
        Collection<JavaVariable> subjectThings = subject.getParameters();
        Collection<JavaVariable> targetThings = target.getParameters();
        boolean subjectIsVarargs = subject.isVarargs();
        boolean targetIsVarargs = target.isVarargs();
        int n = argumentCount = argumentTypes != null ? argumentTypes.length : 0;
        if (subjectThings.size() != targetThings.size() && !subjectIsVarargs && !targetIsVarargs) {
            return false;
        }
        Iterator<JavaVariable> subjectParams = subjectThings.iterator();
        Iterator<JavaVariable> targetParams = targetThings.iterator();
        JavaType subjectVarType = null;
        JavaType targetVarType = null;
        int parametersSeen = 0;
        int conversionCount = 0;
        int argumentIndex = 0;
        while (true) {
            boolean subjectHasNext = subjectParams.hasNext();
            boolean targetHasNext = targetParams.hasNext();
            if (!subjectHasNext && !targetHasNext) break;
            if (parametersSeen++ == argumentCount && subjectHasNext != targetHasNext) {
                return conversionCount > 0;
            }
            if (subjectHasNext) {
                JavaVariable subjectVar = subjectParams.next();
                subjectVarType = subjectVar.getResolvedType();
                if (subjectVar.isVarargs() && subjectVarType != null && subjectVarType.isArray()) {
                    subjectVarType = subjectVarType.getComponentType();
                }
            } else if (!subjectIsVarargs) {
                return true;
            }
            if (targetHasNext) {
                JavaVariable targetVar = targetParams.next();
                targetVarType = targetVar.getResolvedType();
                if (targetVar.isVarargs() && targetVarType != null && targetVarType.isArray()) {
                    targetVarType = targetVarType.getComponentType();
                }
            } else if (!targetIsVarargs) {
                return true;
            }
            JavaType argumentType = argumentIndex < argumentCount ? argumentTypes[argumentIndex] : null;
            ++argumentIndex;
            if (argumentType != null && argumentType.isArray() && !subjectParams.hasNext() && !targetParams.hasNext()) {
                if (subject.isVarargs() && !targetIsVarargs) {
                    return true;
                }
                if (target.isVarargs() && !subject.isVarargs()) {
                    return false;
                }
            }
            if (subjectVarType == null && targetVarType == null) continue;
            if (subjectVarType == null || targetVarType == null) {
                return false;
            }
            if (subjectVarType.equals(targetVarType)) continue;
            if (argumentType != null) {
                JavaType unboxedArgumentType = allowBoxing ? CompilerUtilities.getUnboxedType(argumentType, jdkVersion) : argumentType;
                JavaType unboxedSubjectType = allowBoxing ? CompilerUtilities.getUnboxedType(subjectVarType, jdkVersion) : subjectVarType;
                JavaType unboxedTargetType = allowBoxing ? CompilerUtilities.getUnboxedType(targetVarType, jdkVersion) : targetVarType;
                boolean subjectEquals = unboxedArgumentType.equals(unboxedSubjectType);
                boolean targetEquals = unboxedArgumentType.equals(unboxedTargetType);
                if (subjectEquals && !targetEquals) {
                    return true;
                }
                if (targetEquals && !subjectEquals) {
                    return false;
                }
            }
            if (!CompilerUtilities.applyMethodConversion(subjectVarType, targetVarType, allowBoxing, provider, jdkVersion)) {
                return false;
            }
            ++conversionCount;
        }
        return true;
    }

    private static JavaType getUnboxedType(JavaType javaType, JdkVersion jdkVersion) {
        PrimitiveType unboxedType = PrimitiveType.applyUnboxingConversion(javaType, jdkVersion);
        if (unboxedType != null) {
            return unboxedType;
        }
        return javaType;
    }

    protected static final boolean isBooleanType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            return "java.lang.Boolean".equals(type.getRawName());
        }
        return "boolean".equals(type.getName());
    }

    protected static final boolean isVoidType(JavaType type) {
        return PrimitiveType.getVoidType().equals(type);
    }

    protected static final boolean isNumericType(JavaType type, JdkVersion jdkVersion) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            PrimitiveType primitive = PrimitiveType.applyUnboxingConversion(type, jdkVersion);
            return primitive != null && primitive.isNumeric();
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.isNumeric();
    }

    protected static final boolean isIntegralType(JavaType type, JdkVersion jdkVersion) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            PrimitiveType primitive = PrimitiveType.applyUnboxingConversion(type, jdkVersion);
            return primitive != null && primitive.isIntegral();
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.isIntegral();
    }

    protected static final boolean isIntegralOrBooleanType(JavaType type, JdkVersion jdkVersion) {
        if (type == null) {
            return false;
        }
        PrimitiveType primitive = !type.isPrimitive() ? PrimitiveType.applyUnboxingConversion(type, jdkVersion) : (PrimitiveType)type;
        return primitive != null && (primitive.isIntegral() || primitive.primCode == 0);
    }

    public static final JavaType leastUpperBound(JavaProvider provider, JavaType one, JavaType two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        JavaType equalBound = CompilerUtilities.getEqualBound(one, two, provider);
        if (equalBound != null) {
            return equalBound;
        }
        JavaClass erasedOne = one.getTypeErasure();
        JavaClass erasedTwo = two.getTypeErasure();
        QuickJavaClass oneLeastUpperBound = CompilerUtilities.leastUpperBound(one, erasedTwo);
        QuickJavaClass twoLeastUpperBound = CompilerUtilities.leastUpperBound(two, erasedOne);
        JavaType leastUpperBoundClass = CompilerUtilities.getUpperBound(oneLeastUpperBound.getSuperclass(), twoLeastUpperBound.getSuperclass(), provider);
        ArrayList<JavaType> upperBoundInterfaces = new ArrayList<JavaType>();
        CompilerUtilities.trimUpperBoundInterfaces(oneLeastUpperBound, twoLeastUpperBound, upperBoundInterfaces, provider);
        CompilerUtilities.trimUpperBoundInterfaces(twoLeastUpperBound, oneLeastUpperBound, upperBoundInterfaces, provider);
        upperBoundInterfaces.addAll(oneLeastUpperBound.getInterfaces());
        upperBoundInterfaces.addAll(twoLeastUpperBound.getInterfaces());
        if (upperBoundInterfaces.isEmpty()) {
            return leastUpperBoundClass;
        }
        if (upperBoundInterfaces.size() == 1 && kJavaLangObject.equals(leastUpperBoundClass.getRawName())) {
            return (JavaType)upperBoundInterfaces.get(0);
        }
        return new QuickJavaClass(leastUpperBoundClass, upperBoundInterfaces);
    }

    private static void trimUpperBoundInterfaces(QuickJavaClass one, QuickJavaClass two, List<JavaType> upperBoundInterfaces, JavaProvider provider) {
        ArrayList<JavaType> oneRemoves = new ArrayList<JavaType>();
        ArrayList<JavaType> twoRemoves = new ArrayList<JavaType>();
        for (JavaType oneInterface : one.getInterfaces()) {
            for (JavaType twoInterface : two.getInterfaces()) {
                JavaType upperBound = CompilerUtilities.getUpperBound(oneInterface, twoInterface, provider);
                if (upperBound == twoInterface) {
                    oneRemoves.add(oneInterface);
                    continue;
                }
                if (upperBound == oneInterface) continue;
                oneRemoves.add(oneInterface);
                twoRemoves.add(twoInterface);
                upperBoundInterfaces.add(upperBound);
            }
            for (JavaType twoRemove : twoRemoves) {
                two.getInterfaces().remove(twoRemove);
            }
            twoRemoves.clear();
        }
        for (JavaType oneRemove : oneRemoves) {
            one.getInterfaces().remove(oneRemove);
        }
        oneRemoves.clear();
    }

    private static JavaType getUpperBound(JavaType one, JavaType two, JavaProvider provider) {
        JavaType equalBound = CompilerUtilities.getEqualBound(one, two, provider);
        if (equalBound != null) {
            return equalBound;
        }
        if (one.isAssignableFrom(two)) {
            return two;
        }
        return one;
    }

    private static JavaType getEqualBound(JavaType one, JavaType two, JavaProvider provider) {
        String twoDescriptor;
        String oneDescriptor = one.getDescriptor();
        if (oneDescriptor.equals(twoDescriptor = two.getDescriptor())) {
            if (!one.hasActualTypeArguments() || !two.hasActualTypeArguments()) {
                return one.getTypeErasure();
            }
            Collection<JavaType> oneTypeArgs = one.getActualTypeArguments();
            Collection<JavaType> twoTypeArgs = two.getActualTypeArguments();
            if (oneTypeArgs.size() != twoTypeArgs.size()) {
                return one.getTypeErasure();
            }
            Iterator<JavaType> oneIter = oneTypeArgs.iterator();
            Iterator<JavaType> twoIter = twoTypeArgs.iterator();
            ArrayList<JavaType> typeArgs = new ArrayList<JavaType>();
            while (oneIter.hasNext()) {
                JavaType oneTypeArg = oneIter.next();
                JavaType twoTypeArg = twoIter.next();
                if (oneTypeArg == null || twoTypeArg == null) {
                    return one.getTypeErasure();
                }
                JavaType combined = CompilerUtilities.leastUpperBound(provider, oneTypeArg, twoTypeArg);
                if (combined == null) {
                    return one.getTypeErasure();
                }
                if (combined == oneTypeArg) {
                    typeArgs.add(oneTypeArg);
                    continue;
                }
                JavaType wildcardType = CommonUtilities.createWildcardType((byte)1, combined, provider);
                typeArgs.add(wildcardType);
            }
            return CompilerUtilities.createParameterizedType(provider, one.getTypeErasure(), typeArgs.toArray(new JavaType[typeArgs.size()]));
        }
        return null;
    }

    private static QuickJavaClass leastUpperBound(JavaType one, JavaType erasedTwo) {
        JavaType leastUpperBoundClass = null;
        ArrayList<JavaType> leastUpperBoundInterfaces = new ArrayList<JavaType>();
        HashSet<JavaType> toBeSkipped = new HashSet<JavaType>();
        Set<JavaType> oneHierarchy = one.getHierarchy();
        for (JavaType ancestor : oneHierarchy) {
            if (ancestor == null || (ancestor = ancestor.getResolvedType()) == null || toBeSkipped.contains(ancestor) || !ancestor.isAssignableFrom(erasedTwo)) continue;
            if (ancestor.isInterface()) {
                CompilerUtilities.addUpperBoundInterface(ancestor, leastUpperBoundInterfaces);
            } else {
                leastUpperBoundClass = ancestor;
            }
            toBeSkipped.addAll(ancestor.getHierarchy());
        }
        return new QuickJavaClass(leastUpperBoundClass == null ? one : leastUpperBoundClass, leastUpperBoundInterfaces);
    }

    private static void addUpperBoundInterface(JavaType newUpperBound, List<JavaType> upperBounds) {
        Iterator<JavaType> iterator = upperBounds.iterator();
        while (iterator.hasNext()) {
            JavaType upperBound = iterator.next();
            if (newUpperBound.isAssignableFrom(upperBound)) {
                return;
            }
            if (!upperBound.isAssignableFrom(newUpperBound)) continue;
            iterator.remove();
        }
        upperBounds.add(newUpperBound);
    }

    static boolean methodHasWeakerAccess(JavaMethod subject, JavaMethod target) {
        boolean inInterface;
        JavaClass owningClass = target.getOwningClass();
        boolean bl = inInterface = owningClass != null && owningClass.isInterface();
        if (target.isPublic() || inInterface) {
            return !subject.isPublic();
        }
        if (target.isProtected()) {
            return subject.isPackagePrivate() || subject.isPrivate();
        }
        if (target.isPackagePrivate()) {
            return subject.isPrivate();
        }
        return false;
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode) {
        return this.generateErrorImpl(symFile, cookie, errorCode, EMPTY_OBJECT_ARRAY);
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode, Object data) {
        if (data != null) {
            return this.generateErrorImpl(symFile, cookie, errorCode, new Object[]{data});
        }
        return this.generateError(symFile, cookie, errorCode);
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode, Object data0, Object data1) {
        if (data1 != null) {
            return this.generateErrorImpl(symFile, cookie, errorCode, new Object[]{data0, data1});
        }
        return this.generateError(symFile, cookie, errorCode, data0);
    }

    public final ErrorSym generateErrorImpl(FileSym symFile, Sym cookie, short errorCode, Object[] data) {
        boolean validRange;
        CallerContextImpl context = cookie.getContextImpl();
        if (context != null) {
            cookie = context.scopeCookie;
        }
        if (cookie == null) {
            return null;
        }
        if (cookie.isSkeleton()) {
            return null;
        }
        boolean bl = validRange = 39 <= errorCode && errorCode < 126;
        if (!validRange) {
            CompilerUtilities.panic(cookie);
        }
        FileObj fileObj = symFile.getFileObj();
        ErrorSym errorSym = (ErrorSym)SymFactory.createNode(symFile, 8);
        errorSym.symFile = symFile;
        if (cookie != null) {
            NameSym ns;
            errorSym.symStart = cookie.symStart;
            errorSym.symEnd = cookie.symEnd;
            errorSym.errorSymbol = cookie;
            if (cookie instanceof MethodSym && (ns = ((MethodSym)cookie).getNameSym()) != null) {
                errorSym.symStart = ns.symStart;
                errorSym.symEnd = ns.symEnd;
            }
        } else {
            errorSym.symStart = 0;
            errorSym.symEnd = 0;
        }
        errorSym.errorCode = errorCode;
        errorSym.errorRefData = data;
        switch (errorCode) {
            case 52: 
            case 54: 
            case 62: 
            case 68: 
            case 70: 
            case 75: 
            case 78: 
            case 89: 
            case 90: 
            case 91: 
            case 103: 
            case 111: {
                String name = (String)errorSym.getErrorRefData(0);
                errorSym.setErrorMessageArguments(new String[]{name});
                if (errorCode == 90) {
                    Sym sym;
                    int endOffset;
                    SourceElement element = errorSym.getErrorSymbol();
                    if (element == null || element.getSymbolKind() != 6 && element.getSymbolKind() != 5 || (endOffset = (sym = (Sym)element).getEndOffset()) <= 0) break;
                    errorSym.setStartOffset(endOffset - 1);
                    errorSym.setEndOffset(endOffset);
                    break;
                }
                if (errorCode != 52) break;
                SourceElement element = errorSym.getErrorSymbol();
                switch (element.getSymbolKind()) {
                    case 3: 
                    case 19: {
                        MemberSym member = (MemberSym)element;
                        NameSym memberName = member.getNameSym();
                        if (memberName == null) break;
                        errorSym.setStartOffset(memberName.getStartOffset());
                        errorSym.setEndOffset(memberName.getEndOffset());
                        break;
                    }
                }
                break;
            }
            case 49: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 72: 
            case 73: 
            case 94: 
            case 110: 
            case 112: 
            case 117: {
                JavaElement thing = (JavaElement)errorSym.getErrorRefData(0);
                errorSym.setErrorMessageArguments(new String[]{CompilerUtilities.elementToDisplayText(thing)});
                break;
            }
            case 59: {
                Object refData2;
                String name = (String)errorSym.getErrorRefData(0);
                Object owner = errorSym.getErrorRefData(1);
                String ownerDisplayText = owner == null ? ((refData2 = errorSym.getErrorRefData(2)) != null ? refData2.toString() : kUnknown) : CompilerUtilities.elementToDisplayText(owner);
                errorSym.setErrorMessageArguments(new String[]{name, ownerDisplayText});
                break;
            }
            case 43: 
            case 48: 
            case 115: {
                JavaType rhsType = (JavaType)errorSym.getErrorRefData(0);
                JavaType lhsType = (JavaType)errorSym.getErrorRefData(1);
                errorSym.setErrorMessageArguments(new String[]{CompilerUtilities.elementToDisplayText(rhsType), CompilerUtilities.elementToDisplayText(lhsType)});
                break;
            }
            case 60: 
            case 99: {
                Object scopeClassName;
                String string0;
                String name = (String)errorSym.getErrorRefData(0);
                JavaType[] arguments = (JavaType[])errorSym.getErrorRefData(1);
                if (arguments != null) {
                    StringBuilder buffer = new StringBuilder(name);
                    int count = arguments.length;
                    buffer.append('(');
                    if (count > 0) {
                        boolean needComma = false;
                        for (int i = 0; i < count; ++i) {
                            if (needComma) {
                                buffer.append(',');
                            }
                            buffer.append(CompilerUtilities.elementToDisplayText(arguments[i]));
                            needComma = true;
                        }
                    }
                    buffer.append(')');
                    string0 = buffer.toString();
                } else {
                    string0 = name;
                }
                Object scopeClass = errorSym.getErrorRefData(2);
                String string1 = scopeClass != null ? CompilerUtilities.elementToDisplayText(scopeClass) : ((scopeClassName = errorSym.getErrorRefData(3)) != null ? scopeClassName.toString() : kUnknown);
                errorSym.setErrorMessageArguments(new String[]{string0, string1});
                break;
            }
            case 87: {
                Sym sym;
                int endOffset;
                SourceElement element = errorSym.getErrorSymbol();
                if (element == null || element.getSymbolKind() != 19 && element.getSymbolKind() != 67 || (endOffset = (sym = (Sym)element).getEndOffset()) <= 0) break;
                errorSym.setStartOffset(endOffset - 1);
                errorSym.setEndOffset(endOffset);
                break;
            }
            case 88: {
                FinallyStmt finallyStatement;
                int endOffset;
                SourceElement element = errorSym.getErrorSymbol();
                if (element == null || element.getSymbolKind() != 41 || (endOffset = (finallyStatement = (FinallyStmt)element).getEndOffset()) <= 0) break;
                errorSym.setStartOffset(endOffset - 1);
                errorSym.setEndOffset(endOffset);
                break;
            }
            case 93: {
                int startIndex;
                SourceElement element = errorSym.getErrorSymbol();
                int n = startIndex = element instanceof Sym ? ((Sym)element).getStartIndex() : -1;
                if (element instanceof SourceHasName) {
                    element = ((SourceHasName)element).getNameElement();
                }
                int endIndex = element instanceof Sym ? ((Sym)element).getEndIndex() : -1;
                char modifier = ((Character)errorSym.getErrorRefData0()).charValue();
                short modifierKeyword = CompilerUtilities.accessModifierToKeyword(modifier);
                boolean modifiedOffsets = false;
                if (modifierKeyword >= 0) {
                    FileSym fileSym = errorSym.symFile;
                    TokenArray array = fileSym.getTokenArray();
                    if (startIndex >= 0 && endIndex > startIndex) {
                        while (startIndex < array.tokenValues.length && startIndex < endIndex) {
                            if (modifierKeyword == array.tokenValues[startIndex]) {
                                errorSym.setStartOffset(array.tokenStarts[startIndex]);
                                errorSym.setEndOffset(array.tokenEnds[startIndex]);
                                modifiedOffsets = true;
                                break;
                            }
                            ++startIndex;
                        }
                    }
                }
                if (!modifiedOffsets && element != null) {
                    errorSym.setStartOffset(element.getStartOffset());
                    errorSym.setEndOffset(element.getEndOffset());
                }
                String modifierText = modifierKeyword >= 96 && modifierKeyword < 146 ? JavaTokens.KW_words[modifierKeyword - 96] : kUnknown;
                errorSym.setErrorMessageArguments(new String[]{modifierText});
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                MethodSym methodSym = (MethodSym)errorSym.getErrorSymbol();
                NameSym nameSym = methodSym.getNameSym();
                if (nameSym != null) {
                    errorSym.setStartOffset(nameSym.getStartOffset());
                    errorSym.setEndOffset(nameSym.getEndOffset());
                }
                JavaMethod overriddenMethod = (JavaMethod)errorSym.getErrorRefData0();
                errorSym.setErrorMessageArguments(new String[]{CompilerUtilities.elementToDisplayText(overriddenMethod)});
                break;
            }
            case 108: {
                AnnotateSym annotateSym = (AnnotateSym)errorSym.getErrorSymbol();
                TypeSym typeSym = annotateSym.getTypeSym();
                if (typeSym != null) {
                    errorSym.setStartOffset(typeSym.getStartOffset());
                    errorSym.setEndOffset(typeSym.getEndOffset());
                }
                JavaMethod attributeMethod = (JavaMethod)errorSym.getErrorRefData0();
                errorSym.setErrorMessageArguments(new String[]{attributeMethod.getName()});
                break;
            }
            case 92: {
                if (errorSym.getErrorSymbol().getSymbolKind() != 33) break;
                errorSym.setEndOffset(errorSym.getStartOffset() + 1);
            }
        }
        errorSym.symParent = symFile.compileErrors;
        errorSym.buildSelf();
        if (fileObj.errorData != null) {
            fileObj.errorData.addKid(errorSym);
        }
        return errorSym;
    }

    protected static String elementToDisplayText(JavaType thing) {
        if (thing != null) {
            String result = thing.getQualifiedName();
            if (result.startsWith("null[")) {
                result = kUnknown + result.substring(4);
            }
            return result;
        }
        return kUnknown;
    }

    protected static String elementToDisplayText(JavaMethod thing) {
        if (thing == null) {
            return kUnknown;
        }
        String name = thing.isConstructor() ? kInit : thing.getName();
        StringBuilder buffer = new StringBuilder(thing.getName());
        buffer.append('(');
        Collection<JavaVariable> parameters = thing.getParameters();
        if (!parameters.isEmpty()) {
            Iterator<JavaVariable> things = parameters.iterator();
            boolean needComma = false;
            while (things.hasNext()) {
                if (needComma) {
                    buffer.append(',');
                }
                JavaVariable v = things.next();
                buffer.append(CompilerUtilities.elementToDisplayText(v.getResolvedType()));
                needComma = true;
            }
        }
        buffer.append(')');
        String text = buffer.toString();
        JavaClass owningThing = thing.getOwningClass();
        if (owningThing != null) {
            return owningThing.getQualifiedName() + '.' + text;
        }
        return text;
    }

    protected static String elementToDisplayText(JavaField thing) {
        if (thing == null) {
            return kUnknown;
        }
        String text = thing.getName();
        JavaClass owningThing = thing.getOwningClass();
        if (owningThing != null) {
            return owningThing.getQualifiedName() + '.' + text;
        }
        return text;
    }

    protected static String elementToDisplayText(JavaPackage thing) {
        if (thing == null) {
            return kUnknown;
        }
        return thing.getQualifiedName();
    }

    protected static String elementToDisplayText(UnresolvedType thing) {
        if (thing == null) {
            return kUnknown;
        }
        return thing.getSimplifiedName();
    }

    public static String elementToDisplayText(Object thing) {
        if (thing != null) {
            if (thing instanceof JavaType) {
                return CompilerUtilities.elementToDisplayText((JavaType)thing);
            }
            if (thing instanceof JavaField) {
                return CompilerUtilities.elementToDisplayText((JavaField)thing);
            }
            if (thing instanceof JavaMethod) {
                return CompilerUtilities.elementToDisplayText((JavaMethod)thing);
            }
            if (thing instanceof JavaPackage) {
                return CompilerUtilities.elementToDisplayText((JavaPackage)thing);
            }
            if (thing instanceof UnresolvedType) {
                return CompilerUtilities.elementToDisplayText((UnresolvedType)thing);
            }
        }
        return kUnknown;
    }

    protected static final void panic(Sym sym) {
        System.out.println(sym.toString());
        CompilerUtilities.panic();
    }
}

