/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageA;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodReferenceExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class ContextImageB
extends ContextImageA {
    private static final int PASS_1 = 1;
    private static final int PASS_2 = 2;
    private static final int PASS_3 = 3;

    ContextImageB(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    protected final boolean findVisibleMethod(JavaType targetType, String name) {
        Collection<JavaMethod> declaredMethods;
        if (targetType == null) {
            return false;
        }
        if ("<init>".equals(name)) {
            ContextImageB.panic(this.symCookie);
        }
        if ((declaredMethods = targetType.getDeclaredMethods(name)).size() > 0) {
            return true;
        }
        boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
        Iterator<JavaType> hierarchy = targetType.getHierarchy().iterator();
        boolean isJdk8 = this.compiler.jdkVersion.isJdk8OrAbove();
        while (hierarchy.hasNext()) {
            boolean lookingForNonAbstractMethods;
            JavaType type = hierarchy.next();
            boolean bl = lookingForNonAbstractMethods = type.isInterface() && targetIsNonAbstractClass;
            if (!isJdk8 && lookingForNonAbstractMethods) continue;
            for (JavaMethod thing : type.getDeclaredMethods(name)) {
                if (isJdk8 && lookingForNonAbstractMethods && thing.isAbstract() || !this.processVisible(thing)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findSingleMethod(JavaType targetType, String name, JavaType[] arguments) {
        if (targetType == null) {
            return null;
        }
        ArrayList visible = ContextImageB.allocArrayList();
        try {
            if ("<init>".equals(name)) {
                visible.addAll(targetType.getDeclaredConstructors());
            } else {
                visible.addAll(targetType.getDeclaredMethods(name));
                boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
                for (JavaType type : targetType.getHierarchy()) {
                    if (type.isInterface() && targetIsNonAbstractClass) continue;
                    for (JavaMethod thing : type.getDeclaredMethods(name)) {
                        if (!this.processVisible(thing)) continue;
                        visible.add(thing);
                    }
                }
            }
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            this.findMostSpecificMethod(visible, arguments, false);
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (visible.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)visible.get(0);
                return javaMethod;
            }
            JavaMethod javaMethod = this.chooseMostSpecificMethod(visible);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findMethod(JavaType targetType, String name, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, JavaHasType primary) {
        ArrayList potential = ContextImageB.allocArrayList();
        try {
            this.findPotentiallyApplicable(targetType, name, typeArguments, argumentTypes, potential, primary);
            JavaMethod javaMethod = this.processMethods(potential, typeArguments, arguments, argumentTypes, false);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final List<JavaMethod> findMethods(JavaType targetType, String name, JavaType[] typeArguments, JavaHasType primary) {
        ArrayList<JavaMethod> potential = new ArrayList<JavaMethod>();
        this.findPotentiallyApplicable(targetType, name, typeArguments, null, potential, primary);
        for (int x = 0; x < potential.size(); ++x) {
            JavaMethod method = potential.get(x);
            if (!method.hasTypeParameters() || typeArguments == null || typeArguments.length != method.getTypeParameters().size()) continue;
            potential.set(x, ContextImageB.createParameterizedMethod(this.compiler.provider, method, typeArguments));
        }
        return potential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findImportedMethod(String name, JavaHasType[] arguments, JavaType[] argumentTypes) {
        this.flag_instance = false;
        ArrayList potential = ContextImageB.allocArrayList();
        try {
            this.processImportedMethods(name, null, argumentTypes, potential);
            JavaMethod javaMethod = this.processMethods(potential, null, arguments, argumentTypes, false);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final List<JavaMethod> findImportedMethods(String name) {
        this.flag_instance = false;
        ArrayList<JavaMethod> potential = new ArrayList<JavaMethod>();
        this.processImportedMethods(name, null, null, potential);
        return potential;
    }

    protected final boolean checkException(Sym scope, JavaType thrown) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                SourceMethod methodSym = (SourceMethod)((Object)scope);
                for (JavaType declared : methodSym.getExceptions()) {
                    if (!thrown.isSubtypeOf(declared)) continue;
                    return true;
                }
                this.error((short)49, thrown);
                return true;
            }
            case 18: {
                Sym grandParent;
                Sym parent;
                return this.compiler.jdkVersion.isJdk7OrAbove() && (parent = scope.getParentSym()) != null && parent.symKind == 30 && (grandParent = parent.getParentSym()) != null && grandParent.symKind == 48 && this.tryCatchesException((SourceTryStatement)((Object)grandParent), thrown);
            }
            case 2: {
                Sym grandparent;
                Sym parent = scope.getParentSym();
                return parent != null && parent.symKind == 33 && (grandparent = parent.getParentSym()) != null && grandparent.symKind == 48 && this.tryCatchesException((SourceTryStatement)((Object)grandparent), thrown);
            }
            case 5: {
                this.error((short)49, thrown);
                return true;
            }
        }
        return false;
    }

    private boolean tryCatchesException(SourceTryStatement tryStmt, JavaType thrown) {
        List<JavaType> caughtExceptions = tryStmt.getCaughtExceptions();
        for (JavaType caughtException : caughtExceptions) {
            if (!thrown.isSubtypeOf(caughtException)) continue;
            return true;
        }
        return false;
    }

    protected final List<ImportSym> getValidStaticImports(FileSym sourceFile) {
        List importSyms = sourceFile.getSourceImports();
        ArrayList<ImportSym> staticImportList = new ArrayList<ImportSym>();
        for (ImportSym importSym : importSyms) {
            if (!importSym.isStatic() || importSym.isInvalid()) continue;
            staticImportList.add(importSym);
        }
        return staticImportList;
    }

    public final JavaMethod processMethods(ArrayList potential, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean prohibitBoxing) {
        JavaMethod method;
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if ((method = this.processMethodsImpl(potential, typeArguments, arguments, argumentTypes, prohibitBoxing, false)) == null) {
            return null;
        }
        if (!method.hasTypeParameters()) {
            return method;
        }
        if (typeArguments.length == 0 && (typeArguments = this.inferTypeArguments(method, arguments, argumentTypes)).length == 0) {
            return method;
        }
        if (method.hasActualTypeArguments()) {
            ContextImageB.panic("But it already has actual type arguments.");
        }
        return ContextImageB.createParameterizedMethod(this.compiler.provider, method, typeArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaMethod processMethodsImpl(ArrayList potential, JavaType[] tArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean prohibitBoxing, boolean resolvingMethodReference) {
        if (tArguments == null) {
            tArguments = JavaType.EMPTY_ARRAY;
        }
        if (potential.isEmpty()) {
            return null;
        }
        ArrayList applicable = ContextImageB.allocArrayList();
        try {
            int pass = -1;
            if (applicable.isEmpty()) {
                pass = 1;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                pass = 2;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                pass = 3;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (applicable.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)applicable.get(0);
                return javaMethod;
            }
            this.findMostSpecificMethod(applicable, argumentTypes, pass == 2 || pass == 3);
            if (applicable.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (applicable.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)applicable.get(0);
                return javaMethod;
            }
            JavaMethod result = this.chooseMostSpecificMethod(applicable);
            if (result != null) {
                JavaMethod javaMethod = result;
                return javaMethod;
            }
            this.error((short)41);
            JavaMethod javaMethod = null;
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(applicable);
        }
    }

    private void findPotentiallyApplicable(JavaType targetType, String targetName, JavaType[] typeArguments, JavaType[] arguments, ArrayList output, JavaHasType primary) {
        if (targetType == null) {
            return;
        }
        boolean isJdk8 = this.compiler.jdkVersion.isJdk8OrAbove();
        boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
        ArrayList<JavaMethod> rejected = new ArrayList<JavaMethod>();
        boolean lookForNonAbstractMethods = targetType.isInterface() && targetIsNonAbstractClass;
        this.findPotentiallyApplicableImpl(targetType, targetName, typeArguments, arguments, output, primary, false, rejected);
        if ("<init>".equals(targetName)) {
            return;
        }
        for (JavaType type : targetType.getHierarchy()) {
            boolean bl = lookForNonAbstractMethods = type.isInterface() && targetIsNonAbstractClass;
            if (!isJdk8 && lookForNonAbstractMethods) continue;
            this.findPotentiallyApplicableImpl(type, targetName, typeArguments, arguments, output, primary, isJdk8 && lookForNonAbstractMethods, rejected);
        }
    }

    private boolean isNonAbstractClass(JavaType type) {
        if (type.isInterface() || type.isAbstract() || type.isEnum()) {
            return false;
        }
        int elementKind = type.getElementKind();
        return elementKind != 10 && elementKind != 11;
    }

    private void findPotentiallyApplicableImpl(JavaType targetType, String targetName, JavaType[] tArguments, JavaType[] argumentTypes, ArrayList output, JavaHasType primary, boolean lookForNonAbstractMethods, List<JavaMethod> rejected) {
        int argCount = argumentTypes == null ? -1 : argumentTypes.length;
        boolean findConstructors = "<init>".equals(targetName);
        Iterator<JavaMethod> methods = findConstructors ? targetType.getDeclaredConstructors().iterator() : targetType.getDeclaredMethods(targetName).iterator();
        if (rejected == null) {
            rejected = new ArrayList<JavaMethod>();
        }
        this.findPotentiallyApplicableMethods(methods, tArguments, argCount, output, primary, lookForNonAbstractMethods, rejected, findConstructors);
    }

    public void findPotentiallyApplicableMethods(Iterator<JavaMethod> methods, JavaType[] tArguments, int argCount, ArrayList output, JavaHasType primary, boolean lookForNonAbstractMethods, List<JavaMethod> rejected, boolean findConstructors) {
        block0: while (methods.hasNext()) {
            JavaMethod method = methods.next();
            rejected.add(method);
            if (lookForNonAbstractMethods && method.isAbstract()) continue;
            if (argCount >= 0) {
                int arity;
                boolean isVarargs = method.isVarargs();
                int parameterCount = method.getParameters().size();
                if (isVarargs ? argCount < (arity = parameterCount - 1) : parameterCount != argCount) continue;
            }
            if (tArguments != null) {
                int typeParameterCount = method.getTypeParameters().size();
                int typeArgCount = tArguments.length;
                if (typeArgCount > 0 && typeParameterCount != typeArgCount) continue;
            }
            if (!findConstructors && !this.flag_instance && !method.isStatic() || !this.processVisible(method) || !this.allowAccess(method, primary)) continue;
            JavaClass owner = method.getOwningClass();
            if (this.compiler.jdkVersion.isJdk8OrAbove() && owner != null && owner.isInterface() && !method.isAbstract()) {
                for (JavaMethod reject : rejected) {
                    JavaClass rejectOwner;
                    if (reject == method || (rejectOwner = reject.getOwningClass()) == null || !rejectOwner.isSubtypeOf(owner) || !Conversions.hasSubsignatureOf(reject, method)) continue;
                    continue block0;
                }
            }
            output.add(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImportedMethods(String name, JavaType[] tArguments, JavaType[] arguments, ArrayList output) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return;
        }
        List<ImportSym> importSyms = this.getValidStaticImports(sourceFile);
        if (importSyms.size() == 0) {
            return;
        }
        HashSet<String> signatures = new HashSet<String>();
        ArrayList tmp = ContextImageB.allocArrayList();
        try {
            for (ImportSym importSym : importSyms) {
                String fqname;
                int lastDot;
                String importedName;
                if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
            HashSet<String> importKeys = new HashSet<String>();
            for (ImportSym importSym : importSyms) {
                String importName;
                if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
                importKeys.add(importName);
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
        }
        finally {
            ContextImageB.freeArrayList(tmp);
        }
    }

    private void processImportedMethods(ImportSym importSym, String name, JavaType[] tArguments, JavaType[] arguments, HashSet<String> signatures, ArrayList tmp, ArrayList output) {
        JavaType qualifying;
        importSym.resolve();
        if (qualifying == null) {
            return;
        }
        tmp.clear();
        for (qualifying = importSym.getQualifyingType(); qualifying != null; qualifying = qualifying.getSuperclass()) {
            this.findPotentiallyApplicableImpl(qualifying, name, tArguments, arguments, tmp, null, false, null);
        }
        if (tmp.isEmpty()) {
            return;
        }
        for (JavaMethod method : tmp) {
            String signature = method.getSignature();
            if (signatures.contains(signature)) continue;
            signatures.add(signature);
            output.add(method);
            importSym.setUsed();
            ArrayList importList = importSym.getImportObj().importList;
            if (importList == null || importList.contains(method)) continue;
            importList.add(method);
        }
    }

    private void findApplicable(int pass, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, ArrayList input, ArrayList output, boolean prohibitBoxing, boolean resolvingMethodReference) {
        int typeArgCount = typeArguments.length;
        int argCount = arguments.length;
        Iterator iterator = input.iterator();
        block0: while (iterator.hasNext()) {
            Collection<JavaTypeVariable> typeParameterCollection;
            JavaMethod method = (JavaMethod)iterator.next();
            if (typeArgCount > 0 && pass == 1 && (typeParameterCollection = method.getTypeParameters()).size() != typeArgCount) {
                iterator.remove();
                continue;
            }
            Collection<JavaVariable> parameterCollection = method.getParameters();
            int parameterCount = parameterCollection.size();
            boolean isVararg = method.isVarargs();
            if (argCount != parameterCount && (pass < 3 || !isVararg)) continue;
            Iterator<JavaVariable> parameters = parameterCollection.iterator();
            JavaVariable parameter = null;
            for (int a = 0; a < argCount; ++a) {
                boolean allowBoxing;
                JavaType argumentType;
                if (parameters.hasNext()) {
                    parameter = parameters.next();
                }
                if ((argumentType = argumentTypes[a]) == null) continue;
                JavaType parameterType = parameter.getResolvedType();
                if (this.compiler.jdkVersion.isJdk8OrAbove() && (arguments[a] instanceof LambdaExpr || arguments[a] instanceof MethodReferenceExpr)) {
                    if (pass == 1 && arguments[a] instanceof MethodReferenceExpr && ((MethodReferenceExpr)arguments[a]).resolutionRequiredBoxing()) continue block0;
                    if (arguments[a] instanceof LambdaExpr) {
                        JavaMethod functionalInterfaceMethod = CommonUtilities.getFunctionalInterfaceMethod(parameterType);
                        if (functionalInterfaceMethod == null) continue block0;
                        parameterType = functionalInterfaceMethod.getResolvedType();
                    }
                }
                if (pass == 3 && parameterType != null && parameter.isVarargs()) {
                    if (parameterType.isArray()) {
                        parameterType = parameterType.getComponentType();
                    } else {
                        IllegalStateException e = new IllegalStateException("Varargs parameter not an array type");
                        e.printStackTrace();
                    }
                }
                if (parameterType == null) {
                    iterator.remove();
                    continue block0;
                }
                boolean bl = allowBoxing = !prohibitBoxing && 2 <= pass && this.compiler.jdkVersion.isJdk5OrAbove();
                if (resolvingMethodReference && (argumentType.getElementKind() == 10 || argumentType.getElementKind() == 11) ? !ContextImageB.applyMethodConversion(parameterType, argumentType, allowBoxing, this.compiler.provider, this.compiler.jdkVersion) : !ContextImageB.applyMethodConversion(argumentType, parameterType, allowBoxing, this.compiler.provider, this.compiler.jdkVersion)) continue block0;
            }
            output.add(method);
        }
    }

    public void findMostSpecificMethod(ArrayList methods, JavaType[] argumentTypes, boolean allowBoxing) {
        HashSet<JavaMethod> losers = new HashSet<JavaMethod>();
        for (JavaMethod favorite : methods) {
            if (losers.contains(favorite)) continue;
            JavaClass favoriteClass = favorite.getOwningClass();
            for (JavaMethod contender : methods) {
                if (losers.contains(contender) || favorite.equals(contender)) continue;
                boolean favored = false;
                if (favorite.hasSubsignatureOf(contender)) {
                    if (favoriteClass != null && !favoriteClass.equals(contender.getOwningClass())) {
                        favored = true;
                    }
                } else if (ContextImageB.isMoreSpecific(favorite, contender, argumentTypes, allowBoxing, this.compiler.provider, this.compiler.jdkVersion) && !ContextImageB.isMoreSpecific(contender, favorite, argumentTypes, allowBoxing, this.compiler.provider, this.compiler.jdkVersion)) {
                    favored = true;
                }
                if (!favored) continue;
                losers.add(contender);
            }
        }
        methods.removeAll(losers);
    }

    private JavaMethod chooseMostSpecificMethod(ArrayList methods) {
        Iterator iterator = methods.iterator();
        JavaMethod output = null;
        String masterDescriptor = null;
        boolean sameDescriptors = true;
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if ((javaMethod.getModifiers() & 0x400) == 0) {
                if (output != null) {
                    return null;
                }
                output = javaMethod;
            }
            if (!sameDescriptors) continue;
            String descriptor = javaMethod.getDescriptor();
            if (masterDescriptor == null) {
                masterDescriptor = descriptor;
                continue;
            }
            sameDescriptors = masterDescriptor.equals(descriptor);
        }
        if (output != null) {
            return output;
        }
        if (!sameDescriptors) {
            return null;
        }
        return (JavaMethod)methods.get(0);
    }

    public JavaType[] inferDiamondTypeArguments(JavaType targetType, JavaMethod targetMethod, JavaHasType[] arguments, JavaType[] argumentTypes) {
        if (argumentTypes.length == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        Collection<JavaTypeVariable> typeParameters = targetType.getTypeParameters();
        int tpCount = typeParameters.size();
        if (tpCount == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] tpArray = typeParameters.toArray(new JavaType[tpCount]);
        return this.inferTypeArguments(targetMethod, tpArray, tpCount, arguments, argumentTypes);
    }

    private JavaType[] inferTypeArguments(JavaMethod method, JavaHasType[] arguments, JavaType[] argumentTypes) {
        if (argumentTypes.length == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        Collection<JavaTypeVariable> typeParameters = method.getTypeParameters();
        int tpCount = typeParameters.size();
        if (tpCount == 0) {
            ContextImageB.panic("No parameters");
        }
        JavaType[] tpArray = typeParameters.toArray(new JavaType[tpCount]);
        return this.inferTypeArguments(method, tpArray, tpCount, arguments, argumentTypes);
    }

    private JavaType[] inferTypeArguments(JavaMethod method, JavaType[] tpArray, int tpCount, JavaHasType[] arguments, JavaType[] argumentTypes) {
        int i;
        JavaType[] constraints = new JavaType[tpCount];
        JavaType[] parameters = method.getParameterTypes();
        if (method.isVarargs() && parameters.length > 0) {
            JavaType lastParameter;
            boolean takeComponentType;
            boolean bl = takeComponentType = argumentTypes.length > parameters.length;
            if (argumentTypes.length == parameters.length) {
                JavaType lastArg = argumentTypes[argumentTypes.length - 1];
                if (lastArg == null || !lastArg.isArray()) {
                    takeComponentType = true;
                } else {
                    JavaType argComponentType = lastArg.getComponentType();
                    if (argComponentType != null && argComponentType.isPrimitive()) {
                        takeComponentType = true;
                    }
                }
            }
            if (takeComponentType && (lastParameter = parameters[parameters.length - 1]) != null && lastParameter.isArray()) {
                parameters[parameters.length - 1] = lastParameter.getComponentType();
            }
        }
        int loopCount = Math.min(parameters.length, argumentTypes.length);
        for (i = 0; i < loopCount; ++i) {
            JavaMethod functionalInterfaceMethod;
            JavaType parameter = parameters[i];
            if (this.compiler.jdkVersion.isJdk8OrAbove() && arguments[i] instanceof LambdaExpr && (functionalInterfaceMethod = CommonUtilities.getFunctionalInterfaceMethod(parameter)) != null) {
                parameter = functionalInterfaceMethod.getResolvedType();
            }
            this.inferFromOneArgument(parameter, argumentTypes[i], tpArray, constraints);
        }
        for (i = 0; i < tpCount; ++i) {
            if (constraints[i] == null) {
                constraints[i] = tpArray[i];
            }
            if (constraints[i] == null || constraints[i].getElementKind() != 11) continue;
            JavaWildcardType wildcard = (JavaWildcardType)constraints[i];
            Collection<JavaType> bounds = wildcard.getUpperBounds();
            if (bounds.isEmpty()) {
                bounds = wildcard.getLowerBounds();
            }
            constraints[i] = !bounds.isEmpty() ? bounds.iterator().next() : constraints[i].getTypeErasure();
        }
        return constraints;
    }

    private void inferFromOneArgument(JavaType parameter, JavaType argument, JavaType[] typeParameters, JavaType[] constraints) {
        JavaType a;
        if (argument == null || parameter == null) {
            return;
        }
        if (!ContextImageB.hasTypeParameter(parameter, typeParameters)) {
            return;
        }
        if (argument.isPrimitive()) {
            if ("null".equals(argument.getQualifiedName())) {
                return;
            }
            a = ContextImageB.applyBoxingConversion((PrimitiveType)argument, this.compiler.provider, this.compiler.jdkVersion);
        } else {
            a = argument;
        }
        this.inferFromOneArgumentImpl(parameter, a, typeParameters, constraints);
    }

    private void inferFromOneArgumentImpl(JavaType f, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        if (f == null || a == null) {
            return;
        }
        block0 : switch (f.getElementKind()) {
            case 11: {
                JavaWildcardType wildcardType = (JavaWildcardType)f;
                Collection<JavaType> bounds = wildcardType.getUpperBounds();
                if (bounds.isEmpty()) {
                    bounds = wildcardType.getLowerBounds();
                }
                if (bounds.isEmpty()) break;
                block5: for (JavaType boundType : bounds) {
                    int count = tArray.length;
                    for (int i = 0; i < count; ++i) {
                        if (!boundType.equals(tArray[i])) continue;
                        constraints[i] = a;
                        continue block5;
                    }
                }
                break;
            }
            case 10: {
                int count = tArray.length;
                for (int i = 0; i < count; ++i) {
                    if (!f.equals(tArray[i])) continue;
                    constraints[i] = a;
                    break block0;
                }
                break;
            }
            case 3: {
                JavaClass g;
                if (f.isArray() && a.isArray()) {
                    this.inferFromOneArgumentImpl(f.getComponentType(), a.getComponentType(), tArray, constraints);
                    break;
                }
                if (!f.hasActualTypeArguments() || this.inferFromClass(f, g = f.getTypeErasure(), a, tArray, constraints)) break;
                for (JavaType supertype : a.getHierarchy()) {
                    if (this.inferFromClass(f, g, supertype, tArray, constraints)) break;
                }
                break;
            }
        }
    }

    private boolean inferFromClass(JavaType f, JavaType g, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        boolean match = g.equals(a.getTypeErasure());
        if (a.hasActualTypeArguments() && match) {
            Iterator<JavaType> fActuals = f.getActualTypeArguments().iterator();
            Iterator<JavaType> aActuals = a.getActualTypeArguments().iterator();
            while (fActuals.hasNext() && aActuals.hasNext()) {
                JavaType u = fActuals.next();
                JavaType v = aActuals.next();
                this.inferFromOneArgumentImpl(u, v, tArray, constraints);
            }
        }
        return match;
    }
}

