/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatLayer1;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentListSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;

abstract class FormatLayer2
extends FormatLayer1 {
    FormatLayer2() {
    }

    public final void print(TypeSym sym) {
        NameSym name;
        TypeSym qualifier;
        boolean isJdk80OrAbove = sym.getJdkVersion().isJdk8OrAbove();
        if (isJdk80OrAbove) {
            List<SourceAnnotation> annotations = sym.getSourceAnnotations();
            Sym parent = sym.getParentSym();
            if (parent != null && (parent.symKind == 9 || parent.symKind == 19 || parent.symKind == 18 || parent.symKind == 13)) {
                annotations = ((ObjectSym)parent).getDeclaredTypeAnnotations(true);
            }
            for (SourceAnnotation annotation : annotations) {
                this.handle((Sym)((Object)annotation));
            }
        }
        if ((qualifier = sym.getTypeSym()) != null) {
            this.handle(qualifier);
            this.print('.');
        }
        if ((name = sym.getNameSym()) != null) {
            this.handle(name);
        }
        this.handleTypeArguments(sym);
        List<List<SourceAnnotation>> baseAnnotations = isJdk80OrAbove ? sym.getBaseArrayDimensionsTypeAnnotations() : null;
        for (int i = 0; i < sym.typeBaseDimension; ++i) {
            if (isJdk80OrAbove && !baseAnnotations.isEmpty()) {
                for (SourceAnnotation annotation : baseAnnotations.get(i)) {
                    this.print(' ');
                    this.handle((Sym)((Object)annotation));
                    this.print(' ');
                }
            }
            this.print((short)50);
            this.print((short)71);
        }
        if (sym.isVarargs()) {
            this.print((short)80);
        }
    }

    public void print(TypeArgumentListSym sym) {
        List<SourceTypeArgument> arguments = sym.getTypeArguments();
        this.printTypeArgumentList(arguments);
    }

    public void print(TypeArgumentSym sym) {
        switch (sym.argBound) {
            default: {
                this.print((short)69);
                break;
            }
            case 1: {
                this.print((short)69, ' ');
                this.print((short)110, ' ');
                this.handle(sym.getTypeSym());
                break;
            }
            case 2: {
                this.print((short)69, ' ');
                this.print((short)133, ' ');
                this.handle(sym.getTypeSym());
                break;
            }
            case 0: {
                this.handle(sym.getTypeSym());
            }
        }
    }

    protected void handleTypeArguments(TypeSym typeSym) {
        if (typeSym.isGeneric()) {
            this.printTypeArgumentList(typeSym.getTypeArguments());
        }
    }

    protected void printTypeArgumentList(Collection typeArguments) {
        this.printTypeArgumentsStart();
        Iterator iterator = typeArguments.iterator();
        boolean needComma = false;
        while (iterator.hasNext()) {
            if (needComma) {
                this.print((short)39);
            }
            this.handle((Sym)iterator.next());
            needComma = true;
        }
        this.print('>');
    }
}

