/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatLayer2;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.IntersectionTypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodReferenceExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;

abstract class FormatLayer3
extends FormatLayer2 {
    FormatLayer3() {
    }

    public final void print(AnnotateExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(ArrayAccessExpr e) {
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
        } else {
            this.print((short)15);
        }
        ListExpr list = (ListExpr)e.getNthOperandSym(1);
        this.handleArrayDereferences(list);
    }

    public final void print(ArrayCreatorExpr e) {
        ListExpr list = (ListExpr)e.getNthOperandSym(0);
        boolean initialized = list.exprOptcode == 5;
        this.print((short)124, ' ');
        TypeSym typeSym = e.getTypeSym();
        if (typeSym != null) {
            if (initialized) {
                this.handle(typeSym);
            } else {
                this.enter(typeSym);
                if (typeSym.getJdkVersion().isJdk8OrAbove()) {
                    List<SourceAnnotation> annotations = typeSym.getSourceAnnotations();
                    for (SourceAnnotation annotation : annotations) {
                        this.handle((Sym)((Object)annotation));
                    }
                }
                this.handle(typeSym.getNameSym());
                this.handleTypeArguments(typeSym);
                this.leave(typeSym);
            }
        }
        if (initialized) {
            if (this.preferences.getBoolean(96)) {
                this.indent(-1);
            }
            this.handle(list);
        } else {
            this.handleArrayDereferences(list);
            int dimensions = typeSym.getArrayDimension();
            for (int i = 0; i < dimensions; ++i) {
                this.print((short)50);
                this.print((short)71);
            }
        }
    }

    public final void print(AssignExpr e) {
        ClassBodySym bodySym;
        ClassCreatorExpr expr;
        ClassSym classSym;
        this.handle(e.getNthOperandSym(0));
        this.print(FormatLayer3.opt2tk(e.exprOptcode));
        Expr rhs = e.getNthOperandSym(1);
        int wrapBoundary = 58;
        if (rhs.symKind == 59 && (classSym = (expr = (ClassCreatorExpr)rhs).getClassSym()) != null && classSym.isAnonymousClass() && ((bodySym = classSym.getBodySym()) == null || bodySym.getChildren().size() > 0)) {
            wrapBoundary = 83;
        }
        this.markWrapBoundary(wrapBoundary);
        this.handle(rhs);
    }

    public final void print(ClassCreatorExpr e) {
        ClassSym sym;
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
            this.print('.');
        }
        this.print((short)124, ' ');
        if (e.isGeneric()) {
            this.printTypeArgumentList(e.getTypeArguments());
        }
        this.handle(e.getTypeSym());
        ListExpr args = e.getArgumentListSym();
        if (args != null) {
            this.handleArguments(args);
        }
        if ((sym = e.getClassSym()) != null) {
            this.enter(sym);
            this.handle(e.getBodySym());
            this.leave(sym);
        }
    }

    public final void print(DotExpr e) {
        Expr lhs = e.getNthOperandSym(0);
        if (lhs != null) {
            this.handle(lhs);
            this.printImmediatelyTrailingWhitespace(lhs);
            boolean markBoundary = true;
            switch (lhs.symKind) {
                case 53: 
                case 61: {
                    markBoundary = false;
                }
            }
            if (markBoundary) {
                this.markWrapBoundary(56);
            }
            this.print((short)43);
        }
        this.handle(e.getNameSym());
    }

    public final void print(InfixExpr e) {
        int count = e.getOperandCount();
        short tk = FormatLayer3.opt2tk(e.exprOptcode);
        if (tk == 67 && this.preferences.getBoolean(100)) {
            for (int i = 0; i < count; ++i) {
                Expr expr = e.getNthOperandSym(i);
                if (!this.isLiteralStringEndingInEol(expr)) continue;
                this.forceLineWrapping();
                break;
            }
        }
        boolean needOperator = false;
        Expr lastE = null;
        for (int i = 0; i < count; ++i) {
            if (needOperator) {
                if (this.preferences.getBoolean(92)) {
                    this.markWrapBoundary(58);
                }
                this.handleInfixOperator(tk);
                switch (tk) {
                    case 67: {
                        if (this.preferences.getBoolean(100) && this.isLiteralStringEndingInEol(lastE)) {
                            this.emitter.performLineWrapping();
                            this.forceLineWrapping();
                            break;
                        }
                    }
                    default: {
                        if (this.preferences.getBoolean(92)) break;
                        this.markWrapBoundary(58);
                    }
                }
            }
            lastE = e.getNthOperandSym(i);
            this.handle(lastE);
            if (tk == 67 && !needOperator && this.isLiteralStringEndingInEol(lastE)) {
                this.emitter.performLineWrapping();
            }
            this.printImmediatelyTrailingWhitespace(lastE);
            needOperator = true;
        }
    }

    private boolean isLiteralStringEndingInEol(Expr e) {
        if (e != null && e.exprOptcode == 27) {
            LiteralExpr le = (LiteralExpr)e;
            String s = le.literalString;
            return s.endsWith("\\n\"");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(ListExpr e) {
        block24: {
            Sym parent;
            if (e.exprOptcode == 26) {
                return;
            }
            boolean spaceBeforeOpenBrace = this.preferences.getBoolean(49);
            boolean isArrayConstant = e.exprOptcode == 5;
            boolean isNestedArrayConstant = false;
            for (parent = e.getParentSym(); parent != null && parent.symKind != 2; parent = parent.getParentSym()) {
                if (parent.symKind != 55 || ((ListExpr)parent).exprOptcode != 5) continue;
                isNestedArrayConstant = true;
                break;
            }
            try {
                int count = e.getOperandCount();
                boolean cuddleEmptyBraces = count == 0 && this.preferences.getBoolean(80);
                boolean newlineArrayBraces = this.preferences.getBoolean(24);
                if (isArrayConstant) {
                    if (!cuddleEmptyBraces && newlineArrayBraces) {
                        this.ensureNewlines(1);
                    }
                    for (parent = e.getParentSym(); parent != null; parent = parent.getParentSym()) {
                        if (parent.symKind == 1) {
                            this.preferences.setBoolean(49, false);
                            break;
                        }
                        if (parent.symKind == 2) break;
                    }
                }
                if (cuddleEmptyBraces) {
                    this.print((short)49);
                    this.print((short)70);
                    break block24;
                }
                this.print((short)49, ' ');
                this.indent(1);
                if (!isNestedArrayConstant) {
                    if (isArrayConstant) {
                        this.clearWrapBoundaries();
                    }
                    if (count > 0 && isArrayConstant && newlineArrayBraces) {
                        this.println();
                    } else {
                        this.markWrapBoundary(60);
                    }
                }
                int id = this.push();
                try {
                    int i;
                    this.markWrapAlignment();
                    int linesEmitted = this.emitter.newlinesEmitted();
                    boolean needComma = false;
                    for (i = 0; i < count; ++i) {
                        if (needComma) {
                            this.print((short)39);
                            this.markWrapBoundary(60);
                        }
                        Expr operand = e.getNthOperandSym(i);
                        this.handle(operand);
                        this.printImmediatelyTrailingWhitespace(operand);
                        needComma = true;
                    }
                    if (e.flag_extraComma()) {
                        this.print((short)39);
                    }
                    int n = i = count > 0 ? e.getNthOperandSym((int)(count - 1)).symSiblingIndex + 1 : 0;
                    while (i < e.treeChildren.length) {
                        Sym sym = e.treeChildren[i];
                        if (sym.isFilter((byte)95) && sym.symEnd <= e.symEnd) {
                            this.handle(sym);
                        }
                        ++i;
                    }
                    if (isArrayConstant && !isNestedArrayConstant && (count > 0 && newlineArrayBraces || linesEmitted < this.emitter.newlinesEmitted())) {
                        this.ensureNewlines(1);
                        this.indent(-1);
                        this.print((short)70);
                    } else {
                        this.print(' ');
                        this.print((short)70);
                    }
                }
                finally {
                    this.pop(id);
                }
            }
            finally {
                this.preferences.setBoolean(49, spaceBeforeOpenBrace);
            }
        }
    }

    public final void print(LiteralExpr e) {
        this.print(e.getText());
    }

    public final void print(MethodCallExpr e) {
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
            this.printImmediatelyTrailingWhitespace(lhs);
            boolean markBoundary = true;
            switch (lhs.symKind) {
                case 53: 
                case 61: {
                    markBoundary = false;
                }
            }
            if (markBoundary) {
                this.markWrapBoundary(56);
            }
            this.print((short)43);
        }
        if (e.isGeneric()) {
            this.printTypeArgumentList(e.getTypeArguments());
        }
        this.handle(e.getNameSym());
        ListExpr args = e.getArgumentListSym();
        if (args != null) {
            this.indent(-1);
            this.handleArguments(args);
        }
    }

    public final void print(QuestionExpr e) {
        this.markWrapAlignment();
        Expr operand = e.getNthOperandSym(0);
        this.handle(operand);
        this.printImmediatelyTrailingWhitespace(operand);
        boolean spaceQuestionAfter = this.preferences.getBoolean(38);
        boolean spaceQuestionBefore = this.preferences.getBoolean(37);
        boolean spaceColonBefore = this.preferences.getBoolean(39);
        boolean wrapBeforeTernaryOperators = this.preferences.getBoolean(94);
        if (wrapBeforeTernaryOperators) {
            this.markWrapBoundary(59);
        }
        if (spaceQuestionBefore && !this.flag_justindent) {
            this.print(' ');
        }
        this.print((short)69);
        if (spaceQuestionAfter) {
            this.print(' ');
        }
        if (!wrapBeforeTernaryOperators) {
            this.markWrapBoundary(59);
        }
        operand = e.getNthOperandSym(1);
        this.handle(operand);
        this.printImmediatelyTrailingWhitespace(operand);
        if (wrapBeforeTernaryOperators) {
            this.markWrapBoundary(59);
        }
        if (spaceColonBefore && !this.flag_justindent) {
            this.print(' ');
        }
        this.print((short)38);
        if (!wrapBeforeTernaryOperators) {
            this.markWrapBoundary(59);
        }
        operand = e.getNthOperandSym(2);
        this.handle(operand);
        this.printImmediatelyTrailingWhitespace(operand);
    }

    public final void print(SimpleNameExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(TypecastExpr e) {
        this.print((short)55);
        this.handle((Sym)((Object)e.getFirstOperand()));
        this.print((short)72);
        boolean spaceTypecastAfter = this.preferences.getBoolean(41);
        if (spaceTypecastAfter) {
            this.print(' ');
        }
        this.handle((Sym)((Object)e.getSecondOperand()));
    }

    public final void print(TypeExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(IntersectionTypeExpr e) {
        List exprs = e.getOperands();
        boolean printAnd = false;
        for (Object expr : exprs) {
            if (printAnd) {
                if (this.preferences.getBoolean(92)) {
                    this.markWrapBoundary(58);
                }
                this.handleInfixOperator((short)34);
                if (!this.preferences.getBoolean(92)) {
                    this.markWrapBoundary(58);
                }
            } else {
                printAnd = true;
            }
            this.handle((Sym)expr);
            this.printImmediatelyTrailingWhitespace((Sym)expr);
        }
    }

    public final void print(UnaryExpr e) {
        switch (e.exprOptcode) {
            case 14: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)103);
                break;
            }
            case 49: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)133);
                break;
            }
            case 50: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)136);
                break;
            }
            case 45: 
            case 46: {
                this.handle(e.getNthOperandSym(0));
                this.handlePostfixOperator(FormatLayer3.opt2tk(e.exprOptcode));
                break;
            }
            default: {
                this.handlePrefixOperator(FormatLayer3.opt2tk(e.exprOptcode));
                this.handle(e.getNthOperandSym(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(WrapperExpr e) {
        this.print((short)55);
        int id = this.push();
        try {
            this.markWrapAlignment();
            Expr operand = e.getNthOperandSym(0);
            this.handle(operand);
            this.printImmediatelyTrailingWhitespace(operand);
        }
        finally {
            this.pop(id);
        }
        this.print((short)72);
    }

    public final void print(MethodReferenceExpr e) {
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
            this.printImmediatelyTrailingWhitespace(lhs);
            this.print((short)81);
        }
        if (e.isGeneric()) {
            this.printTypeArgumentList(e.getTypeArguments());
        }
        this.handle(e.getNameSym());
    }

    public final void print(LambdaExpr e) {
        SourceElement body;
        if (e.hasFormalParameters()) {
            this.handle(e.getFormalsSym());
        } else {
            if (e.hasParenthesizedParameters()) {
                this.print((short)55);
            }
            List<SourceLambdaParameter> formalParameters = e.getFormalParameters();
            boolean printComma = false;
            for (SourceLambdaParameter formalParameter : formalParameters) {
                if (printComma) {
                    this.print((short)39);
                } else {
                    printComma = true;
                }
                this.handle((Sym)((Object)formalParameter));
            }
            if (e.hasParenthesizedParameters()) {
                this.print((short)72);
            }
        }
        boolean surroundSpaces = this.preferences.getBoolean(101);
        if (surroundSpaces) {
            this.print(' ');
        }
        this.print((short)82);
        if (surroundSpaces) {
            this.print(' ');
        }
        if ((body = e.getBody()) != null) {
            if (body.getSymbolKind() == 2) {
                BlockSym block = (BlockSym)body;
                int statementCount = block.getCodeElements().size();
                if (statementCount > 1) {
                    if (this.preferences.getBoolean(22)) {
                        this.ensureNewlines(1);
                    }
                    this.handle(block);
                } else {
                    this.print((short)49, ' ');
                    if (statementCount > 0) {
                        this.handle((Sym)block.getCodeElements().get(0));
                        this.newlinesPending = 0;
                    }
                    this.print(' ');
                    this.print((short)70);
                }
            } else {
                this.indent(1);
                this.handle((Sym)body);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleArguments(ListExpr e) {
        boolean spaceArgumentsBefore = this.preferences.getBoolean(42);
        if (spaceArgumentsBefore) {
            this.print(' ');
        }
        this.enter(e);
        this.print((short)55);
        int id = this.push();
        try {
            this.indent(1);
            this.markWrapAlignment();
            int count = e.getOperandCount();
            if (count > 0) {
                boolean needComma = false;
                for (int i = 0; i < count; ++i) {
                    if (needComma) {
                        this.print((short)39);
                        this.markWrapBoundary(61);
                    }
                    Expr argument = e.getNthOperandSym(i);
                    this.handle(argument);
                    needComma = true;
                    this.printImmediatelyTrailingWhitespace(argument);
                }
            } else {
                for (int x = 0; x < e.treeChildren.length; ++x) {
                    Sym child = e.treeChildren[x];
                    if (!child.isFilter((byte)95)) continue;
                    this.handle(child);
                }
            }
        }
        finally {
            this.pop(id);
        }
        this.leave(e, (short)72);
    }

    private void handleArrayDereferences(ListExpr e) {
        this.enter(e);
        int count = e.getOperandCount();
        for (int i = 0; i < count; ++i) {
            Expr op = e.getNthOperandSym(i);
            this.print((short)50);
            this.handle(op);
            this.print((short)71);
        }
        this.leave(e);
    }

    protected final void handleInfixOperator(short tk) {
        boolean spaceBinaryopAround = this.preferences.getBoolean(46);
        if (spaceBinaryopAround && !this.flag_justindent) {
            this.print(' ');
        }
        this.print(tk);
        if (spaceBinaryopAround) {
            this.print(' ');
        }
    }

    private void handlePrefixOperator(short tk) {
        this.print(tk);
    }

    private void handlePostfixOperator(short tk) {
        this.print(tk);
    }

    protected static short opt2tk(byte opt) {
        short tk;
        if (opt != 0 && (tk = OPT_tokens[opt - 1]) != 0) {
            return tk;
        }
        FormatLayer3.panic();
        return 0;
    }
}

