/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.LineWrappingEmitter;
import oracle.javatools.parser.java.v2.internal.format.ReindentingEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class SavedTextEmitter
extends Emitter {
    private final LineWrappingEmitter printer = new LineWrappingEmitter();
    private int savedTextOffset = -1;
    private String savedTextHeader = "";
    private int savedTextHeaderOffset = -1;
    private int savedTextColumn = 0;
    private ReindentingEmitter reindenter = new ReindentingEmitter();
    private int docDepth = 0;

    SavedTextEmitter() {
    }

    @Override
    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String text = this.toString();
        textBuffer.insert(0, text.toCharArray());
        return textBuffer;
    }

    @Override
    public String toString() {
        return this.printer.getBuffer().toString();
    }

    @Override
    void setFormatDriver(FormatDriver formatter) {
        super.setFormatDriver(formatter);
        this.printer.setFormatDriver(formatter);
        this.reindenter.setFormatDriver(formatter);
    }

    @Override
    void init(Sym s) {
        super.init(s);
        this.printer.init(s);
        this.reindenter.init(s);
    }

    @Override
    void fini(Sym s) {
        this.reindenter.fini(s);
        this.printer.fini(s);
        super.fini(s);
    }

    boolean isWrapCapable() {
        return this.printer.isWrapCapable();
    }

    @Override
    int getColumn() {
        return this.printer.getColumn();
    }

    @Override
    int getColumnStamp() {
        return this.printer.getColumnStamp();
    }

    @Override
    int getOffset() {
        return this.printer.getOffset();
    }

    @Override
    void markWrapBoundary(int height) {
        this.printer.markWrapBoundary(height);
    }

    @Override
    void clearWrapBoundaries() {
        this.printer.clearWrapBoundaries();
    }

    @Override
    void forceLineWrapping() {
        this.printer.forceLineWrapping();
    }

    @Override
    void performLineWrapping() {
        this.printer.performLineWrapping();
    }

    @Override
    int getLastIndent() {
        return this.printer.getLastIndent();
    }

    @Override
    boolean hasWrapBoundariesBefore(int stackHeight) {
        return this.printer.hasWrapBoundariesBefore(stackHeight);
    }

    @Override
    void enter(Sym s) {
        if (s.isSkeleton()) {
            return;
        }
        if (s.isFilter((byte)94)) {
            ++this.docDepth;
        }
        if ((s.symFormat & '\u0001') != 0) {
            this.savedTextOffset = -1;
        } else if (s.symKind == 70) {
            s.saveText();
        }
        if ((s.symFormat & 4) != 0) {
            this.savedTextOn(s);
        }
        this.printer.enter(s);
    }

    @Override
    void leave(Sym s) {
        if (s.isSkeleton()) {
            return;
        }
        if (s.isFilter((byte)94)) {
            --this.docDepth;
        }
        this.printer.leave(s);
        if ((s.symFormat & 4) != 0) {
            this.savedTextOff(s);
        }
        s.symFormat = '\u0000';
    }

    @Override
    void emitIndent(int spaces) {
        this.printer.emitIndent(spaces);
    }

    @Override
    void emit(String s) {
        this.printer.emit(s);
    }

    @Override
    void emit(short tk) {
        this.printer.emit(tk);
    }

    @Override
    void emit(char ch) {
        this.printer.emit(ch);
    }

    @Override
    void insert(int offset, char ch) {
        this.printer.insert(offset, ch);
    }

    @Override
    int newlinesEmitted() {
        return this.printer.newlinesEmitted();
    }

    private void savedTextOn(Sym s) {
        int length;
        if (!SavedTextEmitter.srcIsLexical(s.symKind) && !SavedTextEmitter.srcIsDoc(s.symKind)) {
            return;
        }
        if (this.docDepth > 0 && s.symKind != 70) {
            return;
        }
        if (s.symKind == 77) {
            return;
        }
        StringBuffer buffer = this.printer.getBuffer();
        this.savedTextOffset = length = buffer.length();
        int lineStart = LineWrappingEmitter.lastIndexOfNewline(buffer) + 1;
        this.savedTextHeader = lineStart < length ? buffer.substring(lineStart) : "";
        this.savedTextHeaderOffset = lineStart;
        this.savedTextColumn = this.printer.getColumn_forIndentationUse();
    }

    private void savedTextOff(Sym s) {
        int trailing;
        int leading;
        int end;
        int start;
        String compareText;
        if (this.savedTextOffset == -1) {
            return;
        }
        StringBuffer buffer = this.printer.getBuffer();
        int headerLength = this.savedTextHeader.length();
        if (headerLength > 0 && !this.savedTextHeader.equals(compareText = buffer.substring(start = this.savedTextOffset - headerLength, end = this.savedTextOffset))) {
            int savedTextHeaderChars = 0;
            for (int ptr = 0; ptr < this.savedTextHeader.length(); ++ptr) {
                if (Character.isWhitespace(this.savedTextHeader.charAt(ptr))) continue;
                ++savedTextHeaderChars;
            }
            this.savedTextOffset = this.savedTextHeaderOffset;
            while (savedTextHeaderChars > 0) {
                if (!Character.isWhitespace(buffer.charAt(this.savedTextOffset))) {
                    --savedTextHeaderChars;
                }
                ++this.savedTextOffset;
            }
        }
        int length = buffer.length();
        for (leading = this.savedTextOffset; leading < length && Character.isWhitespace(buffer.charAt(leading)); ++leading) {
        }
        for (trailing = length; leading < trailing && Character.isWhitespace(buffer.charAt(trailing - 1)); --trailing) {
        }
        String savedTrailing = null;
        if (trailing != leading && trailing != length) {
            savedTrailing = buffer.substring(trailing, length);
        }
        String targetText = this.getSavedText(s);
        int targetOffset = leading;
        buffer.setLength(targetOffset);
        buffer.append(targetText);
        if (savedTrailing != null) {
            buffer.append(savedTrailing);
        }
        this.printer.clearWrapBoundaries();
        this.savedTextOffset = -1;
        ++this.printer.resetCounter;
    }

    private String getSavedText(Sym s) {
        String savedText = s.getText();
        savedText = savedText.replace("\r\n", "\n");
        savedText = savedText.replace('\r', '\n');
        int firstNewline = savedText.indexOf(10);
        if (s.symKind == 70 && firstNewline >= 0) {
            int indentation = this.savedTextColumn;
            int savedLength = savedText.length();
            this.reindenter.clear();
            String firstLine = savedText.substring(0, firstNewline);
            this.reindenter.emit(firstLine);
            this.reindenter.emit('\n');
            int prevNewline = firstNewline;
            while (prevNewline < savedLength) {
                boolean notLastLine;
                int nextNewline = savedText.indexOf(10, prevNewline + 1);
                if (nextNewline < 0) {
                    nextNewline = savedLength;
                }
                String nextLine = savedText.substring(prevNewline + 1, nextNewline);
                boolean indentNextLine = false;
                int star = nextLine.indexOf(42);
                if (star >= 0) {
                    indentNextLine = true;
                    for (int i = 0; i < star; ++i) {
                        char ch = nextLine.charAt(i);
                        if (Character.isWhitespace(ch)) continue;
                        indentNextLine = false;
                        break;
                    }
                }
                if (indentNextLine) {
                    this.reindenter.emitIndent(indentation, false);
                    this.reindenter.emit(" *");
                    String chompedLine = nextLine.substring(star + 1);
                    this.reindenter.emit(chompedLine);
                } else {
                    this.reindenter.emit(nextLine);
                }
                boolean bl = notLastLine = nextNewline < savedLength;
                if (notLastLine) {
                    this.reindenter.emit('\n');
                }
                prevNewline = nextNewline;
            }
            String reindented = this.reindenter.toString();
            return reindented;
        }
        return savedText;
    }
}

