/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Map;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateBinding;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class AnnotateSym
extends TreeSym
implements SourceAnnotation {
    public int dimensionIndex;

    public AnnotateSym() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    @Override
    public int getElementKind() {
        return 2;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public final SourceElement getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            SourceElement sourceElement;
            MemberSym memberSym = this.getOwningMemberSym();
            if (memberSym != null && (sourceElement = memberSym.getSourceElement()) instanceof SourceHasModifiers) {
                return CommonUtilities.getSourceElement(this, (SourceHasModifiers)sourceElement);
            }
            return null;
        }
        return this;
    }

    @Override
    public SourceListExpression getArgumentList() {
        return this.getArgumentListSym();
    }

    public ListExpr getArgumentListSym() {
        return (ListExpr)this.getChildOrCreateSkeleton((byte)55);
    }

    @Override
    public int getArgumentCount() {
        ListExpr child = (ListExpr)this.getChild((byte)55);
        if (child == null) {
            return 0;
        }
        return child.getOperandCount();
    }

    @Override
    public SourceExpression getArgumentAt(int i) {
        ListExpr e;
        if (this.getArgumentCount() > 0 && (e = this.getArgumentListSym()) != null) {
            return e.getOperandAt(i);
        }
        return null;
    }

    @Override
    public SourceName getNameElement() {
        SourceTypeReference sourceTypeRef = this.getSourceType();
        if (sourceTypeRef != null) {
            return sourceTypeRef.getNameElement();
        }
        return null;
    }

    @Override
    public void setNameElement(SourceName name) {
        SourceTypeReference sourceTypeRef = this.getSourceType();
        if (sourceTypeRef != null) {
            sourceTypeRef.setNameElement(name);
        }
    }

    @Override
    public String getName() {
        SourceTypeReference sourceTypeRef = this.getSourceType();
        if (sourceTypeRef != null) {
            return sourceTypeRef.getName();
        }
        return "";
    }

    @Override
    public void setName(String name) {
        SourceTypeReference sourceTypeRef = this.getSourceType();
        if (sourceTypeRef != null) {
            sourceTypeRef.setName(name);
        }
    }

    @Override
    public JavaType getResolvedType() {
        TypeSym typeSym;
        if (!this.isResolved()) {
            this.resolve();
        }
        return (typeSym = this.getTypeSym()) == null ? null : typeSym.getResolvedType();
    }

    @Override
    public JavaType getAnnotationType() {
        return this.getResolvedType();
    }

    @Override
    public Map getArguments() {
        return InternalUtilities.getAnnotationArguments(this);
    }

    @Override
    public Map<String, Object> getUnresolvedArguments() {
        return InternalUtilities.getUnresolvedAnnotationArguments(this);
    }

    @Override
    public AnnotationComponents getComponents() {
        AnnotationComponents currentComponents;
        if (!this.isCompiled()) {
            this.compile();
        }
        if ((currentComponents = this.getAnnotationComponents()) == null) {
            currentComponents = AnnotationComponents.createInstance(this.getResolvedType());
            this.setAnnotationComponents(currentComponents);
        }
        return currentComponents;
    }

    @Override
    public boolean isInherited() {
        return CommonUtilities.isInheritedAnnotation(this);
    }

    @Override
    public JavaElement getCompiledObject() {
        return this;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    @Override
    protected Sym createSkeletonImpl(byte symKind) {
        if (symKind == 55) {
            return SymFactory.createExpr(this.symFile, (byte)26);
        }
        return super.createSkeletonImpl(symKind);
    }

    @Override
    protected void setupSkeleton() {
        this.getArgumentListSym();
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (!this.isCompiled()) {
            this.setCompiled();
            this.resolveImpl(compiler);
            super.compileImpl(compiler);
            if (!compiler.skipCompilations()) {
                compiler.compile(this);
            }
        }
        return this;
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        if (!this.isResolved()) {
            this.setResolved();
            compiler.resolve(this);
        }
        return this;
    }

    @Override
    public Sym getScope() {
        Sym scope = super.getScope();
        if (scope.isFilter((byte)86)) {
            return scope.getScope();
        }
        return scope;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 27: 
            case 55: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        NameSym nameSym;
        String qualifiedName;
        JavaType resolvedType;
        AnnotateSym sym = (AnnotateSym)super.cloneSelf(targetFile);
        SourcePreferences preferences = this.symFile.getPreferences();
        if (preferences.getBoolean(67) && (resolvedType = this.getResolvedType()) != null && (qualifiedName = resolvedType.getRawName()) != null && (nameSym = sym.getNameSym()) != null) {
            nameSym.nameString = qualifiedName;
        }
        return sym;
    }

    private boolean isResolved() {
        AnnotateBinding binding = this.getAnnotateBinding();
        return binding.isResolved();
    }

    private void setResolved() {
        AnnotateBinding binding = this.getAnnotateBinding();
        binding.setResolved();
    }

    private boolean isCompiled() {
        AnnotateBinding binding = this.getAnnotateBinding();
        return binding.isCompiled();
    }

    private void setCompiled() {
        AnnotateBinding binding = this.getAnnotateBinding();
        binding.setCompiled();
    }

    private AnnotationComponents getAnnotationComponents() {
        AnnotateBinding binding = this.getAnnotateBinding();
        return binding.getAnnotationComponents();
    }

    private void setAnnotationComponents(AnnotationComponents annotationComponents) {
        AnnotateBinding binding = this.getAnnotateBinding();
        binding.setAnnotationComponents(annotationComponents);
    }

    private AnnotateBinding getAnnotateBinding() {
        AnnotateBinding binding = (AnnotateBinding)this.getInternalBinding(7);
        if (binding != null) {
            return binding;
        }
        binding = new AnnotateBinding();
        this.setInternalBinding(binding);
        return binding;
    }
}

