/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;

public final class FormalsSym
extends TreeSym
implements SourceFormalParameterList {
    public List getSourceParameters() {
        return this.getChildren((byte)97);
    }

    public List getParameters() {
        return this.getObjects((byte)97);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 13: 
            case 28: 
            case 31: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChild(int index, Sym child, byte filter) {
        Sym actualChild = this.checkForLocalVariableTemplate(child);
        super.linkChild(index, actualChild, filter);
    }

    @Override
    protected void replaceChild(int index, Sym child, byte filter) {
        Sym actualChild = this.checkForLocalVariableTemplate(child);
        super.replaceChild(index, actualChild, filter);
    }

    private Sym checkForLocalVariableTemplate(Sym child) {
        if (child == null) {
            return null;
        }
        if (child.symKind == 17 && (child.symFormat & 2) != 0 && child.symParent == null) {
            LocalVariableSym variableSym = (LocalVariableSym)child;
            SymFactory factory = this.symFile.getSymFactory();
            FormalParameterSym parameterSym = (FormalParameterSym)factory.createFormalParameter(variableSym);
            return parameterSym;
        }
        return child;
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        switch (added.symKind) {
            case 17: {
                added.symKind = (byte)13;
            }
        }
        super.linkChildTrigger(added, filter);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return this;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        out.print('(');
        List things = this.getSourceParameters();
        int count = things.size();
        if (count > 0) {
            Iterator iterator = things.iterator();
            boolean needComma = false;
            while (iterator.hasNext()) {
                if (needComma) {
                    out.print(", ");
                }
                Sym parameter = (Sym)iterator.next();
                FormalsSym.print(parameter, out, argument);
                needComma = true;
            }
        }
        out.print(')');
    }

    protected void print_signature(PrintWriter out, boolean parameterNames) {
        if (parameterNames) {
            this.print(out);
        } else {
            this.print(out, 3);
        }
    }
}

