/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceName;

public final class NameSym
extends Sym
implements SourceName {
    public String nameString = "";

    public int getTokenValue() {
        return 4;
    }

    @Override
    public String getName() {
        return this.getValue();
    }

    @Override
    public String getText() {
        return this.nameString;
    }

    @Override
    public void setText(String text) {
        this.nameString = text;
        this.setTextImpl(text);
    }

    @Override
    public String getValue() {
        return this.nameString;
    }

    @Override
    public void setValue(String value) {
        if (value.equals(this.nameString)) {
            return;
        }
        if (!this.isValidName(value)) {
            throw new IllegalArgumentException("Invalid name: '" + String.valueOf(value) + "'");
        }
        this.setText(value);
        Sym parentSym = this.getParentSym();
        if (parentSym != null) {
            ((TreeSym)parentSym).setNameTrigger(value);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        NameSym sym = (NameSym)super.cloneSelf(targetFile);
        sym.nameString = this.nameString;
        return sym;
    }

    private boolean isValidName(String name) {
        Sym parentSym = this.getParentSym();
        if (parentSym == null) {
            return NameSym.isValidImportName(name);
        }
        switch (parentSym.symKind) {
            case 14: {
                return NameSym.isValidImportName(name);
            }
            case 21: 
            case 27: {
                return NameSym.isValidQualifiedName(name);
            }
        }
        return NameSym.isValidSimpleName(name);
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        parent.setNameTrigger(this.nameString);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        buffer.append('\"');
        buffer.append(this.nameString);
        buffer.append('\"');
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        out.print(this.nameString);
    }

    @Override
    public void print(PrintWriter out) {
        out.print(this.nameString);
    }
}

