/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.EnumSet;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class SymIndex
extends TreeSym {
    public Sym getSymAt(int offset) {
        return this.getSymAt(offset, null);
    }

    public Sym getSymAt(int offset, EnumSet<SourceFile.ElementAtMask> incomingMask) {
        EnumSet<SourceFile.ElementAtMask> mask = incomingMask == null ? EnumSet.of(SourceFile.ElementAtMask.DEFAULT) : EnumSet.copyOf(incomingMask);
        if (mask.contains((Object)SourceFile.ElementAtMask.NONE)) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        if (!mask.contains((Object)SourceFile.ElementAtMask.ALL) && !mask.contains((Object)SourceFile.ElementAtMask.DEFAULT)) {
            mask.add(SourceFile.ElementAtMask.DEFAULT);
        }
        if (mask.contains((Object)SourceFile.ElementAtMask.ALL)) {
            mask.add(SourceFile.ElementAtMask.BLANKLINES);
            mask.add(SourceFile.ElementAtMask.COMMENTS);
        }
        Sym sym = this.getSymAtImpl(offset, mask);
        while (sym != null && sym.testSymFlag((byte)2)) {
            sym = sym.symParent;
        }
        if (sym == null) {
            return this.symFile;
        }
        sym = this.filterCommentsAndBlanks(sym, offset, mask);
        while (sym != null && sym.testSymFlag((byte)2)) {
            sym = sym.symParent;
        }
        return sym == null ? this.symFile : sym;
    }

    private Sym filterCommentsAndBlanks(Sym sym, int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        if (sym.symKind == 77) {
            if (mask.contains((Object)SourceFile.ElementAtMask.BLANKLINES)) {
                return sym;
            }
            return sym.symParent;
        }
        if (sym.symKind == 76) {
            if (mask.contains((Object)SourceFile.ElementAtMask.COMMENTS)) {
                return sym;
            }
            return sym.symParent;
        }
        if (sym.symKind == 70) {
            return this.getChildSymAt(sym, offset);
        }
        return sym;
    }

    private Sym getSymAtImpl(int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        TokenArray tokenArray = this.symFile.getTokenArray();
        int i = tokenArray.findTokenIndexAtOffset(offset);
        if (i >= 0 && i < this.treeChildren.length) {
            if (this.treeChildren.length > 1 && i == this.treeChildren.length - 1 && (mask.contains((Object)SourceFile.ElementAtMask.BEFORE) || mask.contains((Object)SourceFile.ElementAtMask.NEAREST))) {
                return this.treeChildren[i - 1];
            }
            return this.treeChildren[i];
        }
        int insertionPoint = -(i + 1);
        if (insertionPoint == 0 || insertionPoint >= this.treeChildren.length) {
            return this.symFile;
        }
        Sym ancestor = this.getEnclosingSym(this.treeChildren[insertionPoint], offset);
        if (ancestor == null) {
            return this.symFile;
        }
        Sym closestParent = this.getChildSymAt(ancestor, offset);
        if (!(closestParent instanceof TreeSym)) {
            return closestParent;
        }
        Sym leftChild = this.treeChildren[insertionPoint - 1];
        Sym rightChild = this.treeChildren[insertionPoint];
        ancestor = this.getEnclosingSym(leftChild, rightChild);
        if (ancestor == null) {
            return this.symFile;
        }
        leftChild = this.getChildSymBefore(ancestor, offset, mask);
        rightChild = this.getChildSymAfter(ancestor, offset, mask);
        if (mask.contains((Object)SourceFile.ElementAtMask.SAME_LINE)) {
            boolean atBeginOfLine = this.isOnBeginOrEndOfLine(offset, false);
            boolean atEndOfLine = this.isOnBeginOrEndOfLine(offset, true);
            if (atEndOfLine && !atBeginOfLine) {
                return leftChild;
            }
            if (atBeginOfLine && !atEndOfLine) {
                return rightChild;
            }
        }
        if (mask.contains((Object)SourceFile.ElementAtMask.STRUCTURAL)) {
            int rightLevel;
            int leftLevel = this.getStructuralLevel(leftChild);
            if (leftLevel > (rightLevel = this.getStructuralLevel(rightChild))) {
                return leftChild;
            }
            if (rightLevel > leftLevel) {
                return rightChild;
            }
        }
        if (mask.contains((Object)SourceFile.ElementAtMask.NEAREST)) {
            int rightDistance;
            int leftDistance = offset - leftChild.getEndOffset() + 1;
            if (leftDistance < (rightDistance = rightChild.getStartOffset() - offset)) {
                return leftChild;
            }
            if (rightDistance < leftDistance) {
                return rightChild;
            }
        }
        if (mask.contains((Object)SourceFile.ElementAtMask.BEFORE)) {
            return leftChild;
        }
        if (mask.contains((Object)SourceFile.ElementAtMask.AFTER)) {
            return rightChild;
        }
        return closestParent;
    }

    private int getStructuralLevel(Sym sym) {
        switch (sym.symKind) {
            case 77: {
                return 1;
            }
            case 76: {
                return 2;
            }
            case 70: {
                return 3;
            }
        }
        return 4;
    }

    private boolean isOnBeginOrEndOfLine(int offset, boolean lookForEndOfLine) {
        TextBuffer buffer = this.symFile.getTextBuffer();
        if (buffer != null) {
            while (offset >= 0 && offset < buffer.getLength()) {
                char c = buffer.getChar(offset);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                if (lookForEndOfLine) {
                    ++offset;
                    continue;
                }
                --offset;
            }
            if (offset >= buffer.getLength() || offset < 0) {
                return true;
            }
        }
        return false;
    }

    private Sym getEnclosingSym(Sym sym, int offset) {
        while (sym != null && (sym.getStartOffset() > offset || offset >= sym.getEndOffset())) {
            sym = sym.symParent;
        }
        return sym;
    }

    private Sym getEnclosingSym(Sym sym1, Sym sym2) {
        if (sym1.getStartOffset() <= sym2.getStartOffset() && sym1.getEndOffset() >= sym2.getEndOffset()) {
            return sym1;
        }
        if (sym2.getStartOffset() <= sym1.getStartOffset() && sym2.getEndOffset() >= sym1.getEndOffset()) {
            return sym2;
        }
        Sym sym = sym1.symParent;
        while (sym != null && (sym.getStartOffset() > sym1.getStartOffset() || sym.getStartOffset() > sym2.getStartOffset() || sym.getEndOffset() < sym1.getEndOffset() || sym.getEndOffset() < sym2.getEndOffset())) {
            sym = sym.symParent;
        }
        return sym;
    }

    private Sym getChildSymAt(Sym parent, int offset) {
        if (parent instanceof TreeSym) {
            Sym child;
            int start;
            TreeSym treeSym = (TreeSym)parent;
            int count = treeSym.treeChildren.length;
            for (int i = 0; i < count && offset >= (start = (child = treeSym.treeChildren[i]).getStartOffset()); ++i) {
                int end = child.getEndOffset();
                if (offset >= end) continue;
                return this.getChildSymAt(child, offset);
            }
        }
        return parent;
    }

    private Sym getChildSymBefore(Sym parent, int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        if (parent instanceof TreeSym) {
            TreeSym treeSym = (TreeSym)parent;
            int count = treeSym.treeChildren.length;
            for (int i = count - 1; i >= 0; --i) {
                int end;
                Sym child = treeSym.treeChildren[i];
                if (!mask.contains((Object)SourceFile.ElementAtMask.BLANKLINES) && child.symKind == 77 || !mask.contains((Object)SourceFile.ElementAtMask.COMMENTS) && child.symKind == 76 || (end = child.getEndOffset()) < 0 || end > offset) continue;
                Sym grandChild = this.getChildSymBefore(child, offset, mask);
                if (grandChild.getEndOffset() == end) {
                    return grandChild;
                }
                return child;
            }
        }
        return parent;
    }

    private Sym getChildSymAfter(Sym parent, int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        if (parent instanceof TreeSym) {
            TreeSym treeSym = (TreeSym)parent;
            for (Sym child : treeSym.treeChildren) {
                int start;
                if (!mask.contains((Object)SourceFile.ElementAtMask.BLANKLINES) && child.symKind == 77 || !mask.contains((Object)SourceFile.ElementAtMask.COMMENTS) && child.symKind == 76 || (start = child.getStartOffset()) < 0 || start <= offset) continue;
                Sym grandChild = this.getChildSymAfter(child, offset, mask);
                if (grandChild.getStartOffset() == start) {
                    return grandChild;
                }
                return child;
            }
        }
        return parent;
    }

    SymIndex(FileSym fileSym) {
        this.symKind = (byte)82;
        this.symFile = fileSym;
        this.buildSelf();
        if (this.treeChildren.length == 0) {
            SymIndex.panic("Empty index");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSelf() {
        FileSym fileSym = this.symFile;
        synchronized (fileSym) {
            TokenArray tokenArray = this.symFile.getTokenArray();
            if (tokenArray == null) {
                SymIndex.panic("No token array");
            }
            int count = tokenArray.tokenCount;
            Sym[] index = new Sym[count];
            int end = this.symFile.indexSelf(index, 0, tokenArray);
            while (end < count) {
                index[end++] = this;
            }
            this.treeChildren = index;
        }
    }
}

