/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.IndirectSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.SymUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public class TreeSym
extends Sym {
    private static final Comparator<Sym> SYMSTART_COMPARATOR = new Comparator<Sym>(){

        @Override
        public int compare(Sym left, Sym right) {
            return left.symStart - right.symStart;
        }

        public boolean equals(Sym left, Sym right) {
            return left.symStart == right.symStart;
        }
    };
    public Sym[] treeChildren = Sym.EMPTY_ARRAY;

    public SourceName getNameElement() {
        return this.getNameSym();
    }

    public void setNameElement(SourceName name) {
        this.setNameSym((NameSym)name);
    }

    public String getName() {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            return nameSym.getValue();
        }
        return "";
    }

    public void setName(String input) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            if (!input.equals(nameSym.getValue())) {
                nameSym.setValue(input);
            }
        } else {
            NameSym newName = (NameSym)this.symFile.factory.createName(input);
            this.setNameSym(newName);
        }
    }

    public final SourceBlock getBlock() {
        return this.getBlockSym();
    }

    public final void setBlock(SourceBlock block) {
        this.setBlockSym((BlockSym)block);
    }

    public final SourceTypeReference getSourceType() {
        return this.getTypeSym();
    }

    public final String getTypeName() {
        TypeSym typeSym = this.getTypeSym();
        if (typeSym != null) {
            return typeSym.getName();
        }
        return "";
    }

    public UnresolvedType getUnresolvedType() {
        String typeName;
        TypeSym typeSym = this.getTypeSym();
        if (typeSym != null && (typeName = typeSym.getName()).length() > 0) {
            int arrayDimension = typeSym.getArrayDimension();
            for (int i = 0; i < arrayDimension; ++i) {
                typeName = typeName + "[]";
            }
            return QuickUnresolvedType.createUnresolvedType(typeName);
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public final void setSourceType(SourceTypeReference type) {
        this.setTypeSym((TypeSym)type);
    }

    public final SourceExpression getExpression() {
        return this.getExpressionSym();
    }

    public final Expr getExpressionSym() {
        return (Expr)this.getChild((byte)90);
    }

    public void setExpressionSym(Expr e) {
        this.setSym((byte)90, e);
    }

    @Override
    public List getSourceAnnotations() {
        return this.getChildren((byte)1);
    }

    public final SourceClass getEnclosingClass() {
        return this.getOwningClassSym();
    }

    protected final void setSym(byte filter, Sym sym) {
        int found = this.indexOf(filter);
        if (found != -1) {
            if (sym != null) {
                this.replaceChild(found, sym);
            } else {
                this.unlinkChild(found);
            }
        } else if (sym != null) {
            this.add(sym);
        }
    }

    public final NameSym getNameSym() {
        return (NameSym)this.getChild((byte)20);
    }

    public final void setNameSym(NameSym sym) {
        this.setSym((byte)20, sym);
    }

    public final BlockSym getBlockSym() {
        return (BlockSym)this.getChild((byte)2);
    }

    public final void setBlockSym(BlockSym sym) {
        this.setSym((byte)2, sym);
    }

    public TypeSym getTypeSym() {
        return (TypeSym)this.getChild((byte)27);
    }

    public void setTypeSym(TypeSym sym) {
        this.setSym((byte)27, sym);
    }

    public final SourceDocComment getDocComment() {
        return this.getJavadocSym();
    }

    public final void setDocComment(SourceDocComment newComment) {
        this.setJavadocSym((DocCommentSym)newComment);
    }

    public DocCommentSym getJavadocSym() {
        return (DocCommentSym)this.getChild((byte)70);
    }

    public void setJavadocSym(DocCommentSym sym) {
        this.setSym((byte)70, sym);
    }

    @Override
    public final boolean hasHiddenTag() {
        DocCommentSym doc = this.getJavadocSym();
        if (doc != null) {
            return doc.isHidden();
        }
        return false;
    }

    @Override
    public final boolean hasDeprecatedTag() {
        DocCommentSym doc = this.getJavadocSym();
        if (doc != null) {
            return doc.isDeprecated();
        }
        return false;
    }

    protected void add(Sym child, byte filter) {
        if (this.indexOf(child) != -1) {
            return;
        }
        int targetIndex = this.getTargetIndex(child, filter);
        if (targetIndex < 0) {
            return;
        }
        int count = this.treeChildren.length;
        if (count < targetIndex) {
            targetIndex = count;
        }
        this.linkChild(targetIndex, child, filter);
    }

    @Override
    protected final void add(Sym child) {
        this.add(child, (byte)0);
    }

    @Override
    protected final void replace(Sym oldSym, Sym newSym) {
        int index = this.indexOf(oldSym);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.replaceChild(index, newSym);
    }

    @Override
    protected final void remove(Sym child) {
        int index = this.indexOf(child);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(index);
    }

    @Override
    protected final void remove(Sym child, byte filter) {
        int index = this.indexOf(child);
        if (index == -1) {
            TreeSym.errorInvalidParent();
        }
        this.unlinkChild(index, filter);
    }

    @Override
    public final int indexOf(Sym sym) {
        if (sym == null) {
            return -1;
        }
        int index = sym.symSiblingIndex;
        if (sym.getParentSym() == this && index != -1) {
            Sym atIndex;
            if (index < this.treeChildren.length && (atIndex = this.getNthChildImpl(index)) == sym) {
                return index;
            }
            try {
                TreeSym.panic();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            if (sym != this.getNthChildImpl(i)) continue;
            return i;
        }
        return super.indexOf(sym);
    }

    @Override
    public final int lastIndexOf(Sym sym) {
        return this.indexOf(sym);
    }

    public List getChildren() {
        return new SimpleSymList(0);
    }

    @Override
    public List getChildren(int mask) {
        if (mask == 0) {
            return kEmptyList;
        }
        if (mask == 65536) {
            return this.getChildren();
        }
        if (mask < 0 || mask >> 8 == 0 || (mask & 0xFFFFFF00) == -256) {
            return this.getChildren((byte)mask);
        }
        if (mask == 131072) {
            return this.getChildren((byte)76);
        }
        if (mask == 262144) {
            return this.getChildren((byte)77);
        }
        int supportedMask = 458752;
        if ((mask & 0xFFF8FFFF) != 0) {
            throw new IllegalArgumentException("Invalid mask " + Integer.toHexString(mask));
        }
        if ((mask & 0x10000) == 0) {
            TreeSym.notImplementedYet();
        }
        boolean showComments = (mask & 0x20000) != 0;
        boolean showBlanklines = (mask & 0x40000) != 0;
        return new SimpleSymList(0, showComments, showBlanklines);
    }

    @Override
    public Collection getSyms(byte filter) {
        if (98 <= filter && filter < 101) {
            return new SymCollection(filter);
        }
        return this.getChildren(filter);
    }

    @Override
    public final void clearOffsets() {
        super.clearOffsets();
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            this.getNthChildImpl(i).clearOffsets();
        }
    }

    @Override
    protected final void clearFormatInfo() {
        super.clearFormatInfo();
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            this.getNthChildImpl(i).clearFormatInfo();
        }
    }

    public void hookupChildren() {
        if ((this.symFormat & 2) == 0) {
            TreeSym.panic("Should only be called by the factory");
        }
        Sym[] children = this.treeChildren;
        int count = children.length;
        for (int i = 0; i < count; ++i) {
            Sym parent;
            Sym child = children[i];
            if (this.symFile != child.symFile) {
                TreeSym.errorDifferentFile();
            }
            if ((parent = child.symParent) == this) continue;
            if (parent != null) {
                TreeSym.errorHasParent();
            }
            SymOperation op = null;
            if ((child.symFormat & 2) == 0) {
                SymTransaction transaction = this.verifyTransaction();
                op = transaction.newOperation((byte)1);
                op.opNewSym = child;
                op.opParent = this;
                op.opTargetIndex = i;
            } else if (!this.isValidChild(child, (byte)0)) {
                TreeSym.errorCannotLink(child, this);
            }
            child.symParent = this;
            if (op != null) {
                op.buildSelf();
            }
            child.linkSelfTrigger(this, (byte)0);
            this.linkChildTrigger(child, (byte)0);
        }
        this.renumberSelf();
    }

    protected final int getTargetIndex(Sym sym) {
        return this.getTargetIndex(sym, (byte)0);
    }

    protected int getTargetIndex(Sym sym, byte filter) {
        return this.treeChildren.length;
    }

    protected final void linkChild(int index, Sym child) {
        this.linkChild(index, child, (byte)0);
    }

    protected final void unlinkChild(int index) {
        this.unlinkChild(index, (byte)0);
    }

    protected final void replaceChild(int index, Sym child) {
        this.replaceChild(index, child, (byte)0);
    }

    protected void linkChild(int index, Sym child, byte filter) {
        this.linkChildImpl(index, child, filter);
    }

    protected void unlinkChild(int index, byte filter) {
        this.unlinkChildImpl(index, filter);
    }

    protected void replaceChild(int index, Sym child, byte filter) {
        this.replaceChildImpl(index, child, filter);
    }

    private boolean verifyLinkChild(Sym child, byte filter) {
        if (!this.isValidChild(child, filter)) {
            return false;
        }
        if (this.indexOf(child) != -1) {
            return false;
        }
        if (child.isSynthetic() && !child.isFilter((byte)96)) {
            TreeSym.errorSynthetic();
        }
        if (child.getParentSym() != null) {
            TreeSym.errorHasParent();
        }
        if (this.symFile != child.symFile) {
            TreeSym.errorDifferentFile();
        }
        if (child.getContextImpl() != null) {
            TreeSym.panic("Cannot have both parent and context");
        }
        return true;
    }

    private boolean verifyUnlinkChild(Sym target, byte filter, boolean replace) {
        if (target.isSynthetic() && !target.isFilter((byte)96)) {
            TreeSym.errorSynthetic();
        }
        if (!replace && target.isSkeleton() && !target.isFilter((byte)96)) {
            TreeSym.errorSkeleton();
        }
        if (target.getParentSym() == null) {
            TreeSym.errorNoParent();
        }
        return true;
    }

    private void linkChildImpl(int index, Sym child, byte filter) {
        if (child == null) {
            TreeSym.panic("Null made it this far into the internals. Why?");
        }
        if (!this.verifyLinkChild(child, filter)) {
            TreeSym.errorCannotLink(child, this);
        }
        int count = this.treeChildren.length;
        if (index < 0 || count < index) {
            TreeSym.errorInvalidRange(index);
        }
        if (index < count) {
            Sym existing = this.treeChildren[index];
            if (existing.symKind == child.symKind && existing.isSkeleton()) {
                this.replaceChild(index, child, filter);
                return;
            }
        }
        SymOperation op = null;
        if (!child.isSkeleton()) {
            SymTransaction transaction = this.verifyTransaction();
            op = transaction.newOperation((byte)1);
            op.opNewSym = child;
            op.opParent = this;
            op.opTargetIndex = index;
            op.opFilter = filter;
            op.symSiblingIndex = index;
        }
        this.linkChildImpl0(index, child);
        if (op != null) {
            op.buildSelf();
        }
        child.linkSelfTrigger(this, filter);
        this.linkChildTrigger(child, filter);
    }

    private void unlinkChildImpl(int index, byte filter) {
        Sym target;
        int count = this.treeChildren.length;
        if (index < 0 || count <= index) {
            TreeSym.errorInvalidRange(index);
        }
        if (!this.verifyUnlinkChild(target = this.treeChildren[index], filter, false)) {
            throw new IllegalArgumentException("May not be removed");
        }
        SymOperation op = null;
        SymTransaction transaction = this.verifyTransaction();
        op = transaction.newOperation((byte)3);
        op.opTarget = target;
        op.opParent = this;
        op.opTargetIndex = index;
        op.opFilter = filter;
        op.symSiblingIndex = index;
        this.unlinkChildImpl0(index);
        if (op != null) {
            op.buildSelf();
        }
        target.unlinkSelfTrigger(this, filter);
        this.unlinkChildTrigger(target, filter);
    }

    private void replaceChildImpl(int index, Sym child, byte filter) {
        int count = this.treeChildren.length;
        if (index < 0 || count < index) {
            throw new IndexOutOfBoundsException("" + index);
        }
        Sym target = this.treeChildren[index];
        if (target == child) {
            return;
        }
        if (child == null) {
            this.unlinkChild(index, filter);
            return;
        }
        if (!this.verifyLinkChild(child, filter)) {
            TreeSym.errorCannotLink(child, this);
        }
        if (!this.verifyUnlinkChild(target, filter, true)) {
            throw new IllegalArgumentException();
        }
        SymOperation op = null;
        SymTransaction transaction = this.verifyTransaction();
        op = transaction.newOperation((byte)2);
        op.opTarget = target;
        op.opNewSym = child;
        op.opParent = this;
        op.opTargetIndex = index;
        op.opFilter = filter;
        op.symSiblingIndex = index;
        op.buildSelf();
        this.replaceChildImpl0(index, child);
        if (op != null) {
            op.buildSelf();
        }
        target.unlinkSelfTrigger(this, filter);
        this.unlinkChildTrigger(target, filter);
        child.linkSelfTrigger(this, filter);
        this.linkChildTrigger(child, filter);
    }

    private void linkChildImpl0(int index, Sym child) {
        int count = this.treeChildren.length;
        Sym[] newArray = new Sym[count + 1];
        if (index != 0) {
            System.arraycopy(this.treeChildren, 0, newArray, 0, index);
        }
        if (index != count) {
            System.arraycopy(this.treeChildren, index, newArray, index + 1, count - index);
        }
        newArray[index] = child;
        this.treeChildren = newArray;
        this.renumberSelf();
        child.symParent = this;
    }

    private void unlinkChildImpl0(int index) {
        int count = this.treeChildren.length;
        Sym target = this.treeChildren[index];
        Sym[] newArray = new Sym[count - 1];
        if (index != 0) {
            System.arraycopy(this.treeChildren, 0, newArray, 0, index);
        }
        if (index != count - 1) {
            System.arraycopy(this.treeChildren, index + 1, newArray, index, count - 1 - index);
        }
        this.treeChildren = newArray;
        this.renumberSelf();
        target.symParent = null;
    }

    private void replaceChildImpl0(int index, Sym child) {
        Sym target = this.treeChildren[index];
        this.treeChildren[index] = child;
        target.symSiblingIndex = -1;
        child.symSiblingIndex = index;
        target.symParent = null;
        child.symParent = this;
    }

    protected void setNameTrigger(String newValue) {
    }

    protected void linkChildTrigger(Sym added, byte filter) {
        if (this.isSkeleton()) {
            this.symFlags = (byte)(this.symFlags & 0xFFFFFFFB);
            this.symFormat = (char)(this.symFormat | 2);
        } else {
            this.unsaveText();
        }
    }

    protected void unlinkChildTrigger(Sym removed, byte filter) {
        if (!this.isSkeleton()) {
            this.unsaveText();
        }
    }

    protected Sym createSkeleton(byte symKind) {
        Sym sym = this.createSkeletonImpl(symKind);
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.symFlags = (byte)(sym.symFlags | 4);
        this.add(sym);
        return sym;
    }

    protected Sym createSkeletonImpl(byte symKind) {
        return SymFactory.createNode(this.symFile, symKind);
    }

    protected final Sym getChildOrCreateSkeleton(byte symKind) {
        Sym foundSym = this.getChild(symKind);
        if (foundSym != null) {
            return foundSym;
        }
        return this.createSkeleton(symKind);
    }

    protected void setupSkeleton() {
    }

    private void renumberSelf() {
        int count = this.treeChildren.length;
        for (int i = count - 1; i >= 0; --i) {
            Sym child = this.treeChildren[i];
            child.symSiblingIndex = i;
            if (child.symKind != 77) continue;
            BlanklineSym blanklineSym = (BlanklineSym)child;
            blanklineSym.blanklineFollowing = (byte)-1;
        }
    }

    private void buildSelf0(SyntaxData data) {
        Sym[] dataKids = data.kids;
        int childCount = data.kidCount;
        if (childCount == 0) {
            return;
        }
        int oldChildCount = this.treeChildren.length;
        int newLength = childCount + oldChildCount;
        Sym[] array = new Sym[newLength];
        if (oldChildCount == 0) {
            System.arraycopy(dataKids, 0, array, 0, childCount);
        } else {
            System.arraycopy(this.treeChildren, 0, array, 0, oldChildCount);
            System.arraycopy(dataKids, 0, array, oldChildCount, childCount);
        }
        this.treeChildren = array;
        this.renumberSelf();
    }

    @Override
    public void buildSelf() {
        SyntaxData data;
        if (this.hasSyntaxData() && (data = this.symData) != null) {
            this.buildSelf0(data);
        }
        super.buildSelf();
        this.setupSkeleton();
    }

    @Override
    public void addToSubtree(Sym target) {
        if (this.symStart <= target.symStart && target.symEnd <= this.symEnd) {
            int childCount = this.treeChildren.length;
            for (int j = 0; j < childCount; ++j) {
                Sym child = this.treeChildren[j];
                if (target.symEnd < child.symStart) {
                    this.linkChildImpl0(j, target);
                    return;
                }
                if (target.symStart == child.symStart) {
                    if (target.symKind == 77) {
                        this.linkChildImpl0(j, target);
                    } else {
                        this.linkChildImpl0(j + 1, target);
                    }
                    return;
                }
                if (target.symEnd > child.symEnd) continue;
                child.addToSubtree(target);
                return;
            }
            this.linkChildImpl0(childCount, target);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        TreeSym sym = (TreeSym)super.cloneSelf(targetFile);
        int count = this.treeChildren.length;
        sym.treeChildren = new Sym[count];
        for (int i = 0; i < count; ++i) {
            Sym clone;
            sym.treeChildren[i] = clone = this.treeChildren[i].cloneSelf(targetFile);
        }
        sym.hookupChildren();
        sym.renumberSelf();
        return sym;
    }

    @Override
    public final void sortSelf() {
        Arrays.sort(this.treeChildren, SYMSTART_COMPARATOR);
        this.renumberSelf();
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            this.getNthChildImpl(i).compile(compiler);
        }
        return super.compileImpl(compiler);
    }

    @Override
    protected void verboseSelf(StringBuilder stringBuffer) {
        NameSym nameSym = this.getNameSym();
        if (nameSym != null) {
            stringBuffer.append(" name \"");
            stringBuffer.append(this.getName());
            stringBuffer.append('\"');
        }
    }

    @Override
    public void describeSelf(int depth) {
        super.describeSelf(depth);
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            this.getNthChildImpl(i).describeSelf(depth + 1);
        }
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        Sym target = this;
        if ((this.symFlags & 2) != 0) {
            target = this.symParent;
        }
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            Sym child = this.getNthChildImpl(i);
            while (pos < child.symStart) {
                index[pos++] = target;
            }
            pos = child.indexSelf(index, pos, tokens);
        }
        return super.indexSelf(index, pos, tokens);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print((Sym)this);
    }

    @Override
    public final boolean traverseSelf(Sym.SymTraversal traverse) {
        try {
            boolean traverseChildren = traverse.enter(this);
            if (traverseChildren) {
                boolean keepGoing;
                int count = this.treeChildren.length;
                for (int i = 0; i < count && (keepGoing = this.getNthChildImpl(i).traverseSelf(traverse)); ++i) {
                }
            }
            return traverse.leave(this);
        }
        catch (Sym.TraversalCancelledException e) {
            return false;
        }
    }

    private boolean childrenMatch(TreeSym otherSym) {
        int count = this.treeChildren.length;
        Sym[] otherChildren = otherSym.treeChildren;
        int otherCount = otherChildren.length;
        int thisi = 0;
        for (int otheri = 0; thisi < count && otheri < otherCount; ++thisi, ++otheri) {
            Sym thisChild = this.getNthChildImpl(thisi);
            Sym otherChild = otherSym.getNthChildImpl(otheri);
            if (thisChild.symKind != otherChild.symKind) {
                while (otheri + 1 < otherCount && otherChild.symKind == 77) {
                    otherChild = otherSym.getNthChildImpl(++otheri);
                }
                while (thisi + 1 < count && thisChild.symKind == 77) {
                    thisChild = this.getNthChildImpl(++thisi);
                }
            }
            if (thisChild.symKind == otherChild.symKind) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean traverseDual(Sym other, Sym.SymDualTraversal traverse) {
        try {
            boolean traverseChildren = traverse.enter(this, other);
            if (traverseChildren && other instanceof TreeSym) {
                int count = this.treeChildren.length;
                TreeSym otherSym = (TreeSym)other;
                Sym[] otherChildren = otherSym.treeChildren;
                int otherCount = otherChildren.length;
                if (this.childrenMatch(otherSym)) {
                    int thisi = 0;
                    for (int otheri = 0; thisi < count && otheri < otherCount; ++thisi, ++otheri) {
                        boolean keepGoing;
                        Sym thisChild = this.getNthChildImpl(thisi);
                        Sym otherChild = otherSym.getNthChildImpl(otheri);
                        if (thisChild.symKind != otherChild.symKind) {
                            while (otheri < otherCount && otherChild.symKind == 77) {
                                otherChild = otherSym.getNthChildImpl(++otheri);
                            }
                            while (thisi < count && thisChild.symKind == 77) {
                                thisChild = this.getNthChildImpl(++thisi);
                            }
                        }
                        if (keepGoing = thisChild.traverseDual(otherChild, traverse)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = 0; i < otherCount; ++i) {
                        Sym otherChild = otherChildren[i];
                        byte targetSymKind = otherChild.symKind;
                        int similarCount = this.count(targetSymKind);
                        if (similarCount == 1) {
                            boolean keepGoing = this.getChild(targetSymKind).traverseDual(otherChild, traverse);
                            if (keepGoing) continue;
                        } else {
                            boolean keepGoing;
                            int n = 0;
                            for (int j = i - 1; j >= 0; --j) {
                                if (otherChildren[j].symKind != targetSymKind) continue;
                                ++n;
                            }
                            if (n >= similarCount || (keepGoing = this.getNthChild(targetSymKind, n).traverseDual(otherChild, traverse))) {
                                continue;
                            }
                        }
                        break;
                    }
                }
            }
            return traverse.leave(this, other);
        }
        catch (Sym.TraversalCancelledException e) {
            return false;
        }
    }

    @Override
    protected void adjustSelfImpl(Sym other) {
        super.adjustSelfImpl(other);
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction != null && other instanceof TreeSym && this.childrenMatch((TreeSym)other)) {
            int count = this.treeChildren.length;
            TreeSym otherSym = (TreeSym)other;
            Sym[] otherChildren = otherSym.treeChildren;
            int otherCount = otherChildren.length;
            int thisi = count - 1;
            int otheri = otherCount - 1;
            while (thisi >= 0) {
                boolean otherChildIsBlankline;
                Sym thisChild = this.getNthChildImpl(thisi);
                Sym otherChild = null;
                if (otheri >= 0) {
                    otherChild = otherSym.getNthChildImpl(otheri);
                }
                boolean thisChildIsBlankline = thisChild.symKind == 77;
                boolean bl = otherChildIsBlankline = otherChild != null && otherChild.symKind == 77;
                if (thisChildIsBlankline || otherChildIsBlankline) {
                    if (thisChildIsBlankline && otherChildIsBlankline) {
                        thisChild.adjustSelfImpl(otherChild);
                    } else {
                        while (otheri >= 0 && otherChild.symKind == 77) {
                            Sym blanklineSym = SymFactory.createNode(this.symFile, 77);
                            blanklineSym.adjustSelfImpl(otherChild);
                            this.linkChild(thisi + 1, blanklineSym);
                            if (otheri == 0) break;
                            otherChild = otherSym.getNthChildImpl(--otheri);
                        }
                        while (thisi >= 0 && thisChild.symKind == 77) {
                            this.unlinkChild(thisi);
                            if (thisi == 0) break;
                            thisChild = this.getNthChildImpl(--thisi);
                        }
                    }
                }
                --thisi;
                --otheri;
            }
        }
    }

    @Override
    public void print(PrintWriter out, int argument) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            TreeSym.print(this.getNthChildImpl(i), out, argument);
        }
    }

    public final void print_annotations(PrintWriter out) {
        List things = this.getSourceAnnotations();
        int count = things.size();
        if (count > 0) {
            for (Sym thing : things) {
                TreeSym.print(thing, out);
            }
            out.println();
        }
    }

    public final Sym getNthChild(int index) {
        if (index < 0) {
            return null;
        }
        if (this.treeChildren.length <= index) {
            return null;
        }
        return this.getNthChildImpl(index);
    }

    private final Sym getNthChildImpl(int index) {
        Sym sym = this.treeChildren[index];
        if (sym.symKind != 79) {
            return sym;
        }
        IndirectSym indirectSym = (IndirectSym)sym;
        return indirectSym.getSym();
    }

    @Override
    public final Sym getChildAt(int tokenPos) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            Sym child = this.getNthChildImpl(i);
            if (tokenPos < child.symStart) break;
            if (tokenPos > child.symEnd) continue;
            if ((child.symFlags & 2) == 0) {
                return child;
            }
            return null;
        }
        return null;
    }

    public ListIterator getSiblingsFor(Sym sym) {
        List list = this.getChildren();
        int index = list.indexOf(sym);
        if (index == -1) {
            return kEmptyList.listIterator();
        }
        ListIterator iterator = list.listIterator(index);
        return iterator;
    }

    public ListIterator getSiblingsFor(Sym sym, int mask) {
        List list = this.getChildren(mask);
        int index = list.indexOf(sym);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        ListIterator iterator = list.listIterator(index);
        return iterator;
    }

    protected Sym getSiblingBeforeFor(Sym sym) {
        int index = this.indexOf(sym);
        if (index == -1) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            Sym child = this.getNthChildImpl(i);
            switch (child.symKind) {
                default: {
                    return child;
                }
                case 76: 
                case 77: 
            }
        }
        return null;
    }

    protected Sym getSiblingAfterFor(Sym sym) {
        int index = this.indexOf(sym);
        if (index == -1) {
            return null;
        }
        int childCount = this.treeChildren.length;
        for (int i = index + 1; i < childCount; ++i) {
            Sym child = this.getNthChildImpl(i);
            switch (child.symKind) {
                default: {
                    return child;
                }
                case 76: 
                case 77: 
            }
        }
        return null;
    }

    public final int count(byte filter) {
        int childCount = this.treeChildren.length;
        int count = 0;
        for (int i = 0; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            ++count;
        }
        return count;
    }

    public final int indexOf(byte filter) {
        return this.indexOf(filter, 0);
    }

    public final int indexOf(byte filter, int fromIndex) {
        int childCount = this.treeChildren.length;
        for (int i = fromIndex; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfNth(byte filter, int n) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter) || n-- != 0) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(byte filter) {
        int childCount = this.treeChildren.length;
        return this.lastIndexOf(filter, childCount - 1);
    }

    public final int lastIndexOf(byte filter, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            return i;
        }
        return -1;
    }

    public final Sym getChild(byte filter) {
        return this.getNthChild(filter, 0);
    }

    public final Sym getNthChild(byte filter, int n) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter) || n-- != 0) continue;
            return sym;
        }
        return null;
    }

    public final Sym getLastChild(byte filter) {
        int childCount = this.treeChildren.length;
        for (int i = childCount - 1; i >= 0; --i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            return sym;
        }
        return null;
    }

    public final List getChildren(byte filter) {
        return new SimpleSymList(filter);
    }

    @Override
    public final void getChildrenRecursive(byte filter, ArrayList list) {
        if (this.is(filter)) {
            list.add(this);
        }
        int count = this.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            this.getNthChildImpl(i).getChildrenRecursive(filter, list);
        }
    }

    public final JavaElement getObject(byte filter) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            return sym.getCompiledObject();
        }
        return null;
    }

    public final JavaElement getObject(byte filter, int index) {
        int childCount = this.treeChildren.length;
        for (int i = 0; i < childCount; ++i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter) || index-- != 0) continue;
            return sym.getCompiledObject();
        }
        return null;
    }

    public final JavaElement getLastObject(byte filter) {
        int childCount = this.treeChildren.length;
        for (int i = childCount - 1; i >= 0; --i) {
            Sym sym = this.getNthChildImpl(i);
            if (!sym.is(filter)) continue;
            return sym.getCompiledObject();
        }
        return null;
    }

    public final List getObjects(byte filter) {
        int childCount = this.treeChildren.length;
        if (childCount == 0) {
            return kEmptyList;
        }
        SimpleSymList symList = new SimpleSymList(filter);
        ArrayList<JavaElement> list = new ArrayList<JavaElement>();
        for (Sym sym : symList) {
            JavaElement compiledObject = sym.getCompiledObject();
            if (compiledObject == null) continue;
            list.add(compiledObject);
        }
        return list;
    }

    private class SymCollection
    extends AbstractCollection {
        protected final byte filter;

        protected SymCollection(byte filter) {
            this.filter = filter;
        }

        @Override
        public Iterator iterator() {
            return new SymIterator();
        }

        @Override
        public int size() {
            Iterator iterator = this.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++i;
            }
            return i;
        }

        @Override
        public boolean isEmpty() {
            Iterator iterator = this.iterator();
            return !iterator.hasNext();
        }

        @Override
        public boolean add(Object o) {
            String message = "Can't add to Collection.";
            throw new UnsupportedOperationException("Can't add to Collection.");
        }

        @Override
        public boolean remove(Object o) {
            String message = "Can't add to Collection.";
            throw new UnsupportedOperationException("Can't add to Collection.");
        }

        protected class SymIterator
        implements Iterator {
            private Sym next = null;
            private int currentIndex = -1;
            private Iterator childIterator = null;

            SymIterator() {
                this.advance();
            }

            private boolean match(Sym sym) {
                return sym.is(SymCollection.this.filter) && !sym.isSkeleton();
            }

            private byte getChildFilter(Sym sym) {
                switch (SymCollection.this.filter) {
                    case 98: 
                    case 99: {
                        if (sym.symKind != 9) break;
                        return SymCollection.this.filter;
                    }
                    case 100: {
                        if (sym.symKind != 18) break;
                        return SymCollection.this.filter;
                    }
                }
                return -1;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                Sym saved = this.next;
                this.advance();
                return saved;
            }

            @Override
            public void remove() {
                String message = "Immutable Collection.";
                throw new UnsupportedOperationException("Immutable Collection.");
            }

            private void advance() {
                if (this.childIterator != null) {
                    while (this.childIterator.hasNext()) {
                        this.next = (Sym)this.childIterator.next();
                        if (!this.match(this.next)) continue;
                        return;
                    }
                    this.childIterator = null;
                }
                this.next = null;
                int count = TreeSym.this.treeChildren.length;
                if (count <= this.currentIndex) {
                    return;
                }
                ++this.currentIndex;
                while (this.currentIndex < count) {
                    this.next = TreeSym.this.treeChildren[this.currentIndex];
                    byte childFilter = this.getChildFilter(this.next);
                    this.childIterator = childFilter != -1 ? this.next.getSyms(childFilter).iterator() : null;
                    if (this.match(this.next)) {
                        return;
                    }
                    if (this.childIterator != null) {
                        while (this.childIterator.hasNext()) {
                            this.next = (Sym)this.childIterator.next();
                            if (!this.match(this.next)) continue;
                            return;
                        }
                    }
                    ++this.currentIndex;
                }
                this.next = null;
            }
        }
    }

    private class SimpleSymList
    extends AbstractList {
        protected final byte filter;
        protected final boolean showComments;
        protected final boolean showBlanklines;

        protected SimpleSymList(byte filter) {
            this(filter, filter == 76, filter == 77);
        }

        protected SimpleSymList(byte filter, boolean showComments, boolean showBlanklines) {
            this.filter = filter;
            if (98 <= filter && filter < 101) {
                throw new IllegalArgumentException("" + filter);
            }
            this.showComments = showComments;
            this.showBlanklines = showBlanklines;
        }

        protected final boolean match(Sym sym) {
            if (!sym.is(this.filter) || sym.isSkeleton()) {
                return false;
            }
            switch (sym.symKind) {
                case 76: {
                    return this.showComments;
                }
                case 77: {
                    return this.showBlanklines;
                }
            }
            return true;
        }

        protected final int logical2real(int logical) {
            int childCount = TreeSym.this.treeChildren.length;
            if (childCount == 0) {
                return -1;
            }
            for (int i = 0; i < childCount; ++i) {
                Sym sym = TreeSym.this.getNthChildImpl(i);
                if (!this.match(sym) || logical-- != 0) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Iterator iterator() {
            return new SimpleSymListIterator();
        }

        @Override
        public ListIterator listIterator() {
            return new SimpleSymListIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return new SimpleSymListIterator(index);
        }

        @Override
        public int size() {
            int childCount = TreeSym.this.treeChildren.length;
            if (childCount == 0) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < childCount; ++i) {
                Sym sym = TreeSym.this.getNthChildImpl(i);
                if (!this.match(sym)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean isEmpty() {
            int childCount = TreeSym.this.treeChildren.length;
            if (childCount == 0) {
                return true;
            }
            for (int i = 0; i < childCount; ++i) {
                Sym sym = TreeSym.this.getNthChildImpl(i);
                if (!this.match(sym)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object get(int index) {
            int realIndex = this.logical2real(index);
            if (realIndex != -1) {
                return TreeSym.this.treeChildren[realIndex];
            }
            return null;
        }

        @Override
        public Object[] toArray() {
            int childCount = TreeSym.this.treeChildren.length;
            if (childCount == 0) {
                return Sym.EMPTY_ARRAY;
            }
            ArrayList<Sym> list = new ArrayList<Sym>();
            for (int i = 0; i < childCount; ++i) {
                Sym sym = TreeSym.this.getNthChildImpl(i);
                if (!this.match(sym)) continue;
                list.add(sym);
            }
            int count = list.size();
            return list.toArray(new Sym[count]);
        }

        @Override
        public boolean add(Sym sym) {
            if (sym == null) {
                return false;
            }
            TreeSym.this.add(sym, this.filter);
            return true;
        }

        @Override
        public void add(int index, Sym sym) {
            if (sym == null) {
                return;
            }
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            int realIndex = this.logical2real(index);
            if (realIndex != -1) {
                TreeSym.this.linkChild(realIndex, sym, this.filter);
            } else {
                int lastIndex = TreeSym.this.lastIndexOf(this.filter);
                if (lastIndex >= 0) {
                    TreeSym.this.linkChild(lastIndex + 1, sym, this.filter);
                } else {
                    TreeSym.this.add(sym, this.filter);
                }
            }
        }

        @Override
        public Object set(int index, Sym sym) {
            if (sym == null) {
                return this.remove(index);
            }
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            int realIndex = this.logical2real(index);
            if (realIndex == -1) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return this.setImpl(realIndex, sym);
        }

        private Object setImpl(int realIndex, Sym sym) {
            Sym old = TreeSym.this.treeChildren[realIndex];
            if (old == sym) {
                return old;
            }
            if (sym.symParent != TreeSym.this) {
                TreeSym.this.replaceChild(realIndex, sym, this.filter);
            } else {
                int symIndex = TreeSym.this.indexOf(sym);
                if (symIndex == -1) {
                    SymUtilities.errorInvalidParent();
                }
                Sym tmp = SymFactory.createNode(TreeSym.this.symFile, 77);
                TreeSym.this.replaceChild(symIndex, tmp);
                TreeSym.this.replaceChild(realIndex, sym, this.filter);
                TreeSym.this.replaceChild(symIndex, old, this.filter);
            }
            return old;
        }

        public boolean contains(Sym sym) {
            return this.indexOf(sym) != -1;
        }

        public int indexOf(Sym target) {
            if (target == null) {
                return -1;
            }
            int count = TreeSym.this.treeChildren.length;
            int index = 0;
            for (int i = 0; i < count; ++i) {
                Sym sym = TreeSym.this.getNthChildImpl(i);
                if (sym == target) {
                    return index;
                }
                if (!this.match(sym)) continue;
                ++index;
            }
            return -1;
        }

        public int lastIndexOf(Sym sym) {
            return this.indexOf(sym);
        }

        @Override
        public boolean add(Object o) {
            return this.add((Sym)o);
        }

        @Override
        public void add(int index, Object o) {
            this.add(index, (Sym)o);
        }

        @Override
        public Object set(int index, Object o) {
            return this.set(index, (Sym)o);
        }

        @Override
        public boolean remove(Object o) {
            int i = this.indexOf(o);
            if (i == -1) {
                return false;
            }
            this.remove(i);
            return true;
        }

        @Override
        public Object remove(int index) {
            int realIndex = this.logical2real(index);
            if (realIndex == -1) {
                throw new IndexOutOfBoundsException("" + index);
            }
            Sym old = TreeSym.this.treeChildren[realIndex];
            TreeSym.this.unlinkChild(realIndex, this.filter);
            return old;
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Sym)o);
        }

        @Override
        public int indexOf(Object o) {
            return this.indexOf((Sym)o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.lastIndexOf((Sym)o);
        }

        protected class SimpleSymListIterator
        implements ListIterator {
            private int iteratorCursorLogical = -1;
            private int iteratorReturned = -1;
            private int iteratorNext = -1;
            private int iteratorPrev = -1;

            SimpleSymListIterator() {
                this.advance();
            }

            SimpleSymListIterator(int index) {
                while (index >= 0) {
                    if (!this.hasNext()) {
                        throw new IndexOutOfBoundsException("" + index);
                    }
                    this.advance();
                    --index;
                }
            }

            @Override
            public boolean hasNext() {
                return this.iteratorNext < TreeSym.this.treeChildren.length;
            }

            @Override
            public boolean hasPrevious() {
                return this.iteratorPrev >= 0;
            }

            @Override
            public Object next() {
                try {
                    Sym sym;
                    do {
                        if (!this.hasNext()) {
                            return null;
                        }
                        this.iteratorReturned = this.iteratorNext;
                        sym = TreeSym.this.treeChildren[this.iteratorReturned];
                        this.advance();
                    } while (!SimpleSymList.this.match(sym));
                    return sym;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.iteratorNext = TreeSym.this.treeChildren.length;
                    return null;
                }
            }

            @Override
            public int nextIndex() {
                return this.iteratorCursorLogical;
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    return null;
                }
                try {
                    Sym sym;
                    do {
                        if (!this.hasPrevious()) {
                            return null;
                        }
                        this.iteratorReturned = this.iteratorPrev;
                        sym = TreeSym.this.treeChildren[this.iteratorReturned];
                        this.backup();
                    } while (!SimpleSymList.this.match(sym));
                    return sym;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.iteratorPrev = -1;
                    return null;
                }
            }

            @Override
            public int previousIndex() {
                return this.iteratorCursorLogical - 1;
            }

            public void add(Object o) {
                Sym sym = (Sym)o;
                if (!SimpleSymList.this.match(sym)) {
                    throw new IllegalArgumentException("Invalid input");
                }
                SimpleSymList.this.add(this.iteratorNext, sym);
                this.advance();
            }

            @Override
            public void remove() {
                if (0 <= this.iteratorReturned && this.iteratorReturned < TreeSym.this.treeChildren.length) {
                    boolean lastCallWasNext;
                    int removeIndex = this.iteratorReturned;
                    this.iteratorReturned = -1;
                    boolean bl = lastCallWasNext = removeIndex < this.iteratorNext;
                    if (lastCallWasNext) {
                        this.backup();
                    }
                    TreeSym.this.unlinkChild(removeIndex, SimpleSymList.this.filter);
                    this.iteratorNext = this.iteratorPrev;
                    this.advance();
                }
            }

            public void set(Object o) {
                SimpleSymList.this.setImpl(this.iteratorReturned, (Sym)o);
            }

            private void backup() {
                Sym sym;
                if (this.iteratorPrev < 0) {
                    return;
                }
                --this.iteratorCursorLogical;
                this.iteratorNext = this.iteratorPrev--;
                while (this.iteratorPrev >= 0 && !SimpleSymList.this.match(sym = TreeSym.this.treeChildren[this.iteratorPrev])) {
                    --this.iteratorPrev;
                }
            }

            private void advance() {
                Sym sym;
                int count = TreeSym.this.treeChildren.length;
                if (count <= this.iteratorNext) {
                    return;
                }
                ++this.iteratorCursorLogical;
                this.iteratorPrev = this.iteratorNext++;
                while (this.iteratorNext < count && !SimpleSymList.this.match(sym = TreeSym.this.treeChildren[this.iteratorNext])) {
                    ++this.iteratorNext;
                }
            }
        }
    }
}

