/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceBinding;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceClassBinding;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public class DocReferenceSym
extends DocSym
implements SourceDocReference {
    protected static final JavaHasType kEmptyResult = CompilerDriver.kEmptyResult;
    public static final DocReferenceSym[] EMPTY_ARRAY = new DocReferenceSym[0];
    public String refClassName;
    public String refMemberName;
    public List refMethodParameters;
    public String refParameterName;

    private void setRefObject(JavaHasType refObject) {
        DocReferenceBinding binding = new DocReferenceBinding(refObject);
        this.setInternalBinding(binding);
    }

    private JavaHasType getRefObject() {
        DocReferenceBinding binding = (DocReferenceBinding)this.getInternalBinding(15);
        if (binding != null) {
            return binding.getRefObject();
        }
        return null;
    }

    private void setRefClassObject(JavaType refClassObject) {
        DocReferenceClassBinding binding = new DocReferenceClassBinding(refClassObject);
        this.setInternalBinding(binding);
    }

    private JavaType getRefClassObject() {
        DocReferenceClassBinding binding = (DocReferenceClassBinding)this.getInternalBinding(16);
        if (binding != null) {
            return binding.getRefClassObject();
        }
        return null;
    }

    @Override
    public SourceDocTag getOwningTag() {
        return (SourceDocTag)((Object)this.getParentSym());
    }

    @Override
    public String getNormalizedText() {
        if (this.refParameterName != null) {
            return this.refParameterName;
        }
        if (this.refMemberName == null || this.refMemberName.length() == 0) {
            return this.refClassName;
        }
        StringBuilder buffer = new StringBuilder();
        if (this.refClassName != null) {
            buffer.append(this.refClassName);
        }
        buffer.append("#");
        buffer.append(this.refMemberName);
        if (this.refMethodParameters != null) {
            buffer.append('(');
            for (int i = 0; i < this.refMethodParameters.size(); ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append((String)this.refMethodParameters.get(i));
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public String getClassName() {
        return this.refClassName;
    }

    @Override
    public String getMemberName() {
        return this.refMemberName;
    }

    @Override
    public Collection getMethodParameterTypeNames() {
        if (this.refMethodParameters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.refMethodParameters);
    }

    @Override
    public String getParameterName() {
        return this.refParameterName;
    }

    @Override
    public JavaHasType getResolvedObject() {
        return (JavaHasType)this.getCompiledObject();
    }

    @Override
    public SourceFormalParameter getResolvedParameter() {
        if (this.refParameterName == null) {
            return null;
        }
        JavaElement object = this.getCompiledObject();
        if (object instanceof SourceFormalParameter) {
            return (SourceFormalParameter)object;
        }
        return null;
    }

    @Override
    public JavaMember getResolvedMember() {
        if (this.refParameterName != null) {
            return null;
        }
        JavaElement object = this.getCompiledObject();
        if (object instanceof JavaMember) {
            return (JavaMember)object;
        }
        return null;
    }

    @Override
    public JavaType getResolvedClass() {
        JavaElement object = this.getCompiledObject();
        JavaType resolvedClass = this.getRefClassObject();
        if (resolvedClass != null) {
            return resolvedClass;
        }
        if (object == null) {
            if (this.refClassName == null && (this.refMemberName != null || this.refParameterName != null)) {
                return this.getOwningClassSym();
            }
            return null;
        }
        if (object.getElementKind() == 3) {
            return (JavaType)object;
        }
        if (object instanceof JavaMember) {
            JavaMember javaMember = (JavaMember)object;
            return javaMember.getOwningClass();
        }
        if (object.getElementKind() == 7) {
            return this.getOwningClassSym();
        }
        return null;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        DocReferenceSym sym = (DocReferenceSym)super.cloneSelf(targetFile);
        sym.refClassName = this.refClassName;
        sym.refMemberName = this.refMemberName;
        if (this.refMethodParameters != null) {
            sym.refMethodParameters = DocReferenceSym.mutableCopy(this.refMethodParameters);
        }
        sym.refParameterName = this.refParameterName;
        return sym;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 75: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public JavaElement getCompiledObject() {
        JavaHasType currentRefObject = this.getRefObject();
        if (currentRefObject == null) {
            currentRefObject = (JavaHasType)this.resolve();
            this.setRefObject(currentRefObject);
        }
        if (currentRefObject != kEmptyResult) {
            return currentRefObject;
        }
        return null;
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaHasType localRefObject = this.getRefObject();
        if (localRefObject == null) {
            try {
                localRefObject = (JavaHasType)compiler.resolve(this);
                this.setRefObject(localRefObject);
                if (localRefObject == null && this.refClassName != null && this.refMemberName != null) {
                    JavaType classType = compiler.resolveType(this, this.refClassName);
                    this.setRefClassObject(classType);
                }
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        return localRefObject;
    }

    @Override
    void appendDocText(StringBuilder buffer) {
        int bufferLength = buffer.length();
        if (bufferLength > 0 && buffer.charAt(bufferLength - 1) != ' ') {
            buffer.append(' ');
        }
        super.appendDocText(buffer);
    }
}

