/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodBinding;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeBinding;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public class LambdaExpr
extends Expr
implements SourceLambdaExpression {
    private boolean parenthesizedParameters;

    @Override
    public SourceElement getBody() {
        Sym body = this.getChild((byte)2);
        if (body != null) {
            return body;
        }
        List exprChildren = this.getChildren((byte)90);
        if (!exprChildren.isEmpty()) {
            return (SourceElement)exprChildren.get(0);
        }
        return null;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 2: 
            case 12: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 12: {
                return 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public boolean hasFormalParameters() {
        List<SourceLambdaParameter> formalParameters = this.getFormalParameters();
        for (SourceLambdaParameter parameter : formalParameters) {
            if (parameter.isInferredFormalParameter()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceFormalParameterList getFormalParameterList() {
        return this.getFormalsSym();
    }

    public FormalsSym getFormalsSym() {
        return (FormalsSym)this.getChildOrCreateSkeleton((byte)12);
    }

    @Override
    public List<SourceLambdaParameter> getFormalParameters() {
        return this.getFormalsSym().getSourceParameters();
    }

    @Override
    public JavaType[] getFormalParameterTypes() {
        if (!this.hasFormalParameters()) {
            return JavaType.EMPTY_ARRAY;
        }
        List<SourceLambdaParameter> parameters = this.getFormalParameters();
        int count = parameters.size();
        if (count == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] out = new JavaType[count];
        Iterator iterator = parameters.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            JavaVariable variable = (JavaVariable)iterator.next();
            out[i++] = variable.getResolvedType();
        }
        return out;
    }

    @Override
    public boolean hasInferredFormalParameters() {
        List<SourceLambdaParameter> formalParameters = this.getFormalParameters();
        for (SourceLambdaParameter parameter : formalParameters) {
            if (!parameter.isInferredFormalParameter()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaMethod getTargetMethod() {
        this.resolve();
        NodeBinding binding = this.getInternalBinding(17);
        if (binding != null) {
            return ((MethodBinding)binding).getMethod();
        }
        return null;
    }

    @Override
    protected final synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaHasType localExprResolved = this.getExprResolved();
        if (localExprResolved == null) {
            JavaType inferredType = null;
            if (!this.hasInferredFormalParameters()) {
                inferredType = this.getReturnTypeFromReturnsImpl(compiler);
            }
            if (inferredType == null) {
                inferredType = PrimitiveType.getVoidType();
            }
            this.setExprResolved(inferredType);
            localExprResolved = (JavaHasType)this.resolveImplImpl(compiler);
            if (localExprResolved != null) {
                MethodBinding binding = new MethodBinding((JavaMethod)localExprResolved);
                this.setInternalBinding(binding);
            }
            this.setExprResolved(localExprResolved);
            if (localExprResolved != null) {
                JavaType targetReturnType;
                JavaType returnTypeFromReturns;
                NodeBinding binding = this.getInternalBinding(12);
                if (binding == null) {
                    returnTypeFromReturns = this.getReturnTypeFromReturnsImpl(compiler);
                } else {
                    returnTypeFromReturns = ((TypeBinding)binding).getResolvedType();
                    this.clearInternalBinding(12);
                }
                if (returnTypeFromReturns != null && ((targetReturnType = localExprResolved.getResolvedType()) == null || targetReturnType.getElementKind() != 10 && LambdaExpr.hasTypeParameter(targetReturnType, null))) {
                    localExprResolved = returnTypeFromReturns;
                    this.setExprResolved(localExprResolved);
                }
            }
        }
        if (localExprResolved != null) {
            return localExprResolved;
        }
        this.setExprResolved(kEmptyResult);
        return null;
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        boolean isValueCompatible;
        JavaType returnType = null;
        if (this.getFormalParameters().size() == 0 || !this.hasInferredFormalParameters()) {
            returnType = this.getReturnTypeFromReturnsImpl(compiler);
            if (returnType != null) {
                TypeBinding binding = new TypeBinding(returnType);
                this.setInternalBinding(binding);
                isValueCompatible = !PrimitiveType.getVoidType().equals(returnType);
            } else {
                isValueCompatible = this.isValueCompatible();
            }
        } else {
            isValueCompatible = this.isValueCompatible();
        }
        return compiler.resolve(this, returnType, isValueCompatible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        compiler.startLambdaExpressionFlowAnalysis(this);
        try {
            JavaElement javaElement = super.compileImpl(compiler);
            return javaElement;
        }
        finally {
            compiler.endLambdaExpressionFlowAnalysis(this);
        }
    }

    private JavaType getReturnTypeFromReturnsImpl(final CompilerDriver compiler) {
        SourceElement body = this.getBody();
        if (body != null && ((Sym)body).isFilter((byte)90)) {
            return ((Expr)body).getResolvedType();
        }
        final JavaType[] lub = new JavaType[]{null};
        final boolean[] isVoid = new boolean[]{true};
        new SourceVisitor(){

            @Override
            public void whenEnterLambdaExpression(SourceLambdaExpression sourceLambdaExpression) {
                if (sourceLambdaExpression != LambdaExpr.this) {
                    this.cancelSubtree();
                }
            }

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                this.cancelSubtree();
            }

            @Override
            public void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
                SourceExpression expression = sourceReturnStatement.getExpression();
                if (expression != null) {
                    JavaType returnType = expression.getResolvedType();
                    if (returnType == null) {
                        return;
                    }
                    isVoid[0] = false;
                    if (lub[0] == null) {
                        lub[0] = returnType;
                        return;
                    }
                    if (returnType.isPrimitive() && lub[0].isPrimitive()) {
                        if (PrimitiveType.applyNarrowingConversion((PrimitiveType)lub[0], (PrimitiveType)returnType) || PrimitiveType.applyWideningConversion((PrimitiveType)lub[0], (PrimitiveType)returnType)) {
                            lub[0] = returnType;
                        }
                        return;
                    }
                    if (returnType.isPrimitive()) {
                        returnType = PrimitiveType.applyBoxingConversion((PrimitiveType)returnType, compiler.getProvider(), expression.getJdkVersion());
                    }
                    lub[0] = CompilerDriver.leastUpperBound(compiler.getProvider(), lub[0], returnType);
                }
            }
        }.visit(this);
        return isVoid[0] ? PrimitiveType.getVoidType() : lub[0];
    }

    private boolean isValueCompatible() {
        SourceElement body = this.getBody();
        if (body != null && ((Sym)body).isFilter((byte)90)) {
            return true;
        }
        final boolean[] isVoid = new boolean[]{true};
        new SourceVisitor(){

            @Override
            public void whenEnterLambdaExpression(SourceLambdaExpression sourceLambdaExpression) {
                if (sourceLambdaExpression != LambdaExpr.this) {
                    this.cancelSubtree();
                }
            }

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                this.cancelSubtree();
            }

            @Override
            public void whenEnterReturnStatement(SourceReturnStatement sourceReturnStatement) {
                SourceExpression expression = sourceReturnStatement.getExpression();
                if (expression != null) {
                    isVoid[0] = false;
                    this.cancelAll();
                }
            }
        }.visit(this);
        return !isVoid[0];
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public void setParenthesizedParameters(boolean parenthesizedParameters) {
        this.parenthesizedParameters = parenthesizedParameters;
    }

    public boolean hasParenthesizedParameters() {
        return this.parenthesizedParameters;
    }
}

