/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.util.KeywordTable;

public class JavaLexer
extends FastLexer
implements JavaTokens,
LexerToken {
    public static final KeywordTable keyword13Table;
    public static final KeywordTable keyword14Table;
    public static final KeywordTable keyword15Table;
    private static final int TK_EOF = 0;
    private static final int FL_WHITESPACE = 0x1000000;
    private static final int FL_ID_START = 0x2000000;
    private static final int FL_ID_PART = 0x4000000;
    private static final int FL_SIMPLE_OP = 0x8000000;
    private static final int FL_DIGIT = 0x10000000;
    private static final int FL_COMP_EQ_OP = 0x20000000;
    private static final int MASK_TK = 4095;
    private static final int[] lookupTable;
    private short lastToken;
    private int startOffset;
    private int endOffset;
    private boolean recognizeSQLJ;
    private final KeywordTable keywordTable;
    private JdkVersion jdkVersion;

    public JavaLexer() {
        this(JdkVersion.getMaxVersion());
    }

    @Deprecated
    public JavaLexer(byte j2se) {
        this(JdkVersion.getJdkVersion(j2se));
    }

    public JavaLexer(JdkVersion jdkVersion) {
        this.jdkVersion = jdkVersion;
        this.setSkipComments(false);
        this.recognizeSQLJ = true;
        this.setTextBuffer(null);
        this.setPosition(0);
        switch (jdkVersion) {
            case JDK_1_3: {
                this.keywordTable = keyword13Table;
                break;
            }
            case JDK_1_4: {
                this.keywordTable = keyword14Table;
                break;
            }
            default: {
                this.keywordTable = keyword15Table;
            }
        }
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.lastToken = (short)-1;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public void setRecognizeSQLJ(boolean recognizeSQLJ) {
        this.recognizeSQLJ = recognizeSQLJ;
    }

    @Override
    protected boolean isComment(int tk) {
        switch (tk) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getToken() {
        return this.lastToken;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int lex() {
        return this.lex(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int lex(LexerToken lexedToken) {
        block91: {
            this.lastToken = 0;
            try {
                block64: while (true) {
                    char c;
                    this.startOffset = this.currentPos;
                    if ((c = this.textBuffer.getChar(this.currentPos++)) < '\u0100') {
                        int lookupValue = lookupTable[c];
                        if ((lookupValue & 0x1000000) != 0) continue;
                        if ((lookupValue & 0x2000000) != 0) {
                            this.handleIdentifier(c);
                            break;
                        }
                        if ((lookupValue & 0x8000000) != 0) {
                            this.lastToken = (short)(lookupValue & 0xFFF);
                            break;
                        }
                        if ((lookupValue & 0x20000000) != 0) {
                            this.lastToken = (short)(lookupValue & 0xFFF);
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = (short)(lookupValue >> 12 & 0xFFF);
                                ++this.currentPos;
                            }
                            break;
                        }
                        if ((lookupValue & 0x10000000) != 0) {
                            this.lastToken = (short)8;
                            this.handleDecimal(c);
                            break;
                        }
                    }
                    switch (c) {
                        case ':': {
                            if (this.jdkVersion.isJdk8OrAbove() && this.textBuffer.getChar(this.currentPos) == ':') {
                                this.lastToken = (short)81;
                                ++this.currentPos;
                                break block64;
                            }
                            this.lastToken = (short)38;
                            break block64;
                        }
                        case '&': {
                            this.lastToken = (short)34;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '&': {
                                    this.lastToken = (short)52;
                                    ++this.currentPos;
                                    break;
                                }
                                case '=': {
                                    this.lastToken = (short)32;
                                    ++this.currentPos;
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '|': {
                            this.lastToken = (short)36;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '|': {
                                    this.lastToken = (short)54;
                                    ++this.currentPos;
                                    break;
                                }
                                case '=': {
                                    this.lastToken = (short)66;
                                    ++this.currentPos;
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '+': {
                            this.lastToken = (short)67;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '+': {
                                    this.lastToken = (short)48;
                                    ++this.currentPos;
                                    break;
                                }
                                case '=': {
                                    this.lastToken = (short)68;
                                    ++this.currentPos;
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '-': {
                            this.lastToken = (short)59;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '>': {
                                    if (this.jdkVersion.isJdk8OrAbove()) {
                                        this.lastToken = (short)82;
                                        ++this.currentPos;
                                        break;
                                    }
                                    break block91;
                                }
                                case '-': {
                                    this.lastToken = (short)40;
                                    ++this.currentPos;
                                    break;
                                }
                                case '=': {
                                    this.lastToken = (short)60;
                                    ++this.currentPos;
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '<': {
                            this.lastToken = (short)58;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '=': {
                                    this.lastToken = (short)51;
                                    ++this.currentPos;
                                    break;
                                }
                                case '<': {
                                    this.lastToken = (short)56;
                                    ++this.currentPos;
                                    c = this.textBuffer.getChar(this.currentPos);
                                    if (c == '=') {
                                        this.lastToken = (short)57;
                                        ++this.currentPos;
                                    }
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '>': {
                            this.lastToken = (short)46;
                            c = this.textBuffer.getChar(this.currentPos);
                            block37 : switch (c) {
                                case '=': {
                                    this.lastToken = (short)45;
                                    ++this.currentPos;
                                    break;
                                }
                                case '>': {
                                    this.lastToken = (short)73;
                                    ++this.currentPos;
                                    c = this.textBuffer.getChar(this.currentPos);
                                    switch (c) {
                                        case '=': {
                                            this.lastToken = (short)74;
                                            ++this.currentPos;
                                            break block37;
                                        }
                                        case '>': {
                                            this.lastToken = (short)76;
                                            ++this.currentPos;
                                            c = this.textBuffer.getChar(this.currentPos);
                                            if (c != '=') break;
                                            this.lastToken = (short)77;
                                            ++this.currentPos;
                                        }
                                    }
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '/': {
                            this.lastToken = (short)41;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '=': {
                                    this.lastToken = (short)42;
                                    ++this.currentPos;
                                    break;
                                }
                                case '*': {
                                    this.lastToken = (short)25;
                                    ++this.currentPos;
                                    this.skipMultiLineComment();
                                    if (this.textBuffer.getChar(this.startOffset + 2) == '*') {
                                        this.lastToken = (short)26;
                                    }
                                    if (this.skipComments) {
                                        this.lastToken = 0;
                                        continue block64;
                                    }
                                    break block91;
                                }
                                case '/': {
                                    this.lastToken = (short)24;
                                    ++this.currentPos;
                                    this.skipLineComment();
                                    if (this.skipComments) {
                                        this.lastToken = 0;
                                        continue block64;
                                    }
                                    break block91;
                                }
                            }
                            break block64;
                        }
                        case '\"': {
                            this.lastToken = (short)14;
                            this.skipStringLiteral();
                            break block64;
                        }
                        case '\'': {
                            this.lastToken = (short)13;
                            this.skipCharacterLiteral();
                            break block64;
                        }
                        case '.': {
                            this.lastToken = (short)43;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (JavaLexer.isDecimalDigit(c)) {
                                ++this.currentPos;
                                this.skipFloatLiteral(false);
                                break block64;
                            }
                            if (c == '.' && this.textBuffer.getChar(this.currentPos + 1) == '.') {
                                this.lastToken = (short)80;
                                this.currentPos += 2;
                                break block64;
                            }
                            break block91;
                        }
                        case '0': {
                            this.lastToken = (short)8;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case 'X': 
                                case 'x': {
                                    ++this.currentPos;
                                    this.skipHexDigits();
                                    break;
                                }
                                case 'B': 
                                case 'b': {
                                    if (this.jdkVersion.isJdk7OrAbove()) {
                                        ++this.currentPos;
                                        this.skipBinaryDigits();
                                        break;
                                    }
                                    break block91;
                                }
                                case '_': {
                                    if (!this.jdkVersion.isJdk7OrAbove()) break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    ++this.currentPos;
                                    this.skipDecimalDigits();
                                }
                                default: {
                                    c = this.textBuffer.getChar(this.currentPos);
                                    switch (c) {
                                        case '.': {
                                            ++this.currentPos;
                                            this.skipFloatLiteral(false);
                                            break;
                                        }
                                        case 'E': 
                                        case 'e': {
                                            this.skipFloatLiteral(false);
                                            break;
                                        }
                                        case 'L': 
                                        case 'l': {
                                            ++this.currentPos;
                                            this.lastToken = (short)9;
                                            break;
                                        }
                                        case 'F': 
                                        case 'f': {
                                            ++this.currentPos;
                                            this.lastToken = (short)10;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            ++this.currentPos;
                                            this.lastToken = (short)11;
                                            break block91;
                                        }
                                    }
                                    break;
                                }
                            }
                            break block91;
                        }
                        case '#': {
                            if (this.recognizeSQLJ && this.textBuffer.getLength() - this.currentPos >= 3 && this.textBuffer.getChar(this.currentPos) == 's' && this.textBuffer.getChar(this.currentPos + 1) == 'q' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                if (this.textBuffer.getLength() - this.currentPos > 3) {
                                    c = this.textBuffer.getChar(this.currentPos + 3);
                                    if (Character.isWhitespace(c) || c == '{' || c == '[') {
                                        this.lastToken = (short)6;
                                        this.currentPos += 4;
                                        this.skipSQLJStatement();
                                        break block64;
                                    }
                                } else {
                                    this.lastToken = (short)6;
                                    this.currentPos += 3;
                                    this.skipSQLJStatement();
                                    break block64;
                                }
                            }
                        }
                        default: {
                            if (!Character.isJavaIdentifierStart(c)) {
                                this.lastToken = (short)-1;
                                break block64;
                            }
                            this.handleIdentifier(c);
                            break block64;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                } else if (this.lastToken == 4) {
                    int hash = 0;
                    for (int i = this.startOffset; i < this.currentPos; ++i) {
                        char c = this.textBuffer.getChar(i);
                        hash = KeywordTable.computePartialHash(c, hash);
                    }
                    int keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash);
                    if (keyword != -1) {
                        this.lastToken = (short)keyword;
                    }
                }
                if (this.skipComments && this.isComment(this.lastToken)) {
                    this.lastToken = 0;
                    this.startOffset = this.currentPos;
                }
                if (this.lastToken != 25 || this.startOffset + 2 >= this.currentPos || this.textBuffer.getChar(this.startOffset + 2) != '*') break block91;
                this.lastToken = (short)26;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        throw new RuntimeException("Operation not supported");
    }

    private void handleIdentifier(char c) {
        int keyword;
        this.lastToken = (short)4;
        int hash = KeywordTable.computePartialHash(c, 0);
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && (lookupTable[c] & 0x4000000) != 0) {
            hash = KeywordTable.computePartialHash(c, hash);
            ++this.currentPos;
        }
        if (c >= '\u0100') {
            while (Character.isJavaIdentifierPart(c = this.textBuffer.getChar(this.currentPos))) {
                hash = KeywordTable.computePartialHash(c, hash);
                ++this.currentPos;
            }
        }
        if ((keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash)) != -1) {
            this.lastToken = (short)keyword;
        }
    }

    private void handleDecimal(char c) {
        this.lastToken = (short)8;
        this.skipDecimalDigits();
        c = this.textBuffer.getChar(this.currentPos);
        switch (c) {
            case 'L': 
            case 'l': {
                ++this.currentPos;
                this.lastToken = (short)9;
                break;
            }
            case 'F': 
            case 'f': {
                ++this.currentPos;
                this.lastToken = (short)10;
                break;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
                this.lastToken = (short)11;
                break;
            }
            case '.': {
                ++this.currentPos;
                this.skipFloatLiteral(false);
                break;
            }
            case 'E': 
            case 'e': {
                this.skipFloatLiteral(false);
            }
        }
    }

    private void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipCharacterLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\'': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipSQLJStatement() {
        int inBlock = 0;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case ';': {
                    if (0 < inBlock) break;
                    return;
                }
                case '{': {
                    ++inBlock;
                    break;
                }
                case '}': {
                    --inBlock;
                    break;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c == '/') {
                        this.skipLineComment();
                        break;
                    }
                    if (c != '*') break;
                    this.skipMultiLineComment();
                    break;
                }
                case '-': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '-') break;
                    this.skipLineComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    char match = c;
                    while ((c = this.textBuffer.getChar(this.currentPos++)) != match) {
                    }
                    break;
                }
            }
        }
    }

    private void skipFloatLiteral(boolean hexadecimal) {
        this.lastToken = (short)11;
        char c = this.textBuffer.getChar(this.currentPos);
        while (true) {
            boolean accept;
            boolean bl = accept = JavaLexer.isDecimalDigit(c) || hexadecimal && JavaLexer.isHexDigit(c);
            if (!accept) {
                boolean bl2 = accept = c == '_' && this.jdkVersion.isJdk7OrAbove();
            }
            if (!accept) break;
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        boolean acceptExponent = false;
        switch (c) {
            case 'P': 
            case 'p': {
                if (!hexadecimal) break;
                acceptExponent = true;
                break;
            }
            case 'E': 
            case 'e': {
                if (hexadecimal) break;
                acceptExponent = true;
            }
        }
        if (acceptExponent) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
            if (c == '+' || c == '-') {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
            }
            while (JavaLexer.isDecimalDigit(c) || c == '_' && this.jdkVersion.isJdk7OrAbove()) {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
            }
        }
        switch (c) {
            case 'F': 
            case 'f': {
                this.lastToken = (short)10;
            }
            case 'D': 
            case 'd': {
                ++this.currentPos;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (JavaLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos)) || c == '_' && this.jdkVersion.isJdk7OrAbove()) {
            ++this.currentPos;
        }
    }

    private void skipHexDigits() {
        char c;
        while (JavaLexer.isHexDigit(c = this.textBuffer.getChar(this.currentPos)) || c == '_' && this.jdkVersion.isJdk7OrAbove()) {
            ++this.currentPos;
        }
        switch (c) {
            case 'L': 
            case 'l': {
                this.lastToken = (short)9;
                ++this.currentPos;
                break;
            }
            case '.': {
                ++this.currentPos;
            }
            case 'P': 
            case 'p': {
                this.skipFloatLiteral(true);
            }
        }
    }

    private void skipBinaryDigits() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '0': 
                case '1': {
                    break;
                }
                case '_': {
                    break;
                }
                case 'L': 
                case 'l': {
                    this.lastToken = (short)9;
                    ++this.currentPos;
                    return;
                }
                default: {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        if (lexedToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char digit) {
        return '0' <= digit && digit <= '9';
    }

    public static boolean isOctalDigit(char digit) {
        return '0' <= digit && digit <= '7';
    }

    public static boolean isHexDigit(char digit) {
        if ('0' <= digit && digit <= '9') {
            return true;
        }
        if ('a' <= digit && digit <= 'f') {
            return true;
        }
        return 'A' <= digit && digit <= 'F';
    }

    private static void setSimpleOp(int c, int tk) {
        JavaLexer.lookupTable[c] = 0x8000000 | tk & 0xFFF;
    }

    private static void setCompoundEqualsOp(int c, int tk, int tk_equals) {
        JavaLexer.lookupTable[c] = 0x20000000 | tk & 0xFFF | (tk_equals & 0xFFF) << 12;
    }

    public static boolean isJavaIdentifierStart(char c) {
        if (c < '\u0100') {
            return (lookupTable[c] & 0x2000000) != 0;
        }
        return false;
    }

    public static boolean isJavaIdentifierPart(char c) {
        if (c < '\u0100') {
            return (lookupTable[c] & 0x4000000) != 0;
        }
        return false;
    }

    static {
        lookupTable = new int[256];
        if (KW_words.length != 50) {
            System.out.println("Warning: Keyword count mismatch");
        }
        if (DW_words.length != DW_values.length) {
            System.out.println("Warning: Duplicate word count mismatch");
        }
        int dupwordCount = DW_words.length;
        keyword13Table = new KeywordTable(48 + dupwordCount);
        keyword13Table.setCaseSensitivity(true);
        keyword14Table = new KeywordTable(49 + dupwordCount);
        keyword14Table.setCaseSensitivity(true);
        keyword15Table = new KeywordTable(50 + dupwordCount);
        keyword15Table.setCaseSensitivity(true);
        for (int kw = 96; kw < 146; kw = (int)((short)(kw + 1))) {
            if (kw < 144) {
                keyword13Table.addKeyword(KW_words[kw - 96], kw);
            }
            if (kw < 145) {
                keyword14Table.addKeyword(KW_words[kw - 96], kw);
            }
            if (kw >= 146) continue;
            keyword15Table.addKeyword(KW_words[kw - 96], kw);
        }
        for (int i = 0; i < dupwordCount; ++i) {
            keyword13Table.addKeyword(DW_words[i], DW_values[i]);
            keyword14Table.addKeyword(DW_words[i], DW_values[i]);
            keyword15Table.addKeyword(DW_words[i], DW_values[i]);
        }
        char count = lookupTable.length;
        for (char ch = '\u0000'; ch < count; ch = (char)(ch + '\u0001')) {
            int value = 0;
            if (Character.isWhitespace(ch)) {
                value |= 0x1000000;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                value |= 0x2000000;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                value |= 0x4000000;
            }
            if (Character.isDigit(ch) && ch != '0') {
                value |= 0x10000000;
            }
            if (value == 0) continue;
            JavaLexer.lookupTable[ch] = value;
        }
        JavaLexer.setSimpleOp(64, 79);
        JavaLexer.setSimpleOp(123, 49);
        JavaLexer.setSimpleOp(125, 70);
        JavaLexer.setSimpleOp(91, 50);
        JavaLexer.setSimpleOp(93, 71);
        JavaLexer.setSimpleOp(40, 55);
        JavaLexer.setSimpleOp(41, 72);
        JavaLexer.setSimpleOp(44, 39);
        JavaLexer.setSimpleOp(59, 75);
        JavaLexer.setSimpleOp(126, 35);
        JavaLexer.setSimpleOp(63, 69);
        JavaLexer.setCompoundEqualsOp(33, 53, 65);
        JavaLexer.setCompoundEqualsOp(42, 63, 64);
        JavaLexer.setCompoundEqualsOp(61, 33, 44);
        JavaLexer.setCompoundEqualsOp(37, 61, 62);
        JavaLexer.setCompoundEqualsOp(94, 37, 78);
    }
}

