/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public class LexerLiteral
implements JavaConstants {
    private static boolean[] isHexDigit;
    private static boolean[] isOctDigit;
    private static boolean[] isDecDigit;
    private static byte[] hexValue;
    public final short literalToken;
    public short literalError = 0;
    public boolean flag_dw = false;
    public boolean literalBoolean = false;
    public char literalChar = '\u0000';
    public String literalString = null;
    public long literalInteger = 0L;
    public double literalFloat = 0.0;
    private int literalErrorStart = -1;
    private int literalErrorEnd = -1;

    public static LexerLiteral scanConstant(FastLexer lexer) {
        boolean literal;
        int token = lexer.getToken();
        boolean bl = literal = 8 <= token && token < 16;
        if (!literal) {
            return null;
        }
        ReadTextBuffer textBuffer = lexer.getTextBuffer();
        int startOffset = lexer.getStartOffset();
        int endOffset = lexer.getEndOffset();
        return new LexerLiteral(textBuffer, token, startOffset, endOffset);
    }

    public static LexerLiteral scanConstant(LexerToken lexerToken, ReadTextBuffer textBuffer) {
        boolean literal;
        int token = lexerToken.getToken();
        boolean bl = literal = 8 <= token && token < 16;
        if (!literal) {
            return null;
        }
        int startOffset = lexerToken.getStartOffset();
        int endOffset = lexerToken.getEndOffset();
        return new LexerLiteral(textBuffer, token, startOffset, endOffset);
    }

    public static LexerLiteral copyConstant(LexerLiteral source) {
        return new LexerLiteral(source);
    }

    public static LexerLiteral createConstant(Object object) {
        if (object == null) {
            return new LexerLiteral(15);
        }
        if (object instanceof Boolean) {
            LexerLiteral literal = new LexerLiteral(12);
            literal.literalBoolean = (Boolean)object;
            return literal;
        }
        if (object instanceof Character) {
            LexerLiteral literal = new LexerLiteral(13);
            literal.literalChar = ((Character)object).charValue();
            return literal;
        }
        if (object instanceof Integer) {
            LexerLiteral literal = new LexerLiteral(8);
            literal.literalInteger = ((Integer)object).intValue();
            return literal;
        }
        if (object instanceof Long) {
            LexerLiteral literal = new LexerLiteral(9);
            literal.literalInteger = (Long)object;
            return literal;
        }
        if (object instanceof Float) {
            LexerLiteral literal = new LexerLiteral(10);
            literal.literalFloat = ((Float)object).floatValue();
            return literal;
        }
        if (object instanceof Double) {
            LexerLiteral literal = new LexerLiteral(11);
            literal.literalFloat = (Double)object;
            return literal;
        }
        if (object instanceof String) {
            LexerLiteral literal = new LexerLiteral(14);
            literal.literalString = (String)object;
            return literal;
        }
        return null;
    }

    private LexerLiteral(short token) {
        this.literalToken = token;
    }

    private LexerLiteral(LexerLiteral other) {
        this.literalToken = other.literalToken;
        this.literalError = other.literalError;
        this.flag_dw = other.flag_dw;
        this.literalBoolean = other.literalBoolean;
        this.literalChar = other.literalChar;
        this.literalString = other.literalString;
        this.literalInteger = other.literalInteger;
        this.literalFloat = other.literalFloat;
        this.literalErrorStart = other.literalErrorStart;
        this.literalErrorEnd = other.literalErrorEnd;
    }

    private LexerLiteral(ReadTextBuffer textBuffer, int token, int start, int end) {
        this.literalToken = (short)token;
        switch (token) {
            case 12: {
                this.scanBooleanLiteral(textBuffer, start);
                break;
            }
            case 13: {
                this.scanCharLiteral(textBuffer, start, end);
                break;
            }
            case 9: {
                this.flag_dw = true;
                this.scanIntegerLiteral(textBuffer, start, end);
                break;
            }
            case 8: {
                this.scanIntegerLiteral(textBuffer, start, end);
                break;
            }
            case 11: {
                this.flag_dw = true;
            }
            case 10: {
                this.scanFloatLiteral(textBuffer, start, end);
                break;
            }
            case 14: {
                this.scanStringLiteral(textBuffer, start, end);
                break;
            }
            case 15: {
                break;
            }
        }
    }

    private boolean checkUnderscore(ReadTextBuffer buffer, int start, int end, int underscorePos, boolean hexadecimal) {
        char postCh;
        char prevCh;
        boolean isError;
        boolean bl = isError = underscorePos == start || underscorePos == end;
        if (!isError && (prevCh = buffer.getChar(underscorePos - 1)) != '_') {
            if (hexadecimal) {
                isError = prevCh >= '\u0100' || !isHexDigit[prevCh];
            } else {
                boolean bl2 = isError = prevCh >= '\u0100' || !isDecDigit[prevCh];
            }
        }
        if (!isError && (postCh = buffer.getChar(underscorePos + 1)) != '_') {
            if (hexadecimal) {
                isError = postCh >= '\u0100' || !isHexDigit[postCh];
            } else {
                boolean bl3 = isError = postCh >= '\u0100' || !isDecDigit[postCh];
            }
        }
        if (isError) {
            this.literalError = (short)4;
            this.literalErrorStart = start;
            this.literalErrorEnd = end;
            return true;
        }
        return false;
    }

    public Object getConstantValue() {
        switch (this.literalToken) {
            case 12: {
                return this.literalBoolean;
            }
            case 13: {
                return Character.valueOf(this.literalChar);
            }
            case 9: {
                return this.literalInteger;
            }
            case 8: {
                return (int)this.literalInteger;
            }
            case 11: {
                return this.literalFloat;
            }
            case 10: {
                return Float.valueOf((float)this.literalFloat);
            }
            case 14: {
                return this.literalString;
            }
        }
        return null;
    }

    private void scanBooleanLiteral(ReadTextBuffer buffer, int start) {
        this.literalBoolean = buffer.getChar(start) == 't';
    }

    private void scanStringLiteral(ReadTextBuffer buffer, int start, int end) {
        if (buffer.getChar(start) != '\"' || buffer.getChar(end - 1) != '\"') {
            this.literalError = (short)8;
            this.literalErrorStart = start;
            this.literalErrorEnd = end;
        }
        if (end > start + 2) {
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            this.literalString = this.source2string(chars, 0, chars.length, start + 1);
        } else {
            this.literalString = "";
        }
    }

    private void scanCharLiteral(ReadTextBuffer buffer, int start, int end) {
        if (end == start + 2) {
            this.literalError = (short)9;
            this.literalErrorStart = start;
            this.literalErrorEnd = end;
        } else if (end > start + 2) {
            if (buffer.getChar(start) != '\'' || buffer.getChar(end - 1) != '\'') {
                this.literalError = (short)10;
                this.literalErrorStart = start;
                this.literalErrorEnd = end;
            }
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            String string = this.source2string(chars, 0, chars.length, start + 1);
            this.literalChar = string.charAt(0);
            if (string.length() > 1) {
                this.literalError = (short)10;
                this.literalErrorStart = start;
                this.literalErrorEnd = end;
            }
        }
    }

    private void scanIntegerLiteral(ReadTextBuffer buffer, int start, int end) {
        long value = 0L;
        try {
            boolean gotValue = false;
            int pos = start;
            char ch = buffer.getChar(pos++);
            if (ch == '0') {
                if (end == pos) {
                    return;
                }
                if ((ch = buffer.getChar(pos++)) == 'x' || ch == 'X') {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, true)) continue;
                            break;
                        }
                        if (ch >= '\u0100' || !isHexDigit[ch]) break;
                        if ((value & 0xF000000000000000L) != 0L) {
                            this.literalError = (short)5;
                            this.literalErrorStart = start;
                            this.literalErrorEnd = end;
                            break;
                        }
                        value *= 16L;
                        value += (long)hexValue[ch];
                        gotValue = true;
                    }
                } else if (ch == 'b' || ch == 'B') {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, true)) continue;
                            break;
                        }
                        if (ch != '0' && ch != '1') break;
                        if ((value & Long.MIN_VALUE) != 0L) {
                            this.literalError = (short)5;
                            this.literalErrorStart = start;
                            this.literalErrorEnd = end;
                            break;
                        }
                        value *= 2L;
                        value += (long)hexValue[ch];
                        gotValue = true;
                    }
                } else if (ch == 'l' || ch == 'L') {
                    gotValue = true;
                } else {
                    --pos;
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, false)) continue;
                            break;
                        }
                        if (ch < '\u0100' && isOctDigit[ch]) {
                            if ((value & 0xE000000000000000L) != 0L) {
                                this.literalError = (short)5;
                                this.literalErrorStart = start;
                                this.literalErrorEnd = end;
                                break;
                            }
                            value *= 8L;
                            value += (long)hexValue[ch];
                            gotValue = true;
                            continue;
                        }
                        if (!isDecDigit[ch]) break;
                        this.literalError = (short)4;
                        this.literalErrorStart = start;
                        this.literalErrorEnd = end;
                        break;
                    }
                }
                if (!this.flag_dw && value > 0xFFFFFFFFL) {
                    this.literalError = (short)5;
                    this.literalErrorStart = start;
                    this.literalErrorEnd = end;
                }
            } else {
                value = hexValue[ch];
                gotValue = true;
                if (value != 0L) {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, false)) continue;
                            break;
                        }
                        if (ch >= '\u0100' || !isDecDigit[ch]) break;
                        long ov = value;
                        value *= 10L;
                        gotValue = true;
                        if ((value += (long)hexValue[ch]) >= ov || value == Long.MIN_VALUE) continue;
                        this.literalError = (short)5;
                        this.literalErrorStart = start;
                        this.literalErrorEnd = end;
                        break;
                    }
                    if (!this.flag_dw && value > 0x80000000L) {
                        this.literalError = (short)5;
                        this.literalErrorStart = start;
                        this.literalErrorEnd = end;
                    }
                }
            }
            if (!gotValue) {
                this.literalError = (short)4;
                this.literalErrorStart = start;
                this.literalErrorEnd = end;
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.literalInteger = value;
    }

    private boolean isZeroFloating(ReadTextBuffer buffer, int start, int end) {
        boolean afterExponent = false;
        block5: for (int i = start; i < end; ++i) {
            char ch = buffer.getChar(i);
            switch (ch) {
                case '.': 
                case '0': 
                case 'D': 
                case 'F': 
                case 'X': 
                case '_': 
                case 'd': 
                case 'f': 
                case 'x': {
                    continue block5;
                }
                case 'E': 
                case 'P': 
                case 'e': 
                case 'p': {
                    afterExponent = true;
                    continue block5;
                }
                case '+': 
                case '-': 
                case '1': {
                    if (afterExponent) continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private strictfp void scanFloatLiteral(ReadTextBuffer buffer, int start, int end) {
        this.flag_dw = true;
        char ch = buffer.getChar(end - 1);
        boolean includeLast = true;
        if (ch == 'f' || ch == 'F') {
            this.flag_dw = false;
            includeLast = false;
        } else if (ch == 'd' || ch == 'D') {
            includeLast = false;
        }
        int effectiveLength = end - start;
        if (!includeLast) {
            --effectiveLength;
        }
        StringBuilder buf = new StringBuilder();
        boolean hexadecimal = false;
        for (int i = start; i < start + effectiveLength; ++i) {
            ch = buffer.getChar(i);
            if (ch == '_') {
                if (!this.checkUnderscore(buffer, start, end, i, hexadecimal)) continue;
                this.literalFloat = 0.0;
                return;
            }
            if (ch == 'x' || ch == 'X') {
                hexadecimal = true;
            } else if (ch == 'p' || ch == 'P') {
                hexadecimal = false;
            }
            buf.append(ch);
        }
        String text = buf.toString();
        try {
            double value = this.flag_dw ? Double.parseDouble(text) : (double)Float.parseFloat(text);
            if (value == 0.0 && !this.isZeroFloating(buffer, start, end)) {
                this.literalError = (short)6;
                this.literalErrorStart = start;
                this.literalErrorEnd = end;
            } else if (value == Double.POSITIVE_INFINITY) {
                this.literalError = (short)5;
                this.literalErrorStart = start;
                this.literalErrorEnd = end;
            }
            this.literalFloat = value;
        }
        catch (NumberFormatException e) {
            this.literalError = (short)4;
            this.literalErrorStart = start;
            this.literalErrorEnd = end;
        }
    }

    private String source2string(char[] source, int offset, int length, int errorDelta) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        block12: while (i < length) {
            if (source[offset + i] == '\\') {
                int start = offset + i;
                if (i + 1 < length) {
                    switch (source[offset + ++i]) {
                        case 'n': {
                            buffer.append('\n');
                            ++i;
                            continue block12;
                        }
                        case 't': {
                            buffer.append('\t');
                            ++i;
                            continue block12;
                        }
                        case 'b': {
                            buffer.append('\b');
                            ++i;
                            continue block12;
                        }
                        case 'r': {
                            buffer.append('\r');
                            ++i;
                            continue block12;
                        }
                        case 'f': {
                            buffer.append('\f');
                            ++i;
                            continue block12;
                        }
                        case '\'': {
                            buffer.append('\'');
                            ++i;
                            continue block12;
                        }
                        case '\"': {
                            buffer.append('\"');
                            ++i;
                            continue block12;
                        }
                        case '\\': {
                            buffer.append('\\');
                            ++i;
                            continue block12;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            StringBuilder octalValue = new StringBuilder();
                            octalValue.append(source[offset + i]);
                            ++i;
                            for (int count = 1; count < (octalValue.charAt(0) < '4' ? 3 : 2) && i < length && LexerLiteral.isOctalDigit(source[offset + i]); ++count, ++i) {
                                octalValue.append(source[offset + i]);
                            }
                            buffer.append((char)Integer.valueOf(octalValue.toString(), 8).intValue());
                            continue block12;
                        }
                        case 'u': {
                            int l;
                            for (l = i + 1; l < length && source[offset + l] == 'u'; ++l) {
                            }
                            if (l + 4 > length) break;
                            char code = '\u0000';
                            int d = 0;
                            for (int k = 0; k < 4; ++k) {
                                d = LexerLiteral.digit2int(source[offset + l + k], 16);
                                if (d < 0) {
                                    this.literalError = (short)11;
                                    this.literalErrorStart = start + errorDelta;
                                    this.literalErrorEnd = offset + l + k + 1 + errorDelta;
                                    break;
                                }
                                code = (char)(code << 4);
                                code = (char)(code + (char)d);
                            }
                            if (d < 0) break;
                            buffer.append(code);
                            i = l + 4;
                            continue block12;
                        }
                    }
                    this.literalError = (short)11;
                    this.literalErrorStart = start + errorDelta;
                    this.literalErrorEnd = offset + i + 1 + errorDelta;
                } else {
                    this.literalError = (short)11;
                    this.literalErrorStart = start + errorDelta;
                    this.literalErrorEnd = start + 1 + errorDelta;
                }
            }
            char b = source[offset + i++];
            buffer.append(b);
        }
        return buffer.toString();
    }

    private static boolean isOctalDigit(char ch) {
        int intValue = LexerLiteral.digit2int(ch, 10);
        return intValue >= 0 && intValue < 8;
    }

    public static int digit2int(char ch, int base) {
        if ('0' <= ch && ch <= '9' && ch < 48 + base) {
            return ch - 48;
        }
        if ('A' <= ch && ch < 65 + base - 10) {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch < 97 + base - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public int getErrorStart() {
        return this.literalErrorStart;
    }

    public int getErrorEnd() {
        return this.literalErrorEnd;
    }

    static {
        int i;
        isHexDigit = new boolean[256];
        isOctDigit = new boolean[256];
        isDecDigit = new boolean[256];
        hexValue = new byte[256];
        for (i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            LexerLiteral.isOctDigit[i] = true;
            LexerLiteral.isDecDigit[i] = true;
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 48);
        }
        LexerLiteral.isOctDigit[56] = false;
        LexerLiteral.isOctDigit[57] = false;
        for (i = 97; i <= 102; i = (int)((byte)(i + 1))) {
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((byte)(i + 1))) {
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 65 + 10);
        }
    }
}

