/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.List;
import java.util.logging.Level;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;

public class Formatting {
    public static Selection reformatRegion(SourceFile file, int startOffset, int endOffset) {
        FormatRegion region;
        if (!Formatting.canReformat(file)) {
            return null;
        }
        FileSym fileSym = (FileSym)file;
        SourceTransaction transaction = fileSym.getTransaction();
        SourceSavepoint savepoint = null;
        if (transaction != null) {
            savepoint = transaction.savepoint();
        }
        if ((region = fileSym.reformatRegion(startOffset, endOffset)) == null) {
            return null;
        }
        try {
            TokenArray tokenArray = fileSym.getTokenArray();
            int startIndex = region.toIndices.getStartOffset();
            if (startIndex < 0) {
                return null;
            }
            int targetStartOffset = tokenArray.tokenStarts[startIndex];
            if (targetStartOffset < 0) {
                return null;
            }
            int endIndex = region.toIndices.getEndOffset();
            int targetEndOffset = tokenArray.tokenEnds[endIndex];
            int targetLength = targetEndOffset - targetStartOffset;
            return new Selection(targetStartOffset, targetLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JavaParser.getLogger().log(Level.INFO, "Out-of-date token data.", e);
            return null;
        }
    }

    public static boolean reformatSubtree(SourceElement subtree) {
        return subtree.reformatSelf(0);
    }

    public static UndoableEdit reformatSelection(SourceFile file, int start, int end) {
        if (!Formatting.canReformat(file)) {
            return null;
        }
        SourceTransaction rtrans = file.beginTransaction();
        SourceSavepoint rpnt = rtrans.savepoint();
        try {
            Selection selection = Formatting.reformatRegion(file, start, end);
            if (selection == null) {
                throw new Exception();
            }
            UndoableEdit redit = rtrans.commit();
            if (redit == null) {
                throw new Exception();
            }
            return redit;
        }
        catch (Exception e) {
            Assert.println("Aborting edit transaction for reformatting...");
            rtrans.rollback(rpnt);
            return null;
        }
    }

    private static boolean canReformat(SourceFile sourceFile) {
        List<SourceError> errors = sourceFile.getParseErrors();
        for (int x = 0; x < errors.size(); ++x) {
            SourceError error = errors.get(x);
            if (error.getErrorSeverity() < 4) continue;
            return false;
        }
        return true;
    }

    private Formatting() {
    }

    public static class Selection {
        private final int selectionStartOffset;
        private final int selectionLength;

        private Selection(int start, int length) {
            this.selectionStartOffset = start;
            this.selectionLength = length;
        }

        public final int getStartOffset() {
            return this.selectionStartOffset;
        }

        public final int getLength() {
            return this.selectionLength;
        }
    }
}

