/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;

public class SimplifyTypeHelper
implements JavaConstants {
    private final ImportHelper helper;

    public static void simplifyType(SourceElement element) {
        switch (element.getSymbolKind()) {
            case 27: {
                TypeSym typeSym = (TypeSym)element;
                ImportHelper helper = new ImportHelper(typeSym.symFile);
                helper.performAutoImport(typeSym);
                break;
            }
            case 53: {
                DotExpr dotExpr = (DotExpr)element;
                ImportHelper helper = new ImportHelper(dotExpr.symFile);
                helper.performAutoImport(dotExpr);
                break;
            }
            case 73: {
                DocReferenceSym docReferenceSym = (DocReferenceSym)element;
                ImportHelper helper = new ImportHelper(docReferenceSym.symFile);
                helper.performAutoImport(docReferenceSym);
                break;
            }
            case 1: {
                AnnotateSym annotateSym = (AnnotateSym)element;
                ImportHelper helper = new ImportHelper(annotateSym.symFile);
                helper.performAutoImport(annotateSym);
            }
        }
    }

    public static void simplifyAllTypes(SourceElement subtree) {
        Sym sym = (Sym)subtree;
        if (sym == null) {
            throw new IllegalArgumentException("Null argument");
        }
        ImportHelper helper = new ImportHelper(sym.symFile);
        helper.process(sym);
    }

    public static void simplifyAllTypes(SourceFile sourceFile, int[][] ranges) {
        if (ranges == null || sourceFile == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        int start = sourceFile.getStartOffset();
        int end = sourceFile.getEndOffset();
        for (int[] range : ranges) {
            if (range.length == 2 && range[0] < range[1] && range[0] >= start && range[1] <= end) continue;
            throw new IllegalArgumentException("Incorrect range array");
        }
        ImportHelper helper = new ImportHelper((FileSym)sourceFile);
        helper.process(ranges);
    }

    public static SimplifyTypeHelper simplifyTypeName(SourceElement scope, String name) {
        if (scope == null || name == null || !CommonUtilities.isValidQualifiedName(name)) {
            throw new IllegalArgumentException();
        }
        Sym sym = (Sym)scope;
        FileSym fileSym = sym.symFile;
        try {
            return new SimplifyTypeHelper(fileSym, sym, name);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getImportName() {
        return this.helper.getAddImportName();
    }

    public String getSimplifiedName() {
        return this.helper.getSimplifiedName();
    }

    private SimplifyTypeHelper(FileSym fileSym, Sym scope, String name) {
        this.helper = new ImportHelper(fileSym);
        this.helper.performAutoImport(scope, name);
    }
}

