/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.syntax;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.SqlTokens;
import oracle.javatools.parser.plsql.syntax.ParserException;
import oracle.javatools.parser.util.KeywordTable;

abstract class BaseSqlLexer
extends AbstractLexer
implements SqlTokens {
    protected static final int CONTEXT_SIZE = 5;
    private static final int FL_WHITESPACE = 0x1000000;
    private static final int FL_SIMPLE_OP = 0x2000000;
    private static final int FL_ID_START = 0x4000000;
    private static final int FL_ID_PART = 0x8000000;
    private static final int FL_DIGIT = 0x10000000;
    private static final int MASK_TK = 255;
    protected static final int TK_NOT_FOUND = -1;
    private static int[] lookupTable;
    protected int lastToken;
    protected int startOffset;
    protected int endOffset;
    protected int hash;
    private boolean skipComments;
    private KeywordTable keywordTable;

    protected BaseSqlLexer(KeywordTable keywordTable) {
        this.keywordTable = keywordTable;
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
        this.skipComments = false;
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    @Override
    public int lex(LexerToken lexedToken) {
        block63: {
            this.lastToken = 0;
            try {
                block28: while (true) {
                    char c;
                    this.startOffset = this.currentPos;
                    if ((c = this.textBuffer.getChar(this.currentPos++)) < '\u0100') {
                        int lookupValue = lookupTable[c];
                        if ((lookupValue & 0x1000000) != 0) continue;
                        if ((lookupValue & 0x4000000) != 0) {
                            this.handleIdentifier(c);
                            break;
                        }
                        if ((lookupValue & 0x2000000) != 0) {
                            this.lastToken = lookupValue & 0xFF;
                            break;
                        }
                        if ((lookupValue & 0x10000000) != 0) {
                            this.lastToken = 32;
                            this.skipNumericLiteral(c);
                            break;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '(': {
                            this.lastToken = 80;
                            if (this.textBuffer.getChar(this.currentPos) == '+' && this.textBuffer.getChar(this.currentPos + 1) == ')') {
                                this.lastToken = 98;
                                this.currentPos += 2;
                                break block28;
                            }
                            break block63;
                        }
                        case '!': {
                            this.lastToken = 95;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 85;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case '~': {
                            this.lastToken = 8;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 87;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case '^': {
                            this.lastToken = 8;
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                this.lastToken = 86;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case '|': {
                            this.lastToken = 88;
                            if (this.textBuffer.getChar(this.currentPos) == '|') {
                                this.lastToken = 68;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case '.': {
                            this.lastToken = 72;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '.') {
                                this.lastToken = 71;
                                ++this.currentPos;
                                if (this.textBuffer.getChar(this.currentPos) == '.') {
                                    this.lastToken = 73;
                                    ++this.currentPos;
                                    break block28;
                                }
                            } else if (BaseSqlLexer.isDecimalDigit(c)) {
                                this.lastToken = 32;
                                this.skipFloatLiteral();
                                break block28;
                            }
                            break block63;
                        }
                        case '*': {
                            this.lastToken = 97;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 75;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case ':': {
                            this.lastToken = 69;
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '=') {
                                this.lastToken = 66;
                                ++this.currentPos;
                                break block28;
                            }
                            if (c < '\u0100') {
                                if ((lookupTable[c] & 0x14000000) != 0 || c == '\"') {
                                    this.lastToken = 18;
                                }
                            } else if (Character.isJavaIdentifierStart(c)) {
                                this.lastToken = 18;
                            }
                            if (this.lastToken == 18) {
                                boolean isPositionalBind = (lookupTable[c] & 0x10000000) != 0;
                                boolean isQuotedBind = c == '\"';
                                ++this.currentPos;
                                while (true) {
                                    if ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100') {
                                        if (isPositionalBind && (lookupTable[c] & 0x10000000) == 0) break block28;
                                        if (isQuotedBind && c == '\"') {
                                            ++this.currentPos;
                                            break block28;
                                        }
                                        if ((lookupTable[c] & 0x8000000) == 0) {
                                            break block28;
                                        }
                                    } else if (!Character.isJavaIdentifierPart(c)) break block28;
                                    ++this.currentPos;
                                }
                            }
                            break block63;
                        }
                        case '=': {
                            this.lastToken = 74;
                            if (this.textBuffer.getChar(this.currentPos) == '>') {
                                this.lastToken = 65;
                                ++this.currentPos;
                                break block28;
                            }
                            break block63;
                        }
                        case '/': {
                            this.lastToken = 96;
                            if (this.textBuffer.getChar(this.currentPos) == '*') {
                                this.lastToken = 49;
                                ++this.currentPos;
                                this.skipMultiLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block28;
                                }
                            }
                            break block63;
                        }
                        case '-': {
                            this.lastToken = 83;
                            if (this.textBuffer.getChar(this.currentPos) == '-') {
                                this.lastToken = 48;
                                ++this.currentPos;
                                this.skipLineComment();
                                if (this.skipComments) {
                                    this.lastToken = 0;
                                    continue block28;
                                }
                            }
                            break block63;
                        }
                        case '>': {
                            this.lastToken = 76;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '>': {
                                    this.lastToken = 93;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '=': {
                                    this.lastToken = 77;
                                    ++this.currentPos;
                                }
                            }
                            break block28;
                        }
                        case '<': {
                            this.lastToken = 79;
                            c = this.textBuffer.getChar(this.currentPos);
                            switch (c) {
                                case '<': {
                                    this.lastToken = 82;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '>': {
                                    this.lastToken = 84;
                                    ++this.currentPos;
                                    break block28;
                                }
                                case '=': {
                                    this.lastToken = 81;
                                    ++this.currentPos;
                                }
                            }
                            break block28;
                        }
                        case '\'': {
                            this.lastToken = 33;
                            this.skipStringLiteral();
                            break block28;
                        }
                        case '\"': {
                            this.lastToken = 16;
                            this.skipQuotedIdentifier();
                            break block28;
                        }
                        default: {
                            if (Character.isJavaIdentifierStart(c)) {
                                this.handleIdentifier(c);
                                break block28;
                            }
                            this.lastToken = 0;
                            continue block28;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                int keyword;
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    this.startOffset = this.currentPos;
                } else if (this.lastToken == 16 && (keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, this.hash)) != -1) {
                    this.lastToken = keyword;
                }
                if (!this.skipComments || this.lastToken != 48 && this.lastToken != 49) break block63;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        throw new ParserException("Unsupported operation");
    }

    protected final void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '\'') {
                        return;
                    }
                    ++this.currentPos;
                }
            }
        }
    }

    protected final void skipQuotedStringLiteral() {
        char termch;
        this.lastToken = 33;
        ++this.currentPos;
        char delim = this.textBuffer.getChar(this.currentPos++);
        switch (delim) {
            case '{': {
                termch = '}';
                break;
            }
            case '(': {
                termch = ')';
                break;
            }
            case '<': {
                termch = '>';
                break;
            }
            case '[': {
                termch = ']';
                break;
            }
            default: {
                if (Character.isWhitespace(delim)) {
                    return;
                }
                termch = delim;
            }
        }
        char ch = this.textBuffer.getChar(this.currentPos++);
        while (true) {
            if (ch != termch) {
                ch = this.textBuffer.getChar(this.currentPos++);
                continue;
            }
            if ((ch = this.textBuffer.getChar(this.currentPos++)) == '\'') break;
        }
    }

    private void skipQuotedIdentifier() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipNumericLiteral(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.skipDecimalDigits();
                c = this.textBuffer.getChar(this.currentPos);
                switch (c) {
                    case 46: {
                        this.lastToken = 32;
                        c = this.textBuffer.getChar(this.currentPos + 1);
                        this.lastToken = 32;
                        if (c == 46) break;
                        ++this.currentPos;
                        this.lastToken = 32;
                        this.skipFloatLiteral();
                        break;
                    }
                    case 69: 
                    case 101: {
                        this.lastToken = 32;
                        this.skipFloatLiteral();
                    }
                }
                break;
            }
            case 46: {
                ++this.currentPos;
                this.lastToken = 32;
                this.skipFloatLiteral();
            }
        }
    }

    private void skipFloatLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        while (BaseSqlLexer.isDecimalDigit(c)) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (BaseSqlLexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (BaseSqlLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void handleIdentifier(char c) {
        int lookupValue;
        char firstch = c;
        this.lastToken = 16;
        this.hash = KeywordTable.computeInsensitivePartialHash(c, 0);
        while (!((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' ? ((lookupValue = lookupTable[c]) & 0x8000000) == 0 : !Character.isJavaIdentifierPart(c))) {
            this.hash = KeywordTable.computeInsensitivePartialHash(c, this.hash);
            ++this.currentPos;
        }
        int keyword = this.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, this.hash);
        if (keyword != -1) {
            this.lastToken = keyword;
        }
        if (c != '\'') {
            return;
        }
        boolean quote = false;
        boolean alternate = false;
        int length = this.currentPos - this.startOffset;
        switch (length) {
            case 1: {
                switch (firstch) {
                    case 'Q': 
                    case 'q': {
                        quote = true;
                        alternate = true;
                        break;
                    }
                    case 'N': 
                    case 'U': 
                    case 'n': 
                    case 'u': {
                        quote = true;
                    }
                }
                break;
            }
            case 2: {
                char secondch;
                if (firstch != 'n' && firstch != 'N' && firstch != 'u' && firstch != 'U' || (secondch = this.textBuffer.getChar(this.startOffset + 1)) != 'q' && secondch != 'Q') break;
                quote = true;
                alternate = true;
            }
        }
        if (quote) {
            if (alternate) {
                this.skipQuotedStringLiteral();
            } else {
                this.skipStringLiteral();
            }
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        if (lexedToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char digit) {
        switch (digit) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    protected void save_context(Context context) {
        context.currentPos = this.currentPos;
        context.lastToken = this.lastToken;
        context.startOffset = this.startOffset;
        context.endOffset = this.endOffset;
        context.hash = this.hash;
    }

    protected void restore_context(Context context) {
        this.currentPos = context.currentPos;
        this.lastToken = context.lastToken;
        this.startOffset = context.startOffset;
        this.endOffset = context.endOffset;
        this.hash = context.hash;
    }

    private static void initLookup() {
        lookupTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int value = 0;
            if (Character.isWhitespace((char)i)) {
                value |= 0x1000000;
            }
            if (Character.isJavaIdentifierStart((char)i)) {
                value |= 0x4000000;
            }
            if (Character.isJavaIdentifierPart((char)i) || i == 35) {
                value |= 0x8000000;
            }
            if (Character.isDigit((char)i)) {
                value |= 0x10000000;
            }
            BaseSqlLexer.lookupTable[i] = value;
        }
        BaseSqlLexer.setSimpleOp(38, 64);
        BaseSqlLexer.setSimpleOp(43, 90);
        BaseSqlLexer.setSimpleOp(37, 89);
        BaseSqlLexer.setSimpleOp(41, 92);
        BaseSqlLexer.setSimpleOp(44, 70);
        BaseSqlLexer.setSimpleOp(64, 67);
        BaseSqlLexer.setSimpleOp(59, 94);
        BaseSqlLexer.setSimpleOp(91, 78);
        BaseSqlLexer.setSimpleOp(93, 91);
    }

    private static void setSimpleOp(int c, int tk) {
        int n = c;
        lookupTable[n] = lookupTable[n] | (0x2000000 | tk & 0xFF);
    }

    static {
        BaseSqlLexer.initLookup();
    }

    protected static class Context {
        protected int currentPos;
        protected int lastToken;
        protected int startOffset;
        protected int endOffset;
        protected int hash;

        protected Context() {
        }
    }
}

